/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class ResourceKeyArgument<T>
implements ArgumentType<ResourceKey<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_ATTRIBUTE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("attribute.unknown", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_FEATURE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.place.feature.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_STRUCTURE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.place.structure.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID_TEMPLATE_POOL = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.place.jigsaw.invalid", var0));
    final ResourceKey<? extends IRegistry<T>> registryKey;

    public ResourceKeyArgument(ResourceKey<? extends IRegistry<T>> var0) {
        this.registryKey = var0;
    }

    public static <T> ResourceKeyArgument<T> key(ResourceKey<? extends IRegistry<T>> var0) {
        return new ResourceKeyArgument<T>(var0);
    }

    private static <T> ResourceKey<T> getRegistryType(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        ResourceKey var4 = (ResourceKey)var0.getArgument(var1, ResourceKey.class);
        Optional<ResourceKey<T>> var5 = var4.cast(var2);
        return var5.orElseThrow(() -> var3.create((Object)var4));
    }

    private static <T> IRegistry<T> getRegistry(CommandContext<CommandListenerWrapper> var0, ResourceKey<? extends IRegistry<T>> var1) {
        return ((CommandListenerWrapper)var0.getSource()).getServer().registryAccess().registryOrThrow(var1);
    }

    private static <T> Holder<T> getRegistryKeyType(CommandContext<CommandListenerWrapper> var0, String var1, ResourceKey<IRegistry<T>> var2, DynamicCommandExceptionType var3) throws CommandSyntaxException {
        ResourceKey var4 = ResourceKeyArgument.getRegistryType(var0, var1, var2, var3);
        return ResourceKeyArgument.getRegistry(var0, var2).getHolder(var4).orElseThrow(() -> var3.create((Object)var4.location()));
    }

    public static AttributeBase getAttribute(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        ResourceKey var2 = ResourceKeyArgument.getRegistryType(var0, var1, IRegistry.ATTRIBUTE_REGISTRY, ERROR_UNKNOWN_ATTRIBUTE);
        return ResourceKeyArgument.getRegistry(var0, IRegistry.ATTRIBUTE_REGISTRY).getOptional(var2).orElseThrow(() -> ERROR_UNKNOWN_ATTRIBUTE.create((Object)var2.location()));
    }

    public static Holder<WorldGenFeatureConfigured<?, ?>> getConfiguredFeature(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.getRegistryKeyType(var0, var1, IRegistry.CONFIGURED_FEATURE_REGISTRY, ERROR_INVALID_FEATURE);
    }

    public static Holder<Structure> getStructure(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.getRegistryKeyType(var0, var1, IRegistry.STRUCTURE_REGISTRY, ERROR_INVALID_STRUCTURE);
    }

    public static Holder<WorldGenFeatureDefinedStructurePoolTemplate> getStructureTemplatePool(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceKeyArgument.getRegistryKeyType(var0, var1, IRegistry.TEMPLATE_POOL_REGISTRY, ERROR_INVALID_TEMPLATE_POOL);
    }

    public ResourceKey<T> parse(StringReader var0) throws CommandSyntaxException {
        MinecraftKey var1 = MinecraftKey.read(var0);
        return ResourceKey.create(this.registryKey, var1);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        Object object = var0.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider var2 = (ICompletionProvider)object;
            return var2.suggestRegistryElements(this.registryKey, ICompletionProvider.a.ELEMENTS, var1, var0);
        }
        return var1.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class net.minecraft.commands.arguments.ResourceKeyArgument$a<T>
    implements ArgumentTypeInfo<ResourceKeyArgument<T>, a> {
        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            var1.writeResourceLocation(var0.registryKey.location());
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            MinecraftKey var1 = var0.readResourceLocation();
            return new a(ResourceKey.createRegistryKey(var1));
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public a unpack(ResourceKeyArgument<T> var0) {
            return new a(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceKeyArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> registryKey;

            a(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceKeyArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceKeyArgument(this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceKeyArgument<T>, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

