/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;

public interface PreviewedArgument<T>
extends ArgumentType<T> {
    @Nullable
    public static CompletableFuture<IChatBaseComponent> resolvePreviewed(ArgumentCommandNode<?, ?> var0, CommandContextBuilder<CommandListenerWrapper> var1) throws CommandSyntaxException {
        ArgumentType argumentType = var0.getType();
        if (argumentType instanceof PreviewedArgument) {
            PreviewedArgument var2 = (PreviewedArgument)argumentType;
            return var2.resolvePreview(var1, var0.getName());
        }
        return null;
    }

    public static boolean isPreviewed(CommandNode<?> var0) {
        ArgumentCommandNode var1;
        return var0 instanceof ArgumentCommandNode && (var1 = (ArgumentCommandNode)var0).getType() instanceof PreviewedArgument;
    }

    @Nullable
    default public CompletableFuture<IChatBaseComponent> resolvePreview(CommandContextBuilder<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        ParsedArgument var2 = (ParsedArgument)var0.getArguments().get(var1);
        if (var2 != null && this.getValueType().isInstance(var2.getResult())) {
            return this.resolvePreview((CommandListenerWrapper)var0.getSource(), this.getValueType().cast(var2.getResult()));
        }
        return null;
    }

    public CompletableFuture<IChatBaseComponent> resolvePreview(CommandListenerWrapper var1, T var2) throws CommandSyntaxException;

    public Class<T> getValueType();
}

