/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MinecraftEncryption;

public record ArgumentSignatures(long salt, Map<String, byte[]> signatures) {
    private static final int MAX_ARGUMENT_COUNT = 8;
    private static final int MAX_ARGUMENT_NAME_LENGTH = 16;

    public ArgumentSignatures(PacketDataSerializer var02) {
        this(var02.readLong(), var02.readMap(PacketDataSerializer.limitValue(HashMap::new, 8), var0 -> var0.readUtf(16), PacketDataSerializer::readByteArray));
    }

    public static ArgumentSignatures empty() {
        return new ArgumentSignatures(0L, Map.of());
    }

    @Nullable
    public MinecraftEncryption.b get(String var0) {
        byte[] var1 = this.signatures.get(var0);
        if (var1 != null) {
            return new MinecraftEncryption.b(this.salt, var1);
        }
        return null;
    }

    public void write(PacketDataSerializer var02) {
        var02.writeLong(this.salt);
        var02.writeMap(this.signatures, (var0, var1) -> var0.writeUtf((String)var1, 16), PacketDataSerializer::writeByteArray);
    }

    public static Map<String, IChatBaseComponent> collectLastChildPlainSignableComponents(CommandContextBuilder<?> var0) {
        CommandContextBuilder var1 = var0.getLastChild();
        Object2ObjectArrayMap var2 = new Object2ObjectArrayMap();
        for (ParsedCommandNode var4 : var1.getNodes()) {
            ArgumentCommandNode var5;
            CommandNode commandNode = var4.getNode();
            if (!(commandNode instanceof ArgumentCommandNode) || !((commandNode = (var5 = (ArgumentCommandNode)commandNode).getType()) instanceof SignedArgument)) continue;
            SignedArgument var6 = (SignedArgument)commandNode;
            ParsedArgument var7 = (ParsedArgument)var1.getArguments().get(var5.getName());
            if (var7 == null) continue;
            var2.put(var5.getName(), ArgumentSignatures.getPlainComponentUnchecked(var6, var7));
        }
        return var2;
    }

    private static <T> IChatBaseComponent getPlainComponentUnchecked(SignedArgument<T> var0, ParsedArgument<?, ?> var1) {
        return var0.getPlainSignableComponent(var1.getResult());
    }
}

