/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;

public class ArgumentParticle
implements ArgumentType<ParticleParam> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "particle with options");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_PARTICLE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("particle.notFound", var0));

    public static ArgumentParticle particle() {
        return new ArgumentParticle();
    }

    public static ParticleParam getParticle(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (ParticleParam)var0.getArgument(var1, ParticleParam.class);
    }

    public ParticleParam parse(StringReader var0) throws CommandSyntaxException {
        return ArgumentParticle.readParticle(var0);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static ParticleParam readParticle(StringReader var0) throws CommandSyntaxException {
        MinecraftKey var1 = MinecraftKey.read(var0);
        Particle<?> var2 = IRegistry.PARTICLE_TYPE.getOptional(var1).orElseThrow(() -> ERROR_UNKNOWN_PARTICLE.create((Object)var1));
        return ArgumentParticle.readParticle(var0, var2);
    }

    private static <T extends ParticleParam> T readParticle(StringReader var0, Particle<T> var1) throws CommandSyntaxException {
        return var1.getDeserializer().fromCommand(var1, var0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggestResource(IRegistry.PARTICLE_TYPE.keySet(), var1);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

