/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityTypes;

public class ArgumentEntitySummon
implements ArgumentType<MinecraftKey> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:pig", "cow");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_ENTITY = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("entity.notFound", var0));

    public static ArgumentEntitySummon id() {
        return new ArgumentEntitySummon();
    }

    public static MinecraftKey getSummonableEntity(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentEntitySummon.verifyCanSummon((MinecraftKey)var0.getArgument(var1, MinecraftKey.class));
    }

    private static MinecraftKey verifyCanSummon(MinecraftKey var0) throws CommandSyntaxException {
        IRegistry.ENTITY_TYPE.getOptional(var0).filter(EntityTypes::canSummon).orElseThrow(() -> ERROR_UNKNOWN_ENTITY.create((Object)var0));
        return var0;
    }

    public MinecraftKey parse(StringReader var0) throws CommandSyntaxException {
        return ArgumentEntitySummon.verifyCanSummon(MinecraftKey.read(var0));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

