/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatSender;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.FilteredText;
import org.slf4j.Logger;

public class ArgumentChat
implements SignedArgument<b> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");
    static final Logger LOGGER = LogUtils.getLogger();

    public static ArgumentChat message() {
        return new ArgumentChat();
    }

    public static IChatBaseComponent getMessage(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        b var2 = (b)var0.getArgument(var1, b.class);
        return var2.resolveComponent((CommandListenerWrapper)var0.getSource());
    }

    public static a getChatMessage(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        b var2 = (b)var0.getArgument(var1, b.class);
        IChatBaseComponent var3 = var2.resolveComponent((CommandListenerWrapper)var0.getSource());
        CommandSigningContext var4 = ((CommandListenerWrapper)var0.getSource()).getSigningContext();
        MessageSignature var5 = var4.getArgumentSignature(var1);
        boolean var6 = var4.signedArgumentPreview(var1);
        ChatSender var7 = ((CommandListenerWrapper)var0.getSource()).asChatSender();
        if (var5.isValid(var7.uuid())) {
            return new a(var2.text, var3, var5, var6);
        }
        return new a(var2.text, var3, MessageSignature.unsigned(), false);
    }

    public b parse(StringReader var0) throws CommandSyntaxException {
        return b.parseText(var0, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Override
    public IChatBaseComponent getPlainSignableComponent(b var0) {
        return IChatBaseComponent.literal(var0.getText());
    }

    @Override
    public CompletableFuture<IChatBaseComponent> resolvePreview(CommandListenerWrapper var0, b var1) throws CommandSyntaxException {
        return var1.resolveDecoratedComponent(var0);
    }

    @Override
    public Class<b> getValueType() {
        return b.class;
    }

    static void logResolutionFailure(CommandListenerWrapper var0, CompletableFuture<?> var12) {
        var12.exceptionally(var1 -> {
            LOGGER.error("Encountered unexpected exception while resolving chat message argument from '{}'", (Object)var0.getDisplayName().getString(), var1);
            return null;
        });
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class b {
        final String text;
        private final c[] parts;

        public b(String var0, c[] var1) {
            this.text = var0;
            this.parts = var1;
        }

        public String getText() {
            return this.text;
        }

        public c[] getParts() {
            return this.parts;
        }

        CompletableFuture<IChatBaseComponent> resolveDecoratedComponent(CommandListenerWrapper var0) throws CommandSyntaxException {
            IChatBaseComponent var1 = this.resolveComponent(var0);
            CompletableFuture<IChatBaseComponent> var2 = var0.getServer().getChatDecorator().decorate(var0.getPlayer(), var1);
            ArgumentChat.logResolutionFailure(var0, var2);
            return var2;
        }

        IChatBaseComponent resolveComponent(CommandListenerWrapper var0) throws CommandSyntaxException {
            return this.toComponent(var0, var0.hasPermission(2));
        }

        public IChatBaseComponent toComponent(CommandListenerWrapper var0, boolean var1) throws CommandSyntaxException {
            if (this.parts.length == 0 || !var1) {
                return IChatBaseComponent.literal(this.text);
            }
            IChatMutableComponent var2 = IChatBaseComponent.literal(this.text.substring(0, this.parts[0].getStart()));
            int var3 = this.parts[0].getStart();
            for (c var7 : this.parts) {
                IChatBaseComponent var8 = var7.toComponent(var0);
                if (var3 < var7.getStart()) {
                    var2.append(this.text.substring(var3, var7.getStart()));
                }
                if (var8 != null) {
                    var2.append(var8);
                }
                var3 = var7.getEnd();
            }
            if (var3 < this.text.length()) {
                var2.append(this.text.substring(var3));
            }
            return var2;
        }

        public static b parseText(StringReader var0, boolean var1) throws CommandSyntaxException {
            String var2 = var0.getString().substring(var0.getCursor(), var0.getTotalLength());
            if (!var1) {
                var0.setCursor(var0.getTotalLength());
                return new b(var2, new c[0]);
            }
            ArrayList var3 = Lists.newArrayList();
            int var4 = var0.getCursor();
            while (var0.canRead()) {
                if (var0.peek() == '@') {
                    EntitySelector var6;
                    int var5 = var0.getCursor();
                    try {
                        ArgumentParserSelector var7 = new ArgumentParserSelector(var0);
                        var6 = var7.parse();
                    }
                    catch (CommandSyntaxException var7) {
                        if (var7.getType() == ArgumentParserSelector.ERROR_MISSING_SELECTOR_TYPE || var7.getType() == ArgumentParserSelector.ERROR_UNKNOWN_SELECTOR_TYPE) {
                            var0.setCursor(var5 + 1);
                            continue;
                        }
                        throw var7;
                    }
                    var3.add(new c(var5 - var4, var0.getCursor() - var4, var6));
                    continue;
                }
                var0.skip();
            }
            return new b(var2, var3.toArray(new c[0]));
        }
    }

    public record a(String plain, IChatBaseComponent formatted, MessageSignature signature, boolean signedPreview) {
        public CompletableFuture<FilteredText<PlayerChatMessage>> resolve(CommandListenerWrapper var0) {
            CompletionStage var12 = ((CompletableFuture)this.filterComponent(var0, this.formatted).thenComposeAsync(var1 -> {
                ChatDecorator var2 = var0.getServer().getChatDecorator();
                return var2.decorateChat(var0.getPlayer(), (FilteredText<IChatBaseComponent>)var1, this.signature, this.signedPreview);
            }, (Executor)var0.getServer())).thenApply(var1 -> {
                PlayerChatMessage var2 = this.getSignedMessage((FilteredText<PlayerChatMessage>)var1);
                if (var2 != null) {
                    this.verify(var0, var2);
                }
                return var1;
            });
            ArgumentChat.logResolutionFailure(var0, var12);
            return var12;
        }

        @Nullable
        private PlayerChatMessage getSignedMessage(FilteredText<PlayerChatMessage> var0) {
            if (this.signature.isValid()) {
                return this.signedPreview ? var0.raw() : PlayerChatMessage.signed(this.plain, this.signature);
            }
            return null;
        }

        private void verify(CommandListenerWrapper var0, PlayerChatMessage var1) {
            if (!var1.verify(var0)) {
                LOGGER.warn("{} sent message with invalid signature: '{}'", (Object)var0.getDisplayName().getString(), (Object)var1.signedContent().getString());
            }
        }

        private CompletableFuture<FilteredText<IChatBaseComponent>> filterComponent(CommandListenerWrapper var0, IChatBaseComponent var1) {
            EntityPlayer var2 = var0.getPlayer();
            if (var2 != null) {
                return var2.getTextFilter().processStreamComponent(var1);
            }
            return CompletableFuture.completedFuture(FilteredText.passThrough(var1));
        }
    }

    public static class c {
        private final int start;
        private final int end;
        private final EntitySelector selector;

        public c(int var0, int var1, EntitySelector var2) {
            this.start = var0;
            this.end = var1;
            this.selector = var2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public EntitySelector getSelector() {
            return this.selector;
        }

        @Nullable
        public IChatBaseComponent toComponent(CommandListenerWrapper var0) throws CommandSyntaxException {
            return EntitySelector.joinNames(this.selector.findEntities(var0));
        }
    }
}

