/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootDeserializationContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MinecraftKey id;
    private final LootPredicateManager predicateManager;
    private final Gson predicateGson = LootSerialization.createConditionSerializer().create();

    public LootDeserializationContext(MinecraftKey var0, LootPredicateManager var1) {
        this.id = var0;
        this.predicateManager = var1;
    }

    public final LootItemCondition[] deserializeConditions(JsonArray var02, String var12, LootContextParameterSet var22) {
        LootItemCondition[] var3 = (LootItemCondition[])this.predicateGson.fromJson((JsonElement)var02, LootItemCondition[].class);
        LootCollector var4 = new LootCollector(var22, this.predicateManager::get, var0 -> null);
        for (LootItemCondition var8 : var3) {
            var8.validate(var4);
            var4.getProblems().forEach((var1, var2) -> LOGGER.warn("Found validation problem in advancement trigger {}/{}: {}", new Object[]{var12, var1, var2}));
        }
        return var3;
    }

    public MinecraftKey getAdvancementId() {
        return this.id;
    }
}

