/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionInOpenWater;
import net.minecraft.advancements.critereon.CriterionConditionPlayer;
import net.minecraft.advancements.critereon.EntityVariantPredicate;
import net.minecraft.advancements.critereon.LighthingBoltPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.IRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.phys.Vec3D;

public interface EntitySubPredicate {
    public static final EntitySubPredicate ANY = new EntitySubPredicate(){

        @Override
        public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var2) {
            return true;
        }

        @Override
        public JsonObject serializeCustomData() {
            return new JsonObject();
        }

        @Override
        public a type() {
            return b.ANY;
        }
    };

    public static EntitySubPredicate fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "type_specific");
        String var2 = ChatDeserializer.getAsString(var1, "type", null);
        if (var2 == null) {
            return ANY;
        }
        a var3 = (a)b.TYPES.get((Object)var2);
        if (var3 == null) {
            throw new JsonSyntaxException("Unknown sub-predicate type: " + var2);
        }
        return var3.deserialize(var1);
    }

    public boolean matches(Entity var1, WorldServer var2, @Nullable Vec3D var3);

    public JsonObject serializeCustomData();

    default public JsonElement serialize() {
        if (this.type() == b.ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = this.serializeCustomData();
        String var1 = (String)b.TYPES.inverse().get((Object)this.type());
        var0.addProperty("type", var1);
        return var0;
    }

    public a type();

    public static EntitySubPredicate variant(CatVariant var0) {
        return b.CAT.createPredicate(var0);
    }

    public static EntitySubPredicate variant(FrogVariant var0) {
        return b.FROG.createPredicate(var0);
    }

    public static final class b {
        public static final a ANY = var0 -> ANY;
        public static final a LIGHTNING = LighthingBoltPredicate::fromJson;
        public static final a FISHING_HOOK = CriterionConditionInOpenWater::fromJson;
        public static final a PLAYER = CriterionConditionPlayer::fromJson;
        public static final a SLIME = SlimePredicate::fromJson;
        public static final EntityVariantPredicate<CatVariant> CAT = EntityVariantPredicate.create(IRegistry.CAT_VARIANT, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityCat) {
                EntityCat var1 = (EntityCat)var0;
                optional = Optional.of(var1.getCatVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<FrogVariant> FROG = EntityVariantPredicate.create(IRegistry.FROG_VARIANT, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Frog) {
                Frog var1 = (Frog)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final BiMap<String, a> TYPES = ImmutableBiMap.of((Object)"any", (Object)ANY, (Object)"lightning", (Object)LIGHTNING, (Object)"fishing_hook", (Object)FISHING_HOOK, (Object)"player", (Object)PLAYER, (Object)"slime", (Object)SLIME, (Object)"cat", (Object)CAT.type(), (Object)"frog", (Object)FROG.type());
    }

    public static interface a {
        public EntitySubPredicate deserialize(JsonObject var1);
    }
}

