/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.alchemy.PotionRegistry;

public class CriterionTriggerBrewedPotion
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("brewed_potion");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, CriterionConditionEntity.b var1, LootDeserializationContext var2) {
        PotionRegistry var3 = null;
        if (var0.has("potion")) {
            MinecraftKey var4 = new MinecraftKey(ChatDeserializer.getAsString(var0, "potion"));
            var3 = IRegistry.POTION.getOptional(var4).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + var4 + "'"));
        }
        return new a(var1, var3);
    }

    public void trigger(EntityPlayer var0, PotionRegistry var12) {
        this.trigger(var0, (T var1) -> var1.matches(var12));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, CriterionConditionEntity.b b2, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, b2, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        @Nullable
        private final PotionRegistry potion;

        public a(CriterionConditionEntity.b var0, @Nullable PotionRegistry var1) {
            super(ID, var0);
            this.potion = var1;
        }

        public static a brewedPotion() {
            return new a(CriterionConditionEntity.b.ANY, null);
        }

        public boolean matches(PotionRegistry var0) {
            return this.potion == null || this.potion == var0;
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            if (this.potion != null) {
                var1.addProperty("potion", IRegistry.POTION.getKey(this.potion).toString());
            }
            return var1;
        }
    }
}

