/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.enchantment.Enchantment;

public class CriterionConditionEnchantments {
    public static final CriterionConditionEnchantments ANY = new CriterionConditionEnchantments();
    public static final CriterionConditionEnchantments[] NONE = new CriterionConditionEnchantments[0];
    @Nullable
    private final Enchantment enchantment;
    private final CriterionConditionValue.IntegerRange level;

    public CriterionConditionEnchantments() {
        this.enchantment = null;
        this.level = CriterionConditionValue.IntegerRange.ANY;
    }

    public CriterionConditionEnchantments(@Nullable Enchantment var0, CriterionConditionValue.IntegerRange var1) {
        this.enchantment = var0;
        this.level = var1;
    }

    public boolean containedIn(Map<Enchantment, Integer> var0) {
        if (this.enchantment != null) {
            if (!var0.containsKey(this.enchantment)) {
                return false;
            }
            int var1 = var0.get(this.enchantment);
            if (this.level != CriterionConditionValue.IntegerRange.ANY && !this.level.matches(var1)) {
                return false;
            }
        } else if (this.level != CriterionConditionValue.IntegerRange.ANY) {
            for (Integer var2 : var0.values()) {
                if (!this.level.matches(var2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (this.enchantment != null) {
            var0.addProperty("enchantment", IRegistry.ENCHANTMENT.getKey(this.enchantment).toString());
        }
        var0.add("levels", this.level.serializeToJson());
        return var0;
    }

    public static CriterionConditionEnchantments fromJson(@Nullable JsonElement var0) {
        Object var3;
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "enchantment");
        Enchantment var2 = null;
        if (var1.has("enchantment")) {
            var3 = new MinecraftKey(ChatDeserializer.getAsString(var1, "enchantment"));
            var2 = IRegistry.ENCHANTMENT.getOptional((MinecraftKey)var3).orElseThrow(() -> CriterionConditionEnchantments.a((MinecraftKey)var3));
        }
        var3 = CriterionConditionValue.IntegerRange.fromJson(var1.get("levels"));
        return new CriterionConditionEnchantments(var2, (CriterionConditionValue.IntegerRange)var3);
    }

    public static CriterionConditionEnchantments[] fromJsonArray(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return NONE;
        }
        JsonArray var1 = ChatDeserializer.convertToJsonArray(var0, "enchantments");
        CriterionConditionEnchantments[] var2 = new CriterionConditionEnchantments[var1.size()];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            var2[var3] = CriterionConditionEnchantments.fromJson(var1.get(var3));
        }
        return var2;
    }

    private static /* synthetic */ JsonSyntaxException a(MinecraftKey var0) {
        return new JsonSyntaxException("Unknown enchantment '" + var0 + "'");
    }
}

