/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import java.nio.FloatBuffer;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.Triple;

public final class Matrix3f {
    private static final int ORDER = 3;
    private static final float G = 3.0f + 2.0f * (float)Math.sqrt(2.0);
    private static final float CS = (float)Math.cos(0.39269908169872414);
    private static final float SS = (float)Math.sin(0.39269908169872414);
    private static final float SQ2 = 1.0f / (float)Math.sqrt(2.0);
    protected float m00;
    protected float m01;
    protected float m02;
    protected float m10;
    protected float m11;
    protected float m12;
    protected float m20;
    protected float m21;
    protected float m22;

    public Matrix3f() {
    }

    public Matrix3f(Quaternion var0) {
        float var1 = var0.i();
        float var2 = var0.j();
        float var3 = var0.k();
        float var4 = var0.r();
        float var5 = 2.0f * var1 * var1;
        float var6 = 2.0f * var2 * var2;
        float var7 = 2.0f * var3 * var3;
        this.m00 = 1.0f - var6 - var7;
        this.m11 = 1.0f - var7 - var5;
        this.m22 = 1.0f - var5 - var6;
        float var8 = var1 * var2;
        float var9 = var2 * var3;
        float var10 = var3 * var1;
        float var11 = var1 * var4;
        float var12 = var2 * var4;
        float var13 = var3 * var4;
        this.m10 = 2.0f * (var8 + var13);
        this.m01 = 2.0f * (var8 - var13);
        this.m20 = 2.0f * (var10 - var12);
        this.m02 = 2.0f * (var10 + var12);
        this.m21 = 2.0f * (var9 + var11);
        this.m12 = 2.0f * (var9 - var11);
    }

    public static Matrix3f createScaleMatrix(float var0, float var1, float var2) {
        Matrix3f var3 = new Matrix3f();
        var3.m00 = var0;
        var3.m11 = var1;
        var3.m22 = var2;
        return var3;
    }

    public Matrix3f(Matrix4f var0) {
        this.m00 = var0.m00;
        this.m01 = var0.m01;
        this.m02 = var0.m02;
        this.m10 = var0.m10;
        this.m11 = var0.m11;
        this.m12 = var0.m12;
        this.m20 = var0.m20;
        this.m21 = var0.m21;
        this.m22 = var0.m22;
    }

    public Matrix3f(Matrix3f var0) {
        this.m00 = var0.m00;
        this.m01 = var0.m01;
        this.m02 = var0.m02;
        this.m10 = var0.m10;
        this.m11 = var0.m11;
        this.m12 = var0.m12;
        this.m20 = var0.m20;
        this.m21 = var0.m21;
        this.m22 = var0.m22;
    }

    private static Pair<Float, Float> approxGivensQuat(float var0, float var1, float var2) {
        float var4 = var1;
        float var3 = 2.0f * (var0 - var2);
        if (G * var4 * var4 < var3 * var3) {
            float var5 = MathHelper.fastInvSqrt(var4 * var4 + var3 * var3);
            return Pair.of((Object)Float.valueOf(var5 * var4), (Object)Float.valueOf(var5 * var3));
        }
        return Pair.of((Object)Float.valueOf(SS), (Object)Float.valueOf(CS));
    }

    private static Pair<Float, Float> qrGivensQuat(float var0, float var1) {
        float var5;
        float var2 = (float)Math.hypot(var0, var1);
        float var3 = var2 > 1.0E-6f ? var1 : 0.0f;
        float var4 = Math.abs(var0) + Math.max(var2, 1.0E-6f);
        if (var0 < 0.0f) {
            var5 = var3;
            var3 = var4;
            var4 = var5;
        }
        var5 = MathHelper.fastInvSqrt(var4 * var4 + var3 * var3);
        return Pair.of((Object)Float.valueOf(var3 *= var5), (Object)Float.valueOf(var4 *= var5));
    }

    private static Quaternion stepJacobi(Matrix3f var0) {
        float var9;
        float var8;
        float var7;
        Quaternion var6;
        Float var5;
        Float var4;
        Pair<Float, Float> var3;
        Matrix3f var1 = new Matrix3f();
        Quaternion var2 = Quaternion.ONE.copy();
        if (var0.m01 * var0.m01 + var0.m10 * var0.m10 > 1.0E-6f) {
            var3 = Matrix3f.approxGivensQuat(var0.m00, 0.5f * (var0.m01 + var0.m10), var0.m11);
            var4 = (Float)var3.getFirst();
            var5 = (Float)var3.getSecond();
            var6 = new Quaternion(0.0f, 0.0f, var4.floatValue(), var5.floatValue());
            var7 = var5.floatValue() * var5.floatValue() - var4.floatValue() * var4.floatValue();
            var8 = -2.0f * var4.floatValue() * var5.floatValue();
            var9 = var5.floatValue() * var5.floatValue() + var4.floatValue() * var4.floatValue();
            var2.mul(var6);
            var1.setIdentity();
            var1.m00 = var7;
            var1.m11 = var7;
            var1.m10 = -var8;
            var1.m01 = var8;
            var1.m22 = var9;
            var0.mul(var1);
            var1.transpose();
            var1.mul(var0);
            var0.load(var1);
        }
        if (var0.m02 * var0.m02 + var0.m20 * var0.m20 > 1.0E-6f) {
            var3 = Matrix3f.approxGivensQuat(var0.m00, 0.5f * (var0.m02 + var0.m20), var0.m22);
            float var42 = -((Float)var3.getFirst()).floatValue();
            var5 = (Float)var3.getSecond();
            var6 = new Quaternion(0.0f, var42, 0.0f, var5.floatValue());
            var7 = var5.floatValue() * var5.floatValue() - var42 * var42;
            var8 = -2.0f * var42 * var5.floatValue();
            var9 = var5.floatValue() * var5.floatValue() + var42 * var42;
            var2.mul(var6);
            var1.setIdentity();
            var1.m00 = var7;
            var1.m22 = var7;
            var1.m20 = var8;
            var1.m02 = -var8;
            var1.m11 = var9;
            var0.mul(var1);
            var1.transpose();
            var1.mul(var0);
            var0.load(var1);
        }
        if (var0.m12 * var0.m12 + var0.m21 * var0.m21 > 1.0E-6f) {
            var3 = Matrix3f.approxGivensQuat(var0.m11, 0.5f * (var0.m12 + var0.m21), var0.m22);
            var4 = (Float)var3.getFirst();
            var5 = (Float)var3.getSecond();
            var6 = new Quaternion(var4.floatValue(), 0.0f, 0.0f, var5.floatValue());
            var7 = var5.floatValue() * var5.floatValue() - var4.floatValue() * var4.floatValue();
            var8 = -2.0f * var4.floatValue() * var5.floatValue();
            var9 = var5.floatValue() * var5.floatValue() + var4.floatValue() * var4.floatValue();
            var2.mul(var6);
            var1.setIdentity();
            var1.m11 = var7;
            var1.m22 = var7;
            var1.m21 = -var8;
            var1.m12 = var8;
            var1.m00 = var9;
            var0.mul(var1);
            var1.transpose();
            var1.mul(var0);
            var0.load(var1);
        }
        return var2;
    }

    private static void sortSingularValues(Matrix3f var0, Quaternion var1) {
        Quaternion var6;
        float var2;
        float var3 = var0.m00 * var0.m00 + var0.m10 * var0.m10 + var0.m20 * var0.m20;
        float var4 = var0.m01 * var0.m01 + var0.m11 * var0.m11 + var0.m21 * var0.m21;
        float var5 = var0.m02 * var0.m02 + var0.m12 * var0.m12 + var0.m22 * var0.m22;
        if (var3 < var4) {
            var2 = var0.m10;
            var0.m10 = -var0.m00;
            var0.m00 = var2;
            var2 = var0.m11;
            var0.m11 = -var0.m01;
            var0.m01 = var2;
            var2 = var0.m12;
            var0.m12 = -var0.m02;
            var0.m02 = var2;
            var6 = new Quaternion(0.0f, 0.0f, SQ2, SQ2);
            var1.mul(var6);
            var2 = var3;
            var3 = var4;
            var4 = var2;
        }
        if (var3 < var5) {
            var2 = var0.m20;
            var0.m20 = -var0.m00;
            var0.m00 = var2;
            var2 = var0.m21;
            var0.m21 = -var0.m01;
            var0.m01 = var2;
            var2 = var0.m22;
            var0.m22 = -var0.m02;
            var0.m02 = var2;
            var6 = new Quaternion(0.0f, SQ2, 0.0f, SQ2);
            var1.mul(var6);
            var5 = var3;
        }
        if (var4 < var5) {
            var2 = var0.m20;
            var0.m20 = -var0.m10;
            var0.m10 = var2;
            var2 = var0.m21;
            var0.m21 = -var0.m11;
            var0.m11 = var2;
            var2 = var0.m22;
            var0.m22 = -var0.m12;
            var0.m12 = var2;
            var6 = new Quaternion(SQ2, 0.0f, 0.0f, SQ2);
            var1.mul(var6);
        }
    }

    public void transpose() {
        float var0 = this.m01;
        this.m01 = this.m10;
        this.m10 = var0;
        var0 = this.m02;
        this.m02 = this.m20;
        this.m20 = var0;
        var0 = this.m12;
        this.m12 = this.m21;
        this.m21 = var0;
    }

    public Triple<Quaternion, Vector3fa, Quaternion> svdDecompose() {
        Quaternion var0 = Quaternion.ONE.copy();
        Quaternion var1 = Quaternion.ONE.copy();
        Matrix3f var2 = this.copy();
        var2.transpose();
        var2.mul(this);
        for (int var3 = 0; var3 < 5; ++var3) {
            var1.mul(Matrix3f.stepJacobi(var2));
        }
        var1.normalize();
        Matrix3f var3 = new Matrix3f(this);
        var3.mul(new Matrix3f(var1));
        float var5 = 1.0f;
        Pair<Float, Float> var4 = Matrix3f.qrGivensQuat(var3.m00, var3.m10);
        Float var6 = (Float)var4.getFirst();
        Float var7 = (Float)var4.getSecond();
        float var8 = var7.floatValue() * var7.floatValue() - var6.floatValue() * var6.floatValue();
        float var9 = -2.0f * var6.floatValue() * var7.floatValue();
        float var10 = var7.floatValue() * var7.floatValue() + var6.floatValue() * var6.floatValue();
        Quaternion var11 = new Quaternion(0.0f, 0.0f, var6.floatValue(), var7.floatValue());
        var0.mul(var11);
        Matrix3f var12 = new Matrix3f();
        var12.setIdentity();
        var12.m00 = var8;
        var12.m11 = var8;
        var12.m10 = var9;
        var12.m01 = -var9;
        var12.m22 = var10;
        var5 *= var10;
        var12.mul(var3);
        var4 = Matrix3f.qrGivensQuat(var12.m00, var12.m20);
        float var13 = -((Float)var4.getFirst()).floatValue();
        Float var14 = (Float)var4.getSecond();
        float var15 = var14.floatValue() * var14.floatValue() - var13 * var13;
        float var16 = -2.0f * var13 * var14.floatValue();
        float var17 = var14.floatValue() * var14.floatValue() + var13 * var13;
        Quaternion var18 = new Quaternion(0.0f, var13, 0.0f, var14.floatValue());
        var0.mul(var18);
        Matrix3f var19 = new Matrix3f();
        var19.setIdentity();
        var19.m00 = var15;
        var19.m22 = var15;
        var19.m20 = -var16;
        var19.m02 = var16;
        var19.m11 = var17;
        var5 *= var17;
        var19.mul(var12);
        var4 = Matrix3f.qrGivensQuat(var19.m11, var19.m21);
        Float var20 = (Float)var4.getFirst();
        Float var21 = (Float)var4.getSecond();
        float var22 = var21.floatValue() * var21.floatValue() - var20.floatValue() * var20.floatValue();
        float var23 = -2.0f * var20.floatValue() * var21.floatValue();
        float var24 = var21.floatValue() * var21.floatValue() + var20.floatValue() * var20.floatValue();
        Quaternion var25 = new Quaternion(var20.floatValue(), 0.0f, 0.0f, var21.floatValue());
        var0.mul(var25);
        Matrix3f var26 = new Matrix3f();
        var26.setIdentity();
        var26.m11 = var22;
        var26.m22 = var22;
        var26.m21 = var23;
        var26.m12 = -var23;
        var26.m00 = var24;
        var5 *= var24;
        var26.mul(var19);
        var5 = 1.0f / var5;
        var0.mul((float)Math.sqrt(var5));
        Vector3fa var27 = new Vector3fa(var26.m00 * var5, var26.m11 * var5, var26.m22 * var5);
        return Triple.of((Object)var0, (Object)var27, (Object)var1);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Matrix3f var1 = (Matrix3f)var0;
        return Float.compare(var1.m00, this.m00) == 0 && Float.compare(var1.m01, this.m01) == 0 && Float.compare(var1.m02, this.m02) == 0 && Float.compare(var1.m10, this.m10) == 0 && Float.compare(var1.m11, this.m11) == 0 && Float.compare(var1.m12, this.m12) == 0 && Float.compare(var1.m20, this.m20) == 0 && Float.compare(var1.m21, this.m21) == 0 && Float.compare(var1.m22, this.m22) == 0;
    }

    public int hashCode() {
        int var0 = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        var0 = 31 * var0 + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        var0 = 31 * var0 + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        var0 = 31 * var0 + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        var0 = 31 * var0 + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        var0 = 31 * var0 + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        var0 = 31 * var0 + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        var0 = 31 * var0 + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        var0 = 31 * var0 + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        return var0;
    }

    private static int bufferIndex(int var0, int var1) {
        return var1 * 3 + var0;
    }

    public void load(FloatBuffer var0) {
        this.m00 = var0.get(Matrix3f.bufferIndex(0, 0));
        this.m01 = var0.get(Matrix3f.bufferIndex(0, 1));
        this.m02 = var0.get(Matrix3f.bufferIndex(0, 2));
        this.m10 = var0.get(Matrix3f.bufferIndex(1, 0));
        this.m11 = var0.get(Matrix3f.bufferIndex(1, 1));
        this.m12 = var0.get(Matrix3f.bufferIndex(1, 2));
        this.m20 = var0.get(Matrix3f.bufferIndex(2, 0));
        this.m21 = var0.get(Matrix3f.bufferIndex(2, 1));
        this.m22 = var0.get(Matrix3f.bufferIndex(2, 2));
    }

    public void loadTransposed(FloatBuffer var0) {
        this.m00 = var0.get(Matrix3f.bufferIndex(0, 0));
        this.m01 = var0.get(Matrix3f.bufferIndex(1, 0));
        this.m02 = var0.get(Matrix3f.bufferIndex(2, 0));
        this.m10 = var0.get(Matrix3f.bufferIndex(0, 1));
        this.m11 = var0.get(Matrix3f.bufferIndex(1, 1));
        this.m12 = var0.get(Matrix3f.bufferIndex(2, 1));
        this.m20 = var0.get(Matrix3f.bufferIndex(0, 2));
        this.m21 = var0.get(Matrix3f.bufferIndex(1, 2));
        this.m22 = var0.get(Matrix3f.bufferIndex(2, 2));
    }

    public void load(FloatBuffer var0, boolean var1) {
        if (var1) {
            this.loadTransposed(var0);
        } else {
            this.load(var0);
        }
    }

    public void load(Matrix3f var0) {
        this.m00 = var0.m00;
        this.m01 = var0.m01;
        this.m02 = var0.m02;
        this.m10 = var0.m10;
        this.m11 = var0.m11;
        this.m12 = var0.m12;
        this.m20 = var0.m20;
        this.m21 = var0.m21;
        this.m22 = var0.m22;
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        var0.append("Matrix3f:\n");
        var0.append(this.m00);
        var0.append(" ");
        var0.append(this.m01);
        var0.append(" ");
        var0.append(this.m02);
        var0.append("\n");
        var0.append(this.m10);
        var0.append(" ");
        var0.append(this.m11);
        var0.append(" ");
        var0.append(this.m12);
        var0.append("\n");
        var0.append(this.m20);
        var0.append(" ");
        var0.append(this.m21);
        var0.append(" ");
        var0.append(this.m22);
        var0.append("\n");
        return var0.toString();
    }

    public void store(FloatBuffer var0) {
        var0.put(Matrix3f.bufferIndex(0, 0), this.m00);
        var0.put(Matrix3f.bufferIndex(0, 1), this.m01);
        var0.put(Matrix3f.bufferIndex(0, 2), this.m02);
        var0.put(Matrix3f.bufferIndex(1, 0), this.m10);
        var0.put(Matrix3f.bufferIndex(1, 1), this.m11);
        var0.put(Matrix3f.bufferIndex(1, 2), this.m12);
        var0.put(Matrix3f.bufferIndex(2, 0), this.m20);
        var0.put(Matrix3f.bufferIndex(2, 1), this.m21);
        var0.put(Matrix3f.bufferIndex(2, 2), this.m22);
    }

    public void storeTransposed(FloatBuffer var0) {
        var0.put(Matrix3f.bufferIndex(0, 0), this.m00);
        var0.put(Matrix3f.bufferIndex(1, 0), this.m01);
        var0.put(Matrix3f.bufferIndex(2, 0), this.m02);
        var0.put(Matrix3f.bufferIndex(0, 1), this.m10);
        var0.put(Matrix3f.bufferIndex(1, 1), this.m11);
        var0.put(Matrix3f.bufferIndex(2, 1), this.m12);
        var0.put(Matrix3f.bufferIndex(0, 2), this.m20);
        var0.put(Matrix3f.bufferIndex(1, 2), this.m21);
        var0.put(Matrix3f.bufferIndex(2, 2), this.m22);
    }

    public void store(FloatBuffer var0, boolean var1) {
        if (var1) {
            this.storeTransposed(var0);
        } else {
            this.store(var0);
        }
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
    }

    public float adjugateAndDet() {
        float var0 = this.m11 * this.m22 - this.m12 * this.m21;
        float var1 = -(this.m10 * this.m22 - this.m12 * this.m20);
        float var2 = this.m10 * this.m21 - this.m11 * this.m20;
        float var3 = -(this.m01 * this.m22 - this.m02 * this.m21);
        float var4 = this.m00 * this.m22 - this.m02 * this.m20;
        float var5 = -(this.m00 * this.m21 - this.m01 * this.m20);
        float var6 = this.m01 * this.m12 - this.m02 * this.m11;
        float var7 = -(this.m00 * this.m12 - this.m02 * this.m10);
        float var8 = this.m00 * this.m11 - this.m01 * this.m10;
        float var9 = this.m00 * var0 + this.m01 * var1 + this.m02 * var2;
        this.m00 = var0;
        this.m10 = var1;
        this.m20 = var2;
        this.m01 = var3;
        this.m11 = var4;
        this.m21 = var5;
        this.m02 = var6;
        this.m12 = var7;
        this.m22 = var8;
        return var9;
    }

    public float determinant() {
        float var0 = this.m11 * this.m22 - this.m12 * this.m21;
        float var1 = -(this.m10 * this.m22 - this.m12 * this.m20);
        float var2 = this.m10 * this.m21 - this.m11 * this.m20;
        return this.m00 * var0 + this.m01 * var1 + this.m02 * var2;
    }

    public boolean invert() {
        float var0 = this.adjugateAndDet();
        if (Math.abs(var0) > 1.0E-6f) {
            this.mul(var0);
            return true;
        }
        return false;
    }

    public void set(int var0, int var1, float var2) {
        if (var0 == 0) {
            if (var1 == 0) {
                this.m00 = var2;
            } else if (var1 == 1) {
                this.m01 = var2;
            } else {
                this.m02 = var2;
            }
        } else if (var0 == 1) {
            if (var1 == 0) {
                this.m10 = var2;
            } else if (var1 == 1) {
                this.m11 = var2;
            } else {
                this.m12 = var2;
            }
        } else if (var1 == 0) {
            this.m20 = var2;
        } else if (var1 == 1) {
            this.m21 = var2;
        } else {
            this.m22 = var2;
        }
    }

    public void mul(Matrix3f var0) {
        float var1 = this.m00 * var0.m00 + this.m01 * var0.m10 + this.m02 * var0.m20;
        float var2 = this.m00 * var0.m01 + this.m01 * var0.m11 + this.m02 * var0.m21;
        float var3 = this.m00 * var0.m02 + this.m01 * var0.m12 + this.m02 * var0.m22;
        float var4 = this.m10 * var0.m00 + this.m11 * var0.m10 + this.m12 * var0.m20;
        float var5 = this.m10 * var0.m01 + this.m11 * var0.m11 + this.m12 * var0.m21;
        float var6 = this.m10 * var0.m02 + this.m11 * var0.m12 + this.m12 * var0.m22;
        float var7 = this.m20 * var0.m00 + this.m21 * var0.m10 + this.m22 * var0.m20;
        float var8 = this.m20 * var0.m01 + this.m21 * var0.m11 + this.m22 * var0.m21;
        float var9 = this.m20 * var0.m02 + this.m21 * var0.m12 + this.m22 * var0.m22;
        this.m00 = var1;
        this.m01 = var2;
        this.m02 = var3;
        this.m10 = var4;
        this.m11 = var5;
        this.m12 = var6;
        this.m20 = var7;
        this.m21 = var8;
        this.m22 = var9;
    }

    public void mul(Quaternion var0) {
        this.mul(new Matrix3f(var0));
    }

    public void mul(float var0) {
        this.m00 *= var0;
        this.m01 *= var0;
        this.m02 *= var0;
        this.m10 *= var0;
        this.m11 *= var0;
        this.m12 *= var0;
        this.m20 *= var0;
        this.m21 *= var0;
        this.m22 *= var0;
    }

    public void add(Matrix3f var0) {
        this.m00 += var0.m00;
        this.m01 += var0.m01;
        this.m02 += var0.m02;
        this.m10 += var0.m10;
        this.m11 += var0.m11;
        this.m12 += var0.m12;
        this.m20 += var0.m20;
        this.m21 += var0.m21;
        this.m22 += var0.m22;
    }

    public void sub(Matrix3f var0) {
        this.m00 -= var0.m00;
        this.m01 -= var0.m01;
        this.m02 -= var0.m02;
        this.m10 -= var0.m10;
        this.m11 -= var0.m11;
        this.m12 -= var0.m12;
        this.m20 -= var0.m20;
        this.m21 -= var0.m21;
        this.m22 -= var0.m22;
    }

    public float trace() {
        return this.m00 + this.m11 + this.m22;
    }

    public Matrix3f copy() {
        return new Matrix3f(this);
    }
}

