/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class ScoreboardObjective {
    private final Scoreboard scoreboard;
    private final String name;
    private final IScoreboardCriteria criteria;
    public IChatBaseComponent displayName;
    private IChatBaseComponent formattedDisplayName;
    private IScoreboardCriteria.EnumScoreboardHealthDisplay renderType;

    public ScoreboardObjective(Scoreboard var0, String var1, IScoreboardCriteria var2, IChatBaseComponent var3, IScoreboardCriteria.EnumScoreboardHealthDisplay var4) {
        this.scoreboard = var0;
        this.name = var1;
        this.criteria = var2;
        this.displayName = var3;
        this.formattedDisplayName = this.createFormattedDisplayName();
        this.renderType = var4;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public String getName() {
        return this.name;
    }

    public IScoreboardCriteria getCriteria() {
        return this.criteria;
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }

    private IChatBaseComponent createFormattedDisplayName() {
        return ChatComponentUtils.wrapInSquareBrackets(this.displayName.copy().withStyle(var0 -> var0.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, new ChatComponentText(this.name)))));
    }

    public IChatBaseComponent getFormattedDisplayName() {
        return this.formattedDisplayName;
    }

    public void setDisplayName(IChatBaseComponent var0) {
        this.displayName = var0;
        this.formattedDisplayName = this.createFormattedDisplayName();
        this.scoreboard.onObjectiveChanged(this);
    }

    public IScoreboardCriteria.EnumScoreboardHealthDisplay getRenderType() {
        return this.renderType;
    }

    public void setRenderType(IScoreboardCriteria.EnumScoreboardHealthDisplay var0) {
        this.renderType = var0;
        this.scoreboard.onObjectiveChanged(this);
    }
}

