/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class UniformGenerator
implements NumberProvider {
    final NumberProvider min;
    final NumberProvider max;

    UniformGenerator(NumberProvider var0, NumberProvider var1) {
        this.min = var0;
        this.max = var1;
    }

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.UNIFORM;
    }

    public static UniformGenerator between(float var0, float var1) {
        return new UniformGenerator(ConstantValue.exactly(var0), ConstantValue.exactly(var1));
    }

    @Override
    public int getInt(LootTableInfo var0) {
        return MathHelper.nextInt(var0.getRandom(), this.min.getInt(var0), this.max.getInt(var0));
    }

    @Override
    public float getFloat(LootTableInfo var0) {
        return MathHelper.nextFloat(var0.getRandom(), this.min.getFloat(var0), this.max.getFloat(var0));
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return Sets.union(this.min.getReferencedContextParams(), this.max.getReferencedContextParams());
    }

    public static class a
    implements LootSerializer<UniformGenerator> {
        @Override
        public UniformGenerator deserialize(JsonObject var0, JsonDeserializationContext var1) {
            NumberProvider var2 = ChatDeserializer.getAsObject(var0, "min", var1, NumberProvider.class);
            NumberProvider var3 = ChatDeserializer.getAsObject(var0, "max", var1, NumberProvider.class);
            return new UniformGenerator(var2, var3);
        }

        @Override
        public void serialize(JsonObject var0, UniformGenerator var1, JsonSerializationContext var2) {
            var0.add("min", var2.serialize((Object)var1.min));
            var0.add("max", var2.serialize((Object)var1.max));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

