/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ValueCheckCondition
implements LootItemCondition {
    final NumberProvider provider;
    final IntRange range;

    ValueCheckCondition(NumberProvider var0, IntRange var1) {
        this.provider = var0;
        this.range = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.VALUE_CHECK;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return Sets.union(this.provider.getReferencedContextParams(), this.range.getReferencedContextParams());
    }

    @Override
    public boolean test(LootTableInfo var0) {
        return this.range.test(var0, this.provider.getInt(var0));
    }

    public static LootItemCondition.a hasValue(NumberProvider var0, IntRange var1) {
        return () -> new ValueCheckCondition(var0, var1);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<ValueCheckCondition> {
        @Override
        public void serialize(JsonObject var0, ValueCheckCondition var1, JsonSerializationContext var2) {
            var0.add("value", var2.serialize((Object)var1.provider));
            var0.add("range", var2.serialize((Object)var1.range));
        }

        @Override
        public ValueCheckCondition deserialize(JsonObject var0, JsonDeserializationContext var1) {
            NumberProvider var2 = ChatDeserializer.getAsObject(var0, "value", var1, NumberProvider.class);
            IntRange var3 = ChatDeserializer.getAsObject(var0, "range", var1, IntRange.class);
            return new ValueCheckCondition(var2, var3);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

