/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionSurvivesExplosion
implements LootItemCondition {
    static final LootItemConditionSurvivesExplosion INSTANCE = new LootItemConditionSurvivesExplosion();

    private LootItemConditionSurvivesExplosion() {
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.SURVIVES_EXPLOSION;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.EXPLOSION_RADIUS);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Float var1 = var0.getParamOrNull(LootContextParameters.EXPLOSION_RADIUS);
        if (var1 != null) {
            Random var2 = var0.getRandom();
            float var3 = 1.0f / var1.floatValue();
            return var2.nextFloat() <= var3;
        }
        return true;
    }

    public static LootItemCondition.a survivesExplosion() {
        return () -> INSTANCE;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionSurvivesExplosion> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionSurvivesExplosion var1, JsonSerializationContext var2) {
        }

        @Override
        public LootItemConditionSurvivesExplosion deserialize(JsonObject var0, JsonDeserializationContext var1) {
            return INSTANCE;
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

