/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootItemConditionReference
implements LootItemCondition {
    private static final Logger LOGGER = LogUtils.getLogger();
    final MinecraftKey name;

    LootItemConditionReference(MinecraftKey var0) {
        this.name = var0;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.REFERENCE;
    }

    @Override
    public void validate(LootCollector var0) {
        if (var0.hasVisitedCondition(this.name)) {
            var0.reportProblem("Condition " + this.name + " is recursively called");
            return;
        }
        LootItemCondition.super.validate(var0);
        LootItemCondition var1 = var0.resolveCondition(this.name);
        if (var1 == null) {
            var0.reportProblem("Unknown condition table called " + this.name);
        } else {
            var1.validate(var0.enterTable(".{" + this.name + "}", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(LootTableInfo var0) {
        LootItemCondition var1 = var0.getCondition(this.name);
        if (var0.addVisitedCondition(var1)) {
            try {
                boolean bl = var1.test(var0);
                return bl;
            }
            finally {
                var0.removeVisitedCondition(var1);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.a conditionReference(MinecraftKey var0) {
        return () -> new LootItemConditionReference(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionReference> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionReference var1, JsonSerializationContext var2) {
            var0.addProperty("name", var1.name.toString());
        }

        @Override
        public LootItemConditionReference deserialize(JsonObject var0, JsonDeserializationContext var1) {
            MinecraftKey var2 = new MinecraftKey(ChatDeserializer.getAsString(var0, "name"));
            return new LootItemConditionReference(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

