/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.phys.Vec3D;

public class LootItemConditionDamageSourceProperties
implements LootItemCondition {
    final CriterionConditionDamageSource predicate;

    LootItemConditionDamageSourceProperties(CriterionConditionDamageSource var0) {
        this.predicate = var0;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.DAMAGE_SOURCE_PROPERTIES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.ORIGIN, LootContextParameters.DAMAGE_SOURCE);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        DamageSource var1 = var0.getParamOrNull(LootContextParameters.DAMAGE_SOURCE);
        Vec3D var2 = var0.getParamOrNull(LootContextParameters.ORIGIN);
        return var2 != null && var1 != null && this.predicate.matches(var0.getLevel(), var2, var1);
    }

    public static LootItemCondition.a hasDamageSource(CriterionConditionDamageSource.a var0) {
        return () -> new LootItemConditionDamageSourceProperties(var0.build());
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionDamageSourceProperties> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionDamageSourceProperties var1, JsonSerializationContext var2) {
            var0.add("predicate", var1.predicate.serializeToJson());
        }

        @Override
        public LootItemConditionDamageSourceProperties deserialize(JsonObject var0, JsonDeserializationContext var1) {
            CriterionConditionDamageSource var2 = CriterionConditionDamageSource.fromJson(var0.get("predicate"));
            return new LootItemConditionDamageSourceProperties(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

