/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionEnchant
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    final List<Enchantment> enchantments;

    LootItemFunctionEnchant(LootItemCondition[] var0, Collection<Enchantment> var1) {
        super(var0);
        this.enchantments = ImmutableList.copyOf(var1);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.ENCHANT_RANDOMLY;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Enchantment var22;
        Random var3 = var1.getRandom();
        if (this.enchantments.isEmpty()) {
            boolean var4 = var0.is(Items.BOOK);
            List var5 = IRegistry.ENCHANTMENT.stream().filter(Enchantment::isDiscoverable).filter(var2 -> var4 || var2.canEnchant(var0)).collect(Collectors.toList());
            if (var5.isEmpty()) {
                LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)var0);
                return var0;
            }
            var22 = (Enchantment)var5.get(var3.nextInt(var5.size()));
        } else {
            var22 = this.enchantments.get(var3.nextInt(this.enchantments.size()));
        }
        return LootItemFunctionEnchant.enchantItem(var0, var22, var3);
    }

    private static ItemStack enchantItem(ItemStack var0, Enchantment var1, Random var2) {
        int var3 = MathHelper.nextInt(var2, var1.getMinLevel(), var1.getMaxLevel());
        if (var0.is(Items.BOOK)) {
            var0 = new ItemStack(Items.ENCHANTED_BOOK);
            ItemEnchantedBook.addEnchantment(var0, new WeightedRandomEnchant(var1, var3));
        } else {
            var0.enchant(var1, var3);
        }
        return var0;
    }

    public static a randomEnchantment() {
        return new a();
    }

    public static LootItemFunctionConditional.a<?> randomApplicableEnchantment() {
        return LootItemFunctionEnchant.simpleBuilder(var0 -> new LootItemFunctionEnchant((LootItemCondition[])var0, (Collection<Enchantment>)ImmutableList.of()));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Set<Enchantment> enchantments = Sets.newHashSet();

        @Override
        protected a getThis() {
            return this;
        }

        public a withEnchantment(Enchantment var0) {
            this.enchantments.add(var0);
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionEnchant(this.getConditions(), this.enchantments);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionEnchant> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionEnchant var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            if (!var1.enchantments.isEmpty()) {
                JsonArray var3 = new JsonArray();
                for (Enchantment var5 : var1.enchantments) {
                    MinecraftKey var6 = IRegistry.ENCHANTMENT.getKey(var5);
                    if (var6 == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + var5);
                    }
                    var3.add((JsonElement)new JsonPrimitive(var6.toString()));
                }
                var0.add("enchantments", (JsonElement)var3);
            }
        }

        @Override
        public LootItemFunctionEnchant deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            ArrayList var3 = Lists.newArrayList();
            if (var0.has("enchantments")) {
                JsonArray var4 = ChatDeserializer.getAsJsonArray(var0, "enchantments");
                for (JsonElement var6 : var4) {
                    String var7 = ChatDeserializer.convertToString(var6, "enchantment");
                    Enchantment var8 = IRegistry.ENCHANTMENT.getOptional(new MinecraftKey(var7)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + var7 + "'"));
                    var3.add(var8);
                }
            }
            return new LootItemFunctionEnchant(var2, var3);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

