/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItem
extends LootSelectorEntry {
    final Item item;

    LootItem(Item var0, int var1, int var2, LootItemCondition[] var3, LootItemFunction[] var4) {
        super(var1, var2, var3, var4);
        this.item = var0;
    }

    @Override
    public LootEntryType getType() {
        return LootEntries.ITEM;
    }

    @Override
    public void createItemStack(Consumer<ItemStack> var0, LootTableInfo var1) {
        var0.accept(new ItemStack(this.item));
    }

    public static LootSelectorEntry.a<?> lootTableItem(IMaterial var0) {
        return LootItem.simpleBuilder((var1, var2, var3, var4) -> new LootItem(var0.asItem(), var1, var2, var3, var4));
    }

    public static class a
    extends LootSelectorEntry.e<LootItem> {
        @Override
        public void serializeCustom(JsonObject var0, LootItem var1, JsonSerializationContext var2) {
            super.serializeCustom(var0, var1, var2);
            MinecraftKey var3 = IRegistry.ITEM.getKey(var1.item);
            if (var3 == null) {
                throw new IllegalArgumentException("Can't serialize unknown item " + var1.item);
            }
            var0.addProperty("name", var3.toString());
        }

        @Override
        protected LootItem deserialize(JsonObject var0, JsonDeserializationContext var1, int var2, int var3, LootItemCondition[] var4, LootItemFunction[] var5) {
            Item var6 = ChatDeserializer.getAsItem(var0, "name");
            return new LootItem(var6, var2, var3, var4, var5);
        }

        @Override
        protected /* synthetic */ LootSelectorEntry deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, int n2, int n3, LootItemCondition[] lootItemConditionArray, LootItemFunction[] lootItemFunctionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, n2, n3, lootItemConditionArray, lootItemFunctionArray);
        }
    }
}

