/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import net.minecraft.CrashReportSystemDetails;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;

public interface WorldData {
    public int getXSpawn();

    public int getYSpawn();

    public int getZSpawn();

    public float getSpawnAngle();

    public long getGameTime();

    public long getDayTime();

    public boolean isThundering();

    public boolean isRaining();

    public void setRaining(boolean var1);

    public boolean isHardcore();

    public GameRules getGameRules();

    public EnumDifficulty getDifficulty();

    public boolean isDifficultyLocked();

    default public void fillCrashReportCategory(CrashReportSystemDetails var0, LevelHeightAccessor var1) {
        var0.setDetail("Level spawn location", () -> CrashReportSystemDetails.formatLocation(var1, this.getXSpawn(), this.getYSpawn(), this.getZSpawn()));
        var0.setDetail("Level time", () -> String.format("%d game time, %d day time", this.getGameTime(), this.getDayTime()));
    }
}

