/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.slf4j.Logger;

public class Convertable {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String ICON_FILENAME = "icon.png";
    private static final ImmutableList<String> OLD_SETTINGS_KEYS = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String TAG_DATA = "Data";
    public final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;

    public Convertable(Path var0, Path var1, DataFixer var2) {
        this.fixerUpper = var2;
        try {
            Files.createDirectories(Files.exists(var0, new LinkOption[0]) ? var0.toRealPath(new LinkOption[0]) : var0, new FileAttribute[0]);
        }
        catch (IOException var3) {
            throw new RuntimeException(var3);
        }
        this.baseDir = var0;
        this.backupDir = var1;
    }

    public static Convertable createDefault(Path var0) {
        return new Convertable(var0, var0.resolve("../backups"), DataConverterRegistry.getDataFixer());
    }

    private static <T> Pair<GeneratorSettings, Lifecycle> readWorldGenSettings(Dynamic<T> var0, DataFixer var1, int var2) {
        String var52;
        Dynamic var3 = var0.get("WorldGenSettings").orElseEmptyMap();
        for (String var52 : OLD_SETTINGS_KEYS) {
            Optional var6 = var0.get(var52).result();
            if (!var6.isPresent()) continue;
            var3 = var3.set(var52, (Dynamic)var6.get());
        }
        Dynamic var4 = var1.update(DataConverterTypes.WORLD_GEN_SETTINGS, var3, var2, SharedConstants.getCurrentVersion().getWorldVersion());
        var52 = GeneratorSettings.CODEC.parse(var4);
        return Pair.of((Object)var52.resultOrPartial(SystemUtils.prefix("WorldGenSettings: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).orElseGet(() -> {
            IRegistryCustom var1 = IRegistryCustom.readFromDisk(var4);
            return GeneratorSettings.makeDefault(var1);
        }), (Object)var52.lifecycle());
    }

    private static DataPackConfiguration readDataPackConfig(Dynamic<?> var0) {
        return DataPackConfiguration.CODEC.parse(var0).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(DataPackConfiguration.DEFAULT);
    }

    public String getName() {
        return "Anvil";
    }

    public List<WorldInfo> getLevelList() throws LevelStorageException {
        File[] var1;
        if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
            throw new LevelStorageException(new ChatMessage("selectWorld.load_folder_access").getString());
        }
        ArrayList var0 = Lists.newArrayList();
        for (File var5 : var1 = this.baseDir.toFile().listFiles()) {
            boolean var6;
            if (!var5.isDirectory()) continue;
            try {
                var6 = SessionLock.isLocked(var5.toPath());
            }
            catch (Exception var7) {
                LOGGER.warn("Failed to read {} lock", (Object)var5, (Object)var7);
                continue;
            }
            try {
                WorldInfo var7 = this.readLevelData(var5, this.levelSummaryReader(var5, var6));
                if (var7 == null) continue;
                var0.add(var7);
            }
            catch (OutOfMemoryError var7) {
                MemoryReserve.release();
                System.gc();
                LOGGER.error(LogUtils.FATAL_MARKER, "Ran out of memory trying to read summary of {}", (Object)var5);
                throw var7;
            }
            catch (StackOverflowError var7) {
                LOGGER.error(LogUtils.FATAL_MARKER, "Ran out of stack trying to read summary of {}. Assuming corruption; attempting to restore from from level.dat_old.", (Object)var5);
                File var8 = new File(var5, "level.dat");
                File var9 = new File(var5, "level.dat_old");
                File var10 = new File(var5, "level.dat_corrupted_" + LocalDateTime.now().format(FORMATTER));
                SystemUtils.safeReplaceOrMoveFile(var8, var9, var10, true);
                throw var7;
            }
        }
        return var0;
    }

    private int getStorageVersion() {
        return 19133;
    }

    @Nullable
    <T> T readLevelData(File var0, BiFunction<File, DataFixer, T> var1) {
        T var3;
        if (!var0.exists()) {
            return null;
        }
        File var2 = new File(var0, "level.dat");
        if (var2.exists() && (var3 = var1.apply(var2, this.fixerUpper)) != null) {
            return var3;
        }
        var2 = new File(var0, "level.dat_old");
        if (var2.exists()) {
            return var1.apply(var2, this.fixerUpper);
        }
        return null;
    }

    @Nullable
    private static DataPackConfiguration getDataPacks(File var0, DataFixer var1) {
        try {
            NBTBase var2 = Convertable.readLightweightData(var0);
            if (var2 instanceof NBTTagCompound) {
                NBTTagCompound var3 = (NBTTagCompound)var2;
                NBTTagCompound var4 = var3.getCompound(TAG_DATA);
                int var5 = var4.contains("DataVersion", 99) ? var4.getInt("DataVersion") : -1;
                Dynamic var6 = var1.update(DataFixTypes.LEVEL.getType(), new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var4), var5, SharedConstants.getCurrentVersion().getWorldVersion());
                return var6.get("DataPacks").result().map(Convertable::readDataPackConfig).orElse(DataPackConfiguration.DEFAULT);
            }
        }
        catch (Exception var2) {
            LOGGER.error("Exception reading {}", (Object)var0, (Object)var2);
        }
        return null;
    }

    static BiFunction<File, DataFixer, WorldDataServer> getLevelData(DynamicOps<NBTBase> var0, DataPackConfiguration var1, Lifecycle var2) {
        return (var3, var4) -> {
            try {
                NBTTagCompound var5 = NBTCompressedStreamTools.readCompressed(var3);
                NBTTagCompound var6 = var5.getCompound(TAG_DATA);
                NBTTagCompound var7 = var6.contains("Player", 10) ? var6.getCompound("Player") : null;
                var6.remove("Player");
                int var8 = var6.contains("DataVersion", 99) ? var6.getInt("DataVersion") : -1;
                Dynamic var9 = var4.update(DataFixTypes.LEVEL.getType(), new Dynamic(var0, (Object)var6), var8, SharedConstants.getCurrentVersion().getWorldVersion());
                Pair<GeneratorSettings, Lifecycle> var10 = Convertable.readWorldGenSettings(var9, var4, var8);
                LevelVersion var11 = LevelVersion.parse(var9);
                WorldSettings var12 = WorldSettings.parse(var9, var1);
                Lifecycle var13 = ((Lifecycle)var10.getSecond()).add(var2);
                return WorldDataServer.parse((Dynamic<NBTBase>)var9, var4, var8, var7, var12, var11, (GeneratorSettings)var10.getFirst(), var13);
            }
            catch (Exception var5) {
                LOGGER.error("Exception reading {}", var3, (Object)var5);
                return null;
            }
        };
    }

    BiFunction<File, DataFixer, WorldInfo> levelSummaryReader(File var0, boolean var1) {
        return (var2, var3) -> {
            try {
                NBTBase var4 = Convertable.readLightweightData(var2);
                if (var4 instanceof NBTTagCompound) {
                    NBTTagCompound var5 = (NBTTagCompound)var4;
                    NBTTagCompound var6 = var5.getCompound(TAG_DATA);
                    int var7 = var6.contains("DataVersion", 99) ? var6.getInt("DataVersion") : -1;
                    Dynamic var8 = var3.update(DataFixTypes.LEVEL.getType(), new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var6), var7, SharedConstants.getCurrentVersion().getWorldVersion());
                    LevelVersion var9 = LevelVersion.parse(var8);
                    int var10 = var9.levelDataVersion();
                    if (var10 == 19132 || var10 == 19133) {
                        boolean var11 = var10 != this.getStorageVersion();
                        File var12 = new File(var0, ICON_FILENAME);
                        DataPackConfiguration var13 = var8.get("DataPacks").result().map(Convertable::readDataPackConfig).orElse(DataPackConfiguration.DEFAULT);
                        WorldSettings var14 = WorldSettings.parse(var8, var13);
                        return new WorldInfo(var14, var9, var0.getName(), var11, var1, var12);
                    }
                } else {
                    LOGGER.warn("Invalid root tag in {}", var2);
                }
                return null;
            }
            catch (Exception var4) {
                LOGGER.error("Exception reading {}", var2, (Object)var4);
                return null;
            }
        };
    }

    @Nullable
    private static NBTBase readLightweightData(File var0) throws IOException {
        SkipFields var1 = new SkipFields(new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "Player"), new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "WorldGenSettings"));
        NBTCompressedStreamTools.parseCompressed(var0, (StreamTagVisitor)var1);
        return var1.getResult();
    }

    public boolean isNewLevelIdAcceptable(String var0) {
        try {
            Path var1 = this.baseDir.resolve(var0);
            Files.createDirectory(var1, new FileAttribute[0]);
            Files.deleteIfExists(var1);
            return true;
        }
        catch (IOException var1) {
            return false;
        }
    }

    public boolean levelExists(String var0) {
        return Files.isDirectory(this.baseDir.resolve(var0), new LinkOption[0]);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public ConversionSession createAccess(String var0) throws IOException {
        return new ConversionSession(var0);
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock lock;
        public final Path levelPath;
        private final String levelId;
        private final Map<SavedFile, Path> resources = Maps.newHashMap();

        public ConversionSession(String var1) throws IOException {
            this.levelId = var1;
            this.levelPath = Convertable.this.baseDir.resolve(var1);
            this.lock = SessionLock.create(this.levelPath);
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(SavedFile var02) {
            return this.resources.computeIfAbsent(var02, var0 -> this.levelPath.resolve(var0.getId()));
        }

        public Path getDimensionPath(ResourceKey<World> var0) {
            return DimensionManager.getStorageFolder(var0, this.levelPath);
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage createPlayerStorage() {
            this.checkLock();
            return new WorldNBTStorage(this, Convertable.this.fixerUpper);
        }

        @Nullable
        public WorldInfo getSummary() {
            this.checkLock();
            return Convertable.this.readLevelData(this.levelPath.toFile(), Convertable.this.levelSummaryReader(this.levelPath.toFile(), false));
        }

        @Nullable
        public SaveData getDataTag(DynamicOps<NBTBase> var0, DataPackConfiguration var1, Lifecycle var2) {
            this.checkLock();
            return Convertable.this.readLevelData(this.levelPath.toFile(), Convertable.getLevelData(var0, var1, var2));
        }

        @Nullable
        public DataPackConfiguration getDataPacks() {
            this.checkLock();
            return Convertable.this.readLevelData(this.levelPath.toFile(), Convertable::getDataPacks);
        }

        public void saveDataTag(IRegistryCustom var0, SaveData var1) {
            this.saveDataTag(var0, var1, null);
        }

        public void saveDataTag(IRegistryCustom var0, SaveData var1, @Nullable NBTTagCompound var2) {
            File var3 = this.levelPath.toFile();
            NBTTagCompound var4 = var1.createTag(var0, var2);
            NBTTagCompound var5 = new NBTTagCompound();
            var5.put(Convertable.TAG_DATA, var4);
            try {
                File var6 = File.createTempFile("level", ".dat", var3);
                NBTCompressedStreamTools.writeCompressed(var5, var6);
                File var7 = new File(var3, "level.dat_old");
                File var8 = new File(var3, "level.dat");
                SystemUtils.safeReplaceFile(var8, var6, var7);
            }
            catch (Exception var6) {
                LOGGER.error("Failed to save level {}", (Object)var3, (Object)var6);
            }
        }

        public Optional<Path> getIconFile() {
            if (!this.lock.isValid()) {
                return Optional.empty();
            }
            return Optional.of(this.levelPath.resolve(Convertable.ICON_FILENAME));
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path var0 = this.levelPath.resolve("session.lock");
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int var1 = 1; var1 <= 5; ++var1) {
                LOGGER.info("Attempt {}...", (Object)var1);
                try {
                    Files.walkFileTree(this.levelPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path var02, BasicFileAttributes var1) throws IOException {
                            if (!var02.equals(var0)) {
                                LOGGER.debug("Deleting {}", (Object)var02);
                                Files.delete(var02);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path var02, IOException var1) throws IOException {
                            if (var1 != null) {
                                throw var1;
                            }
                            if (var02.equals(ConversionSession.this.levelPath)) {
                                ConversionSession.this.lock.close();
                                Files.deleteIfExists(var0);
                            }
                            Files.delete(var02);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException var2) {
                    if (var1 < 5) {
                        LOGGER.warn("Failed to delete {}", (Object)this.levelPath, (Object)var2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw var2;
                }
            }
        }

        public void renameLevel(String var0) throws IOException {
            this.checkLock();
            File var1 = new File(Convertable.this.baseDir.toFile(), this.levelId);
            if (!var1.exists()) {
                return;
            }
            File var2 = new File(var1, "level.dat");
            if (var2.exists()) {
                NBTTagCompound var3 = NBTCompressedStreamTools.readCompressed(var2);
                NBTTagCompound var4 = var3.getCompound(Convertable.TAG_DATA);
                var4.putString("LevelName", var0);
                NBTCompressedStreamTools.writeCompressed(var3, var2);
            }
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String var0 = LocalDateTime.now().format(FORMATTER) + "_" + this.levelId;
            Path var1 = Convertable.this.getBackupPath();
            try {
                Files.createDirectories(Files.exists(var1, new LinkOption[0]) ? var1.toRealPath(new LinkOption[0]) : var1, new FileAttribute[0]);
            }
            catch (IOException var2) {
                throw new RuntimeException(var2);
            }
            Path var2 = var1.resolve(FileUtils.findAvailableName(var1, var0, ".zip"));
            try (final ZipOutputStream var3 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(var2, new OpenOption[0])));){
                final Path var4 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path var0, BasicFileAttributes var1) throws IOException {
                        if (var0.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String var2 = var4.resolve(ConversionSession.this.levelPath.relativize(var0)).toString().replace('\\', '/');
                        ZipEntry var32 = new ZipEntry(var2);
                        var3.putNextEntry(var32);
                        com.google.common.io.Files.asByteSource((File)var0.toFile()).copyTo((OutputStream)var3);
                        var3.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size(var2);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }
    }
}

