/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;

public abstract class FluidTypeWater
extends FluidTypeFlowing {
    @Override
    public FluidType getFlowing() {
        return FluidTypes.FLOWING_WATER;
    }

    @Override
    public FluidType getSource() {
        return FluidTypes.WATER;
    }

    @Override
    public Item getBucket() {
        return Items.WATER_BUCKET;
    }

    @Override
    public void animateTick(World var0, BlockPosition var1, Fluid var2, Random var3) {
        if (!var2.isSource() && !var2.getValue(FALLING).booleanValue()) {
            if (var3.nextInt(64) == 0) {
                var0.playLocalSound((double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, SoundEffects.WATER_AMBIENT, SoundCategory.BLOCKS, var3.nextFloat() * 0.25f + 0.75f, var3.nextFloat() + 0.5f, false);
            }
        } else if (var3.nextInt(10) == 0) {
            var0.addParticle(Particles.UNDERWATER, (double)var1.getX() + var3.nextDouble(), (double)var1.getY() + var3.nextDouble(), (double)var1.getZ() + var3.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nullable
    public ParticleParam getDripParticle() {
        return Particles.DRIPPING_WATER;
    }

    @Override
    protected boolean canConvertToSource() {
        return true;
    }

    @Override
    protected void beforeDestroyingBlock(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        TileEntity var3 = var2.hasBlockEntity() ? var0.getBlockEntity(var1) : null;
        Block.dropResources(var2, var0, var1, var3);
    }

    @Override
    public int getSlopeFindDistance(IWorldReader var0) {
        return 4;
    }

    @Override
    public IBlockData createLegacyBlock(Fluid var0) {
        return (IBlockData)Blocks.WATER.defaultBlockState().setValue(BlockFluids.LEVEL, FluidTypeWater.getLegacyLevel(var0));
    }

    @Override
    public boolean isSame(FluidType var0) {
        return var0 == FluidTypes.WATER || var0 == FluidTypes.FLOWING_WATER;
    }

    @Override
    public int getDropOff(IWorldReader var0) {
        return 1;
    }

    @Override
    public int getTickDelay(IWorldReader var0) {
        return 5;
    }

    @Override
    public boolean canBeReplacedWith(Fluid var0, IBlockAccess var1, BlockPosition var2, FluidType var3, EnumDirection var4) {
        return var4 == EnumDirection.DOWN && !var3.is(TagsFluid.WATER);
    }

    @Override
    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return Optional.of(SoundEffects.BUCKET_FILL);
    }

    public static class a
    extends FluidTypeWater {
        @Override
        protected void createFluidStateDefinition(BlockStateList.a<FluidType, Fluid> var0) {
            super.createFluidStateDefinition(var0);
            var0.add(LEVEL);
        }

        @Override
        public int getAmount(Fluid var0) {
            return var0.getValue(LEVEL);
        }

        @Override
        public boolean isSource(Fluid var0) {
            return false;
        }
    }

    public static class b
    extends FluidTypeWater {
        @Override
        public int getAmount(Fluid var0) {
            return 8;
        }

        @Override
        public boolean isSource(Fluid var0) {
            return true;
        }
    }
}

