/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineGraph;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import net.minecraft.world.level.lighting.LightEngineStorage;
import net.minecraft.world.level.lighting.LightEngineStorageArray;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class LightEngineLayer<M extends LightEngineStorageArray<M>, S extends LightEngineStorage<M>>
extends LightEngineGraph
implements LightEngineLayerEventListener {
    public static final long SELF_SOURCE = Long.MAX_VALUE;
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    protected final ILightAccess chunkSource;
    protected final EnumSkyBlock layer;
    protected final S storage;
    private boolean runningLightUpdates;
    protected final BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
    private static final int CACHE_SIZE = 2;
    private final long[] lastChunkPos = new long[2];
    private final IBlockAccess[] lastChunk = new IBlockAccess[2];

    public LightEngineLayer(ILightAccess var0, EnumSkyBlock var1, S var2) {
        super(16, 256, 8192);
        this.chunkSource = var0;
        this.layer = var1;
        this.storage = var2;
        this.clearCache();
    }

    @Override
    protected void checkNode(long var0) {
        ((LightEngineStorage)this.storage).runAllUpdates();
        if (((LightEngineStorage)this.storage).storingLightForSection(SectionPosition.blockToSection(var0))) {
            super.checkNode(var0);
        }
    }

    @Nullable
    private IBlockAccess getChunk(int var0, int var1) {
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        for (int var4 = 0; var4 < 2; ++var4) {
            if (var2 != this.lastChunkPos[var4]) continue;
            return this.lastChunk[var4];
        }
        IBlockAccess var4 = this.chunkSource.getChunkForLighting(var0, var1);
        for (int var5 = 1; var5 > 0; --var5) {
            this.lastChunkPos[var5] = this.lastChunkPos[var5 - 1];
            this.lastChunk[var5] = this.lastChunk[var5 - 1];
        }
        this.lastChunkPos[0] = var2;
        this.lastChunk[0] = var4;
        return var4;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkCoordIntPair.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunk, null);
    }

    protected IBlockData getStateAndOpacity(long var0, @Nullable MutableInt var2) {
        boolean var7;
        int var4;
        if (var0 == Long.MAX_VALUE) {
            if (var2 != null) {
                var2.setValue(0);
            }
            return Blocks.AIR.defaultBlockState();
        }
        int var3 = SectionPosition.blockToSectionCoord(BlockPosition.getX(var0));
        IBlockAccess var5 = this.getChunk(var3, var4 = SectionPosition.blockToSectionCoord(BlockPosition.getZ(var0)));
        if (var5 == null) {
            if (var2 != null) {
                var2.setValue(16);
            }
            return Blocks.BEDROCK.defaultBlockState();
        }
        this.pos.set(var0);
        IBlockData var6 = var5.getBlockState(this.pos);
        boolean bl = var7 = var6.canOcclude() && var6.useShapeForLightOcclusion();
        if (var2 != null) {
            var2.setValue(var6.getLightBlock(this.chunkSource.getLevel(), this.pos));
        }
        return var7 ? var6 : Blocks.AIR.defaultBlockState();
    }

    protected VoxelShape getShape(IBlockData var0, long var1, EnumDirection var3) {
        return var0.canOcclude() ? var0.getFaceOcclusionShape(this.chunkSource.getLevel(), this.pos.set(var1), var3) : VoxelShapes.empty();
    }

    public static int getLightBlockInto(IBlockAccess var0, IBlockData var1, BlockPosition var2, IBlockData var3, BlockPosition var4, EnumDirection var5, int var6) {
        VoxelShape var10;
        boolean var8;
        boolean var7 = var1.canOcclude() && var1.useShapeForLightOcclusion();
        boolean bl = var8 = var3.canOcclude() && var3.useShapeForLightOcclusion();
        if (!var7 && !var8) {
            return var6;
        }
        VoxelShape var9 = var7 ? var1.getOcclusionShape(var0, var2) : VoxelShapes.empty();
        VoxelShape voxelShape = var10 = var8 ? var3.getOcclusionShape(var0, var4) : VoxelShapes.empty();
        if (VoxelShapes.mergedFaceOccludes(var9, var10, var5)) {
            return 16;
        }
        return var6;
    }

    @Override
    protected boolean isSource(long var0) {
        return var0 == Long.MAX_VALUE;
    }

    @Override
    protected int getComputedLevel(long var0, long var2, int var4) {
        return 0;
    }

    @Override
    protected int getLevel(long var0) {
        if (var0 == Long.MAX_VALUE) {
            return 0;
        }
        return 15 - ((LightEngineStorage)this.storage).getStoredLevel(var0);
    }

    protected int getLevel(NibbleArray var0, long var1) {
        return 15 - var0.get(SectionPosition.sectionRelative(BlockPosition.getX(var1)), SectionPosition.sectionRelative(BlockPosition.getY(var1)), SectionPosition.sectionRelative(BlockPosition.getZ(var1)));
    }

    @Override
    protected void setLevel(long var0, int var2) {
        ((LightEngineStorage)this.storage).setStoredLevel(var0, Math.min(15, 15 - var2));
    }

    @Override
    protected int computeLevelFromNeighbor(long var0, long var2, int var4) {
        return 0;
    }

    @Override
    public boolean hasLightWork() {
        return this.hasWork() || ((LightEngineGraph)this.storage).hasWork() || ((LightEngineStorage)this.storage).hasInconsistencies();
    }

    @Override
    public int runUpdates(int var0, boolean var1, boolean var2) {
        if (!this.runningLightUpdates) {
            if (((LightEngineGraph)this.storage).hasWork() && (var0 = ((LightEngineGraph)this.storage).runUpdates(var0)) == 0) {
                return var0;
            }
            ((LightEngineStorage)this.storage).markNewInconsistencies(this, var1, var2);
        }
        this.runningLightUpdates = true;
        if (this.hasWork()) {
            var0 = this.runUpdates(var0);
            this.clearCache();
            if (var0 == 0) {
                return var0;
            }
        }
        this.runningLightUpdates = false;
        ((LightEngineStorage)this.storage).swapSectionMap();
        return var0;
    }

    protected void queueSectionData(long var0, @Nullable NibbleArray var2, boolean var3) {
        ((LightEngineStorage)this.storage).queueSectionData(var0, var2, var3);
    }

    @Override
    @Nullable
    public NibbleArray getDataLayerData(SectionPosition var0) {
        return ((LightEngineStorage)this.storage).getDataLayerData(var0.asLong());
    }

    @Override
    public int getLightValue(BlockPosition var0) {
        return ((LightEngineStorage)this.storage).getLightValue(var0.asLong());
    }

    public String getDebugData(long var0) {
        return "" + ((LightEngineStorage)this.storage).getLevel(var0);
    }

    @Override
    public void checkBlock(BlockPosition var0) {
        long var1 = var0.asLong();
        this.checkNode(var1);
        for (EnumDirection var6 : DIRECTIONS) {
            this.checkNode(BlockPosition.offset(var1, var6));
        }
    }

    @Override
    public void onBlockEmissionIncrease(BlockPosition var0, int var1) {
    }

    @Override
    public void updateSectionStatus(SectionPosition var0, boolean var1) {
        ((LightEngineStorage)this.storage).updateSectionStatus(var0.asLong(), var1);
    }

    @Override
    public void enableLightSources(ChunkCoordIntPair var0, boolean var1) {
        long var2 = SectionPosition.getZeroNode(SectionPosition.asLong(var0.x, 0, var0.z));
        ((LightEngineStorage)this.storage).enableLightSources(var2, var1);
    }

    public void retainData(ChunkCoordIntPair var0, boolean var1) {
        long var2 = SectionPosition.getZeroNode(SectionPosition.asLong(var0.x, 0, var0.z));
        ((LightEngineStorage)this.storage).retainData(var2, var1);
    }
}

