/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.ILightEngine;
import net.minecraft.world.level.lighting.LightEngineBlock;
import net.minecraft.world.level.lighting.LightEngineLayer;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import net.minecraft.world.level.lighting.LightEngineSky;

public class LightEngine
implements ILightEngine {
    public static final int MAX_SOURCE_LEVEL = 15;
    public static final int LIGHT_SECTION_PADDING = 1;
    protected final LevelHeightAccessor levelHeightAccessor;
    @Nullable
    private final LightEngineLayer<?, ?> blockEngine;
    @Nullable
    private final LightEngineLayer<?, ?> skyEngine;

    public LightEngine(ILightAccess var0, boolean var1, boolean var2) {
        this.levelHeightAccessor = var0.getLevel();
        this.blockEngine = var1 ? new LightEngineBlock(var0) : null;
        this.skyEngine = var2 ? new LightEngineSky(var0) : null;
    }

    @Override
    public void checkBlock(BlockPosition var0) {
        if (this.blockEngine != null) {
            this.blockEngine.checkBlock(var0);
        }
        if (this.skyEngine != null) {
            this.skyEngine.checkBlock(var0);
        }
    }

    @Override
    public void onBlockEmissionIncrease(BlockPosition var0, int var1) {
        if (this.blockEngine != null) {
            this.blockEngine.onBlockEmissionIncrease(var0, var1);
        }
    }

    @Override
    public boolean hasLightWork() {
        if (this.skyEngine != null && this.skyEngine.hasLightWork()) {
            return true;
        }
        return this.blockEngine != null && this.blockEngine.hasLightWork();
    }

    @Override
    public int runUpdates(int var0, boolean var1, boolean var2) {
        if (this.blockEngine != null && this.skyEngine != null) {
            int var3 = var0 / 2;
            int var4 = this.blockEngine.runUpdates(var3, var1, var2);
            int var5 = var0 - var3 + var4;
            int var6 = this.skyEngine.runUpdates(var5, var1, var2);
            if (var4 == 0 && var6 > 0) {
                return this.blockEngine.runUpdates(var6, var1, var2);
            }
            return var6;
        }
        if (this.blockEngine != null) {
            return this.blockEngine.runUpdates(var0, var1, var2);
        }
        if (this.skyEngine != null) {
            return this.skyEngine.runUpdates(var0, var1, var2);
        }
        return var0;
    }

    @Override
    public void updateSectionStatus(SectionPosition var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.updateSectionStatus(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.updateSectionStatus(var0, var1);
        }
    }

    @Override
    public void enableLightSources(ChunkCoordIntPair var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.enableLightSources(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.enableLightSources(var0, var1);
        }
    }

    public LightEngineLayerEventListener getLayerListener(EnumSkyBlock var0) {
        if (var0 == EnumSkyBlock.BLOCK) {
            if (this.blockEngine == null) {
                return LightEngineLayerEventListener.Void.INSTANCE;
            }
            return this.blockEngine;
        }
        if (this.skyEngine == null) {
            return LightEngineLayerEventListener.Void.INSTANCE;
        }
        return this.skyEngine;
    }

    public String getDebugData(EnumSkyBlock var0, SectionPosition var1) {
        if (var0 == EnumSkyBlock.BLOCK) {
            if (this.blockEngine != null) {
                return this.blockEngine.getDebugData(var1.asLong());
            }
        } else if (this.skyEngine != null) {
            return this.skyEngine.getDebugData(var1.asLong());
        }
        return "n/a";
    }

    public void queueSectionData(EnumSkyBlock var0, SectionPosition var1, @Nullable NibbleArray var2, boolean var3) {
        if (var0 == EnumSkyBlock.BLOCK) {
            if (this.blockEngine != null) {
                this.blockEngine.queueSectionData(var1.asLong(), var2, var3);
            }
        } else if (this.skyEngine != null) {
            this.skyEngine.queueSectionData(var1.asLong(), var2, var3);
        }
    }

    public void retainData(ChunkCoordIntPair var0, boolean var1) {
        if (this.blockEngine != null) {
            this.blockEngine.retainData(var0, var1);
        }
        if (this.skyEngine != null) {
            this.skyEngine.retainData(var0, var1);
        }
    }

    public int getRawBrightness(BlockPosition var0, int var1) {
        int var2 = this.skyEngine == null ? 0 : this.skyEngine.getLightValue(var0) - var1;
        int var3 = this.blockEngine == null ? 0 : this.blockEngine.getLightValue(var0);
        return Math.max(var3, var2);
    }

    public int getLightSectionCount() {
        return this.levelHeightAccessor.getSectionsCount() + 2;
    }

    public int getMinLightSection() {
        return this.levelHeightAccessor.getMinSection() - 1;
    }

    public int getMaxLightSection() {
        return this.getMinLightSection() + this.getLightSectionCount();
    }
}

