/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class BlendedNoise
implements DensityFunction.c {
    public static final BlendedNoise UNSEEDED = new BlendedNoise(new XoroshiroRandomSource(0L), new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), 4, 8);
    public static final Codec<BlendedNoise> CODEC = Codec.unit((Object)UNSEEDED);
    private final NoiseGeneratorOctaves minLimitNoise;
    private final NoiseGeneratorOctaves maxLimitNoise;
    private final NoiseGeneratorOctaves mainNoise;
    private final double xzScale;
    private final double yScale;
    private final double xzMainScale;
    private final double yMainScale;
    private final int cellWidth;
    private final int cellHeight;
    private final double maxValue;

    private BlendedNoise(NoiseGeneratorOctaves var0, NoiseGeneratorOctaves var1, NoiseGeneratorOctaves var2, NoiseSamplingSettings var3, int var4, int var5) {
        this.minLimitNoise = var0;
        this.maxLimitNoise = var1;
        this.mainNoise = var2;
        this.xzScale = 684.412 * var3.xzScale();
        this.yScale = 684.412 * var3.yScale();
        this.xzMainScale = this.xzScale / var3.xzFactor();
        this.yMainScale = this.yScale / var3.yFactor();
        this.cellWidth = var4;
        this.cellHeight = var5;
        this.maxValue = var0.maxBrokenValue(this.yScale);
    }

    public BlendedNoise(RandomSource var0, NoiseSamplingSettings var1, int var2, int var3) {
        this(NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-7, 0)), var1, var2, var3);
    }

    @Override
    public double compute(DensityFunction.b var0) {
        int var1 = Math.floorDiv(var0.blockX(), this.cellWidth);
        int var2 = Math.floorDiv(var0.blockY(), this.cellHeight);
        int var3 = Math.floorDiv(var0.blockZ(), this.cellWidth);
        double var4 = 0.0;
        double var6 = 0.0;
        double var8 = 0.0;
        boolean var10 = true;
        double var11 = 1.0;
        for (int var13 = 0; var13 < 8; ++var13) {
            NoiseGeneratorPerlin var14 = this.mainNoise.getOctaveNoise(var13);
            if (var14 != null) {
                var8 += var14.noise(NoiseGeneratorOctaves.wrap((double)var1 * this.xzMainScale * var11), NoiseGeneratorOctaves.wrap((double)var2 * this.yMainScale * var11), NoiseGeneratorOctaves.wrap((double)var3 * this.xzMainScale * var11), this.yMainScale * var11, (double)var2 * this.yMainScale * var11) / var11;
            }
            var11 /= 2.0;
        }
        double var13 = (var8 / 10.0 + 1.0) / 2.0;
        boolean var15 = var13 >= 1.0;
        boolean var16 = var13 <= 0.0;
        var11 = 1.0;
        for (int var17 = 0; var17 < 16; ++var17) {
            NoiseGeneratorPerlin var26;
            double var18 = NoiseGeneratorOctaves.wrap((double)var1 * this.xzScale * var11);
            double var20 = NoiseGeneratorOctaves.wrap((double)var2 * this.yScale * var11);
            double var22 = NoiseGeneratorOctaves.wrap((double)var3 * this.xzScale * var11);
            double var24 = this.yScale * var11;
            if (!var15 && (var26 = this.minLimitNoise.getOctaveNoise(var17)) != null) {
                var4 += var26.noise(var18, var20, var22, var24, (double)var2 * var24) / var11;
            }
            if (!var16 && (var26 = this.maxLimitNoise.getOctaveNoise(var17)) != null) {
                var6 += var26.noise(var18, var20, var22, var24, (double)var2 * var24) / var11;
            }
            var11 /= 2.0;
        }
        return MathHelper.clampedLerp(var4 / 512.0, var6 / 512.0, var13) / 128.0;
    }

    @Override
    public double minValue() {
        return -this.maxValue();
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var0) {
        var0.append("BlendedNoise{minLimitNoise=");
        this.minLimitNoise.parityConfigString(var0);
        var0.append(", maxLimitNoise=");
        this.maxLimitNoise.parityConfigString(var0);
        var0.append(", mainNoise=");
        this.mainNoise.parityConfigString(var0);
        var0.append(String.format(", xzScale=%.3f, yScale=%.3f, xzMainScale=%.3f, yMainScale=%.3f, cellWidth=%d, cellHeight=%d", this.xzScale, this.yScale, this.xzMainScale, this.yMainScale, this.cellWidth, this.cellHeight)).append('}');
    }

    @Override
    public Codec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

