/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import net.minecraft.FileUtils;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class DefinedStructureManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String STRUCTURE_DIRECTORY_NAME = "structures";
    private static final String STRUCTURE_FILE_EXTENSION = ".nbt";
    private static final String STRUCTURE_TEXT_FILE_EXTENSION = ".snbt";
    public final Map<MinecraftKey, Optional<DefinedStructure>> structureRepository = Maps.newConcurrentMap();
    private final DataFixer fixerUpper;
    private IResourceManager resourceManager;
    private final Path generatedDir;

    public DefinedStructureManager(IResourceManager var0, Convertable.ConversionSession var1, DataFixer var2) {
        this.resourceManager = var0;
        this.fixerUpper = var2;
        this.generatedDir = var1.getLevelPath(SavedFile.GENERATED_DIR).normalize();
    }

    public DefinedStructure getOrCreate(MinecraftKey var0) {
        Optional<DefinedStructure> var1 = this.get(var0);
        if (var1.isPresent()) {
            return var1.get();
        }
        DefinedStructure var2 = new DefinedStructure();
        this.structureRepository.put(var0, Optional.of(var2));
        return var2;
    }

    public Optional<DefinedStructure> get(MinecraftKey var02) {
        return this.structureRepository.computeIfAbsent(var02, var0 -> {
            Optional<DefinedStructure> var1 = this.loadFromGenerated((MinecraftKey)var0);
            return var1.isPresent() ? var1 : this.loadFromResource((MinecraftKey)var0);
        });
    }

    public void onResourceManagerReload(IResourceManager var0) {
        this.resourceManager = var0;
        this.structureRepository.clear();
    }

    public Optional<DefinedStructure> loadFromResource(MinecraftKey var0) {
        Optional<DefinedStructure> optional;
        block9: {
            MinecraftKey var1 = new MinecraftKey(var0.getNamespace(), "structures/" + var0.getPath() + STRUCTURE_FILE_EXTENSION);
            IResource var2 = this.resourceManager.getResource(var1);
            try {
                optional = Optional.of(this.readStructure(var2.getInputStream()));
                if (var2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (var2 != null) {
                        try {
                            var2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException var22) {
                    return Optional.empty();
                }
                catch (Throwable var23) {
                    LOGGER.error("Couldn't load structure {}: {}", (Object)var0, (Object)var23.toString());
                    return Optional.empty();
                }
            }
            var2.close();
        }
        return optional;
    }

    public Optional<DefinedStructure> loadFromGenerated(MinecraftKey var0) {
        Optional<DefinedStructure> optional;
        if (!this.generatedDir.toFile().isDirectory()) {
            return Optional.empty();
        }
        Path var1 = this.createAndValidatePathToStructure(var0, STRUCTURE_FILE_EXTENSION);
        FileInputStream var2 = new FileInputStream(var1.toFile());
        try {
            optional = Optional.of(this.readStructure(var2));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)var2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException var22) {
                return Optional.empty();
            }
            catch (IOException var23) {
                LOGGER.error("Couldn't load structure from {}", (Object)var1, (Object)var23);
                return Optional.empty();
            }
        }
        ((InputStream)var2).close();
        return optional;
    }

    public DefinedStructure readStructure(InputStream var0) throws IOException {
        NBTTagCompound var1 = NBTCompressedStreamTools.readCompressed(var0);
        return this.readStructure(var1);
    }

    public DefinedStructure readStructure(NBTTagCompound var0) {
        if (!var0.contains("DataVersion", 99)) {
            var0.putInt("DataVersion", 500);
        }
        DefinedStructure var1 = new DefinedStructure();
        var1.load(GameProfileSerializer.update(this.fixerUpper, DataFixTypes.STRUCTURE, var0, var0.getInt("DataVersion")));
        return var1;
    }

    public boolean save(MinecraftKey var0) {
        Optional<DefinedStructure> var1 = this.structureRepository.get(var0);
        if (!var1.isPresent()) {
            return false;
        }
        DefinedStructure var2 = var1.get();
        Path var3 = this.createAndValidatePathToStructure(var0, STRUCTURE_FILE_EXTENSION);
        Path var4 = var3.getParent();
        if (var4 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(var4, new LinkOption[0]) ? var4.toRealPath(new LinkOption[0]) : var4, new FileAttribute[0]);
        }
        catch (IOException var5) {
            LOGGER.error("Failed to create parent directory: {}", (Object)var4);
            return false;
        }
        NBTTagCompound var5 = var2.save(new NBTTagCompound());
        try (FileOutputStream var6 = new FileOutputStream(var3.toFile());){
            NBTCompressedStreamTools.writeCompressed(var5, var6);
        }
        catch (Throwable var62) {
            return false;
        }
        return true;
    }

    public Path createPathToStructure(MinecraftKey var0, String var1) {
        try {
            Path var2 = this.generatedDir.resolve(var0.getNamespace());
            Path var3 = var2.resolve(STRUCTURE_DIRECTORY_NAME);
            return FileUtils.createPathToResource(var3, var0.getPath(), var1);
        }
        catch (InvalidPathException var2) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + var0, var2);
        }
    }

    public Path createAndValidatePathToStructure(MinecraftKey var0, String var1) {
        if (var0.getPath().contains("//")) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + var0);
        }
        Path var2 = this.createPathToStructure(var0, var1);
        if (!(var2.startsWith(this.generatedDir) && FileUtils.isPathNormalized(var2) && FileUtils.isPathPortable(var2))) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + var2);
        }
        return var2;
    }

    public void remove(MinecraftKey var0) {
        this.structureRepository.remove(var0);
    }
}

