/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorGravity;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructurePoolTemplate {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SIZE_UNSET = Integer.MIN_VALUE;
    public static final Codec<WorldGenFeatureDefinedStructurePoolTemplate> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)MinecraftKey.CODEC.fieldOf("name").forGetter(WorldGenFeatureDefinedStructurePoolTemplate::getName), (App)MinecraftKey.CODEC.fieldOf("fallback").forGetter(WorldGenFeatureDefinedStructurePoolTemplate::getFallback), (App)Codec.mapPair((MapCodec)WorldGenFeatureDefinedStructurePoolStructure.CODEC.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(var0 -> var0.rawTemplates)).apply((Applicative)var02, WorldGenFeatureDefinedStructurePoolTemplate::new));
    public static final Codec<Holder<WorldGenFeatureDefinedStructurePoolTemplate>> CODEC = RegistryFileCodec.create(IRegistry.TEMPLATE_POOL_REGISTRY, DIRECT_CODEC);
    private final MinecraftKey name;
    private final List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> rawTemplates;
    private final List<WorldGenFeatureDefinedStructurePoolStructure> templates;
    private final MinecraftKey fallback;
    private int maxSize = Integer.MIN_VALUE;

    public WorldGenFeatureDefinedStructurePoolTemplate(MinecraftKey var0, MinecraftKey var1, List<Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>> var2) {
        this.name = var0;
        this.rawTemplates = var2;
        this.templates = Lists.newArrayList();
        for (Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer> var4 : var2) {
            WorldGenFeatureDefinedStructurePoolStructure var5 = (WorldGenFeatureDefinedStructurePoolStructure)var4.getFirst();
            for (int var6 = 0; var6 < (Integer)var4.getSecond(); ++var6) {
                this.templates.add(var5);
            }
        }
        this.fallback = var1;
    }

    public WorldGenFeatureDefinedStructurePoolTemplate(MinecraftKey var0, MinecraftKey var1, List<Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer>> var2, Matching var3) {
        this.name = var0;
        this.rawTemplates = Lists.newArrayList();
        this.templates = Lists.newArrayList();
        for (Pair<Function<Matching, ? extends WorldGenFeatureDefinedStructurePoolStructure>, Integer> var5 : var2) {
            WorldGenFeatureDefinedStructurePoolStructure var6 = (WorldGenFeatureDefinedStructurePoolStructure)((Function)var5.getFirst()).apply(var3);
            this.rawTemplates.add((Pair<WorldGenFeatureDefinedStructurePoolStructure, Integer>)Pair.of((Object)var6, (Object)((Integer)var5.getSecond())));
            for (int var7 = 0; var7 < (Integer)var5.getSecond(); ++var7) {
                this.templates.add(var6);
            }
        }
        this.fallback = var1;
    }

    public int getMaxSize(DefinedStructureManager var02) {
        if (this.maxSize == Integer.MIN_VALUE) {
            this.maxSize = this.templates.stream().filter(var0 -> var0 != WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE).mapToInt(var1 -> var1.getBoundingBox(var02, BlockPosition.ZERO, EnumBlockRotation.NONE).getYSpan()).max().orElse(0);
        }
        return this.maxSize;
    }

    public MinecraftKey getFallback() {
        return this.fallback;
    }

    public WorldGenFeatureDefinedStructurePoolStructure getRandomTemplate(Random var0) {
        return this.templates.get(var0.nextInt(this.templates.size()));
    }

    public List<WorldGenFeatureDefinedStructurePoolStructure> getShuffledTemplates(Random var0) {
        return ImmutableList.copyOf((Object[])((WorldGenFeatureDefinedStructurePoolStructure[])ObjectArrays.shuffle((Object[])this.templates.toArray(new WorldGenFeatureDefinedStructurePoolStructure[0]), (Random)var0)));
    }

    public MinecraftKey getName() {
        return this.name;
    }

    public int size() {
        return this.templates.size();
    }

    public static final class Matching
    extends Enum<Matching>
    implements INamable {
        public static final /* enum */ Matching TERRAIN_MATCHING = new Matching("terrain_matching", ImmutableList.of((Object)new DefinedStructureProcessorGravity(HeightMap.Type.WORLD_SURFACE_WG, -1)));
        public static final /* enum */ Matching RIGID = new Matching("rigid", ImmutableList.of());
        public static final Codec<Matching> CODEC;
        private static final Map<String, Matching> BY_NAME;
        private final String name;
        private final ImmutableList<DefinedStructureProcessor> processors;
        private static final /* synthetic */ Matching[] g;

        public static Matching[] values() {
            return (Matching[])g.clone();
        }

        public static Matching valueOf(String var0) {
            return Enum.valueOf(Matching.class, var0);
        }

        private Matching(String var2, ImmutableList var3) {
            this.name = var2;
            this.processors = var3;
        }

        public String getName() {
            return this.name;
        }

        public static Matching byName(String var0) {
            return BY_NAME.get(var0);
        }

        public ImmutableList<DefinedStructureProcessor> getProcessors() {
            return this.processors;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Matching[] d() {
            return new Matching[]{TERRAIN_MATCHING, RIGID};
        }

        static {
            g = Matching.d();
            CODEC = INamable.fromEnum(Matching::values, Matching::byName);
            BY_NAME = Arrays.stream(Matching.values()).collect(Collectors.toMap(Matching::getName, var0 -> var0));
        }
    }
}

