/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorJigsawReplacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class WorldGenFeatureDefinedStructurePoolSingle
extends WorldGenFeatureDefinedStructurePoolStructure {
    private static final Codec<Either<MinecraftKey, DefinedStructure>> TEMPLATE_CODEC = Codec.of(WorldGenFeatureDefinedStructurePoolSingle::encodeTemplate, (Decoder)MinecraftKey.CODEC.map(Either::left));
    public static final Codec<WorldGenFeatureDefinedStructurePoolSingle> CODEC = RecordCodecBuilder.create(var0 -> var0.group(WorldGenFeatureDefinedStructurePoolSingle.templateCodec(), WorldGenFeatureDefinedStructurePoolSingle.processorsCodec(), WorldGenFeatureDefinedStructurePoolSingle.projectionCodec()).apply((Applicative)var0, WorldGenFeatureDefinedStructurePoolSingle::new));
    protected final Either<MinecraftKey, DefinedStructure> template;
    protected final Holder<ProcessorList> processors;

    private static <T> DataResult<T> encodeTemplate(Either<MinecraftKey, DefinedStructure> var0, DynamicOps<T> var1, T var2) {
        Optional var3 = var0.left();
        if (!var3.isPresent()) {
            return DataResult.error((String)"Can not serialize a runtime pool element");
        }
        return MinecraftKey.CODEC.encode((Object)((MinecraftKey)var3.get()), var1, var2);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Holder<ProcessorList>> processorsCodec() {
        return DefinedStructureStructureProcessorType.LIST_CODEC.fieldOf("processors").forGetter(var0 -> var0.processors);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Either<MinecraftKey, DefinedStructure>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(var0 -> var0.template);
    }

    protected WorldGenFeatureDefinedStructurePoolSingle(Either<MinecraftKey, DefinedStructure> var0, Holder<ProcessorList> var1, WorldGenFeatureDefinedStructurePoolTemplate.Matching var2) {
        super(var2);
        this.template = var0;
        this.processors = var1;
    }

    public WorldGenFeatureDefinedStructurePoolSingle(DefinedStructure var0) {
        this((Either<MinecraftKey, DefinedStructure>)Either.right((Object)var0), ProcessorLists.EMPTY, WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID);
    }

    @Override
    public BaseBlockPosition getSize(DefinedStructureManager var0, EnumBlockRotation var1) {
        DefinedStructure var2 = this.getTemplate(var0);
        return var2.getSize(var1);
    }

    private DefinedStructure getTemplate(DefinedStructureManager var0) {
        return (DefinedStructure)this.template.map(var0::getOrCreate, Function.identity());
    }

    public List<DefinedStructure.BlockInfo> getDataMarkers(DefinedStructureManager var0, BlockPosition var1, EnumBlockRotation var2, boolean var3) {
        DefinedStructure var4 = this.getTemplate(var0);
        List<DefinedStructure.BlockInfo> var5 = var4.filterBlocks(var1, new DefinedStructureInfo().setRotation(var2), Blocks.STRUCTURE_BLOCK, var3);
        ArrayList var6 = Lists.newArrayList();
        for (DefinedStructure.BlockInfo var8 : var5) {
            BlockPropertyStructureMode var9;
            if (var8.nbt == null || (var9 = BlockPropertyStructureMode.valueOf(var8.nbt.getString("mode"))) != BlockPropertyStructureMode.DATA) continue;
            var6.add(var8);
        }
        return var6;
    }

    @Override
    public List<DefinedStructure.BlockInfo> getShuffledJigsawBlocks(DefinedStructureManager var0, BlockPosition var1, EnumBlockRotation var2, Random var3) {
        DefinedStructure var4 = this.getTemplate(var0);
        List<DefinedStructure.BlockInfo> var5 = var4.filterBlocks(var1, new DefinedStructureInfo().setRotation(var2), Blocks.JIGSAW, true);
        Collections.shuffle(var5, var3);
        return var5;
    }

    @Override
    public StructureBoundingBox getBoundingBox(DefinedStructureManager var0, BlockPosition var1, EnumBlockRotation var2) {
        DefinedStructure var3 = this.getTemplate(var0);
        return var3.getBoundingBox(new DefinedStructureInfo().setRotation(var2), var1);
    }

    @Override
    public boolean place(DefinedStructureManager var0, GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, BlockPosition var4, BlockPosition var5, EnumBlockRotation var6, StructureBoundingBox var7, Random var8, boolean var9) {
        DefinedStructureInfo var11;
        DefinedStructure var10 = this.getTemplate(var0);
        if (var10.placeInWorld(var1, var4, var5, var11 = this.getSettings(var6, var7, var9), var8, 18)) {
            List<DefinedStructure.BlockInfo> var12 = DefinedStructure.processBlockInfos(var1, var4, var5, var11, this.getDataMarkers(var0, var4, var6, false));
            for (DefinedStructure.BlockInfo var14 : var12) {
                this.handleDataMarker(var1, var14, var4, var6, var8, var7);
            }
            return true;
        }
        return false;
    }

    protected DefinedStructureInfo getSettings(EnumBlockRotation var0, StructureBoundingBox var1, boolean var2) {
        DefinedStructureInfo var3 = new DefinedStructureInfo();
        var3.setBoundingBox(var1);
        var3.setRotation(var0);
        var3.setKnownShape(true);
        var3.setIgnoreEntities(false);
        var3.addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK);
        var3.setFinalizeEntities(true);
        if (!var2) {
            var3.addProcessor(DefinedStructureProcessorJigsawReplacement.INSTANCE);
        }
        this.processors.value().list().forEach(var3::addProcessor);
        this.getProjection().getProcessors().forEach(var3::addProcessor);
        return var3;
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> getType() {
        return WorldGenFeatureDefinedStructurePools.SINGLE;
    }

    public String toString() {
        return "Single[" + this.template + "]";
    }
}

