/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public record RandomSpreadStructurePlacement(int spacing, int separation, RandomSpreadType spreadType, int salt, BaseBlockPosition locateOffset) implements StructurePlacement
{
    public static final Codec<RandomSpreadStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::spreadType), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(RandomSpreadStructurePlacement::salt), (App)BaseBlockPosition.offsetCodec(16).optionalFieldOf("locate_offset", (Object)BaseBlockPosition.ZERO).forGetter(RandomSpreadStructurePlacement::locateOffset)).apply((Applicative)var0, RandomSpreadStructurePlacement::new)).flatXmap(var0 -> {
        if (var0.spacing <= var0.separation) {
            return DataResult.error((String)"Spacing has to be larger than separation");
        }
        return DataResult.success((Object)var0);
    }, DataResult::success).codec();

    public RandomSpreadStructurePlacement(int var0, int var1, RandomSpreadType var2, int var3) {
        this(var0, var1, var2, var3, BaseBlockPosition.ZERO);
    }

    public ChunkCoordIntPair getPotentialFeatureChunk(long var0, int var2, int var3) {
        int var4 = this.spacing();
        int var5 = this.separation();
        int var6 = Math.floorDiv(var2, var4);
        int var7 = Math.floorDiv(var3, var4);
        SeededRandom var8 = new SeededRandom(new LegacyRandomSource(0L));
        var8.setLargeFeatureWithSalt(var0, var6, var7, this.salt());
        int var9 = var4 - var5;
        int var10 = this.spreadType().evaluate(var8, var9);
        int var11 = this.spreadType().evaluate(var8, var9);
        return new ChunkCoordIntPair(var6 * var4 + var10, var7 * var4 + var11);
    }

    @Override
    public boolean isFeatureChunk(ChunkGenerator var0, long var1, int var3, int var4) {
        ChunkCoordIntPair var5 = this.getPotentialFeatureChunk(var1, var3, var4);
        return var5.x == var3 && var5.z == var4;
    }

    @Override
    public StructurePlacementType<?> type() {
        return StructurePlacementType.RANDOM_SPREAD;
    }
}

