/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public record ConcentricRingsStructurePlacement(int distance, int spread, int count) implements StructurePlacement
{
    public static final Codec<ConcentricRingsStructurePlacement> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.intRange((int)0, (int)1023).fieldOf("distance").forGetter(ConcentricRingsStructurePlacement::distance), (App)Codec.intRange((int)0, (int)1023).fieldOf("spread").forGetter(ConcentricRingsStructurePlacement::spread), (App)Codec.intRange((int)1, (int)4095).fieldOf("count").forGetter(ConcentricRingsStructurePlacement::count)).apply((Applicative)var0, ConcentricRingsStructurePlacement::new));

    @Override
    public boolean isFeatureChunk(ChunkGenerator var0, long var1, int var3, int var4) {
        List<ChunkCoordIntPair> var5 = var0.getRingPositionsFor(this);
        if (var5 == null) {
            return false;
        }
        return var5.contains(new ChunkCoordIntPair(var3, var4));
    }

    @Override
    public StructurePlacementType<?> type() {
        return StructurePlacementType.CONCENTRIC_RINGS;
    }
}

