/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.storage.loot.LootTables;

public class WorldGenStrongholdPieces {
    private static final int SMALL_DOOR_WIDTH = 3;
    private static final int SMALL_DOOR_HEIGHT = 3;
    private static final int MAX_DEPTH = 50;
    private static final int LOWEST_Y_POSITION = 10;
    private static final boolean CHECK_AIR = true;
    public static final int MAGIC_START_Y = 64;
    private static final WorldGenStrongholdPieceWeight[] STRONGHOLD_PIECE_WEIGHTS = new WorldGenStrongholdPieceWeight[]{new WorldGenStrongholdPieceWeight(WorldGenStrongholdStairs.class, 40, 0), new WorldGenStrongholdPieceWeight(WorldGenStrongholdPrison.class, 5, 5), new WorldGenStrongholdPieceWeight(WorldGenStrongholdLeftTurn.class, 20, 0), new WorldGenStrongholdPieceWeight(WorldGenStrongholdRightTurn.class, 20, 0), new WorldGenStrongholdPieceWeight(WorldGenStrongholdRoomCrossing.class, 10, 6), new WorldGenStrongholdPieceWeight(WorldGenStrongholdStairsStraight.class, 5, 5), new WorldGenStrongholdPieceWeight(WorldGenStrongholdStairs2.class, 5, 5), new WorldGenStrongholdPieceWeight(WorldGenStrongholdCrossing.class, 5, 4), new WorldGenStrongholdPieceWeight(WorldGenStrongholdChestCorridor.class, 5, 4), new WorldGenStrongholdPieceWeight(WorldGenStrongholdLibrary.class, 10, 2){

        @Override
        public boolean doPlace(int var0) {
            return super.doPlace(var0) && var0 > 4;
        }
    }, new WorldGenStrongholdPieceWeight(WorldGenStrongholdPortalRoom.class, 20, 1){

        @Override
        public boolean doPlace(int var0) {
            return super.doPlace(var0) && var0 > 5;
        }
    }};
    private static List<WorldGenStrongholdPieceWeight> currentPieces;
    static Class<? extends WorldGenStrongholdPiece> imposedPiece;
    private static int totalWeight;
    static final WorldGenStrongholdStones SMOOTH_STONE_SELECTOR;

    public static void resetPieces() {
        currentPieces = Lists.newArrayList();
        for (WorldGenStrongholdPieceWeight var3 : STRONGHOLD_PIECE_WEIGHTS) {
            var3.placeCount = 0;
            currentPieces.add(var3);
        }
        imposedPiece = null;
    }

    private static boolean updatePieceWeight() {
        boolean var0 = false;
        totalWeight = 0;
        for (WorldGenStrongholdPieceWeight var2 : currentPieces) {
            if (var2.maxPlaceCount > 0 && var2.placeCount < var2.maxPlaceCount) {
                var0 = true;
            }
            totalWeight += var2.weight;
        }
        return var0;
    }

    private static WorldGenStrongholdPiece findAndCreatePieceFactory(Class<? extends WorldGenStrongholdPiece> var0, StructurePieceAccessor var1, Random var2, int var3, int var4, int var5, @Nullable EnumDirection var6, int var7) {
        WorldGenStrongholdPiece var8 = null;
        if (var0 == WorldGenStrongholdStairs.class) {
            var8 = WorldGenStrongholdStairs.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdPrison.class) {
            var8 = WorldGenStrongholdPrison.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdLeftTurn.class) {
            var8 = WorldGenStrongholdLeftTurn.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdRightTurn.class) {
            var8 = WorldGenStrongholdRightTurn.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdRoomCrossing.class) {
            var8 = WorldGenStrongholdRoomCrossing.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdStairsStraight.class) {
            var8 = WorldGenStrongholdStairsStraight.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdStairs2.class) {
            var8 = WorldGenStrongholdStairs2.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdCrossing.class) {
            var8 = WorldGenStrongholdCrossing.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdChestCorridor.class) {
            var8 = WorldGenStrongholdChestCorridor.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdLibrary.class) {
            var8 = WorldGenStrongholdLibrary.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var0 == WorldGenStrongholdPortalRoom.class) {
            var8 = WorldGenStrongholdPortalRoom.createPiece(var1, var3, var4, var5, var6, var7);
        }
        return var8;
    }

    private static WorldGenStrongholdPiece generatePieceFromSmallDoor(WorldGenStrongholdStart var0, StructurePieceAccessor var1, Random var2, int var3, int var4, int var5, EnumDirection var6, int var7) {
        if (!WorldGenStrongholdPieces.updatePieceWeight()) {
            return null;
        }
        if (imposedPiece != null) {
            WorldGenStrongholdPiece var8 = WorldGenStrongholdPieces.findAndCreatePieceFactory(imposedPiece, var1, var2, var3, var4, var5, var6, var7);
            imposedPiece = null;
            if (var8 != null) {
                return var8;
            }
        }
        int var8 = 0;
        block0: while (var8 < 5) {
            ++var8;
            int var9 = var2.nextInt(totalWeight);
            for (WorldGenStrongholdPieceWeight var11 : currentPieces) {
                if ((var9 -= var11.weight) >= 0) continue;
                if (!var11.doPlace(var7) || var11 == var0.previousPiece) continue block0;
                WorldGenStrongholdPiece var12 = WorldGenStrongholdPieces.findAndCreatePieceFactory(var11.pieceClass, var1, var2, var3, var4, var5, var6, var7);
                if (var12 == null) continue;
                ++var11.placeCount;
                var0.previousPiece = var11;
                if (!var11.isValid()) {
                    currentPieces.remove(var11);
                }
                return var12;
            }
        }
        StructureBoundingBox var9 = WorldGenStrongholdCorridor.findPieceBox(var1, var2, var3, var4, var5, var6);
        if (var9 != null && var9.minY() > 1) {
            return new WorldGenStrongholdCorridor(var7, var9, var6);
        }
        return null;
    }

    static StructurePiece generateAndAddPiece(WorldGenStrongholdStart var0, StructurePieceAccessor var1, Random var2, int var3, int var4, int var5, @Nullable EnumDirection var6, int var7) {
        if (var7 > 50) {
            return null;
        }
        if (Math.abs(var3 - var0.getBoundingBox().minX()) > 112 || Math.abs(var5 - var0.getBoundingBox().minZ()) > 112) {
            return null;
        }
        WorldGenStrongholdPiece var8 = WorldGenStrongholdPieces.generatePieceFromSmallDoor(var0, var1, var2, var3, var4, var5, var6, var7 + 1);
        if (var8 != null) {
            var1.addPiece(var8);
            var0.pendingChildren.add(var8);
        }
        return var8;
    }

    static {
        SMOOTH_STONE_SELECTOR = new WorldGenStrongholdStones();
    }

    static class WorldGenStrongholdPieceWeight {
        public final Class<? extends WorldGenStrongholdPiece> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;

        public WorldGenStrongholdPieceWeight(Class<? extends WorldGenStrongholdPiece> var0, int var1, int var2) {
            this.pieceClass = var0;
            this.weight = var1;
            this.maxPlaceCount = var2;
        }

        public boolean doPlace(int var0) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class WorldGenStrongholdStairs
    extends WorldGenStrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private final boolean leftChild;
        private final boolean rightChild;

        public WorldGenStrongholdStairs(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
            this.leftChild = var1.nextInt(2) == 0;
            this.rightChild = var1.nextInt(2) == 0;
        }

        public WorldGenStrongholdStairs(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT, var0);
            this.leftChild = var0.getBoolean("Left");
            this.rightChild = var0.getBoolean("Right");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Left", this.leftChild);
            var1.putBoolean("Right", this.rightChild);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            this.generateSmallDoorChildForward((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
            if (this.leftChild) {
                this.generateSmallDoorChildLeft((WorldGenStrongholdStart)var0, var1, var2, 1, 2);
            }
            if (this.rightChild) {
                this.generateSmallDoorChildRight((WorldGenStrongholdStart)var0, var1, var2, 1, 2);
            }
        }

        public static WorldGenStrongholdStairs createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 5, 5, 7, var5);
            if (!WorldGenStrongholdStairs.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdStairs(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 4, 6, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(var0, var3, var4, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.OPENING, 1, 1, 6);
            IBlockData var7 = (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.EAST);
            IBlockData var8 = (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.WEST);
            this.maybeGenerateBlock(var0, var4, var3, 0.1f, 1, 2, 1, var7);
            this.maybeGenerateBlock(var0, var4, var3, 0.1f, 3, 2, 1, var8);
            this.maybeGenerateBlock(var0, var4, var3, 0.1f, 1, 2, 5, var7);
            this.maybeGenerateBlock(var0, var4, var3, 0.1f, 3, 2, 5, var8);
            if (this.leftChild) {
                this.generateBox(var0, var4, 0, 1, 2, 0, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightChild) {
                this.generateBox(var0, var4, 4, 1, 2, 4, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class WorldGenStrongholdPrison
    extends WorldGenStrongholdPiece {
        protected static final int WIDTH = 9;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 11;

        public WorldGenStrongholdPrison(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PRISON_HALL, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
        }

        public WorldGenStrongholdPrison(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PRISON_HALL, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            this.generateSmallDoorChildForward((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
        }

        public static WorldGenStrongholdPrison createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 9, 5, 11, var5);
            if (!WorldGenStrongholdPrison.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdPrison(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 8, 4, 10, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 1, 1, 0);
            this.generateBox(var0, var4, 1, 1, 10, 3, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(var0, var4, 4, 1, 1, 4, 3, 1, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 1, 3, 4, 3, 3, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 1, 7, 4, 3, 7, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 1, 9, 4, 3, 9, false, var3, SMOOTH_STONE_SELECTOR);
            for (int var7 = 1; var7 <= 3; ++var7) {
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, var7, 4, var4);
                this.placeBlock(var0, (IBlockData)((IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)).setValue(BlockIronBars.EAST, true), 4, var7, 5, var4);
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, var7, 6, var4);
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true), 5, var7, 5, var4);
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true), 6, var7, 5, var4);
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true), 7, var7, 5, var4);
            }
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, 3, 2, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, 3, 8, var4);
            IBlockData var7 = (IBlockData)Blocks.IRON_DOOR.defaultBlockState().setValue(BlockDoor.FACING, EnumDirection.WEST);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.IRON_DOOR.defaultBlockState().setValue(BlockDoor.FACING, EnumDirection.WEST)).setValue(BlockDoor.HALF, BlockPropertyDoubleBlockHalf.UPPER);
            this.placeBlock(var0, var7, 4, 1, 2, var4);
            this.placeBlock(var0, var8, 4, 2, 2, var4);
            this.placeBlock(var0, var7, 4, 1, 8, var4);
            this.placeBlock(var0, var8, 4, 2, 8, var4);
        }
    }

    public static class WorldGenStrongholdLeftTurn
    extends q {
        public WorldGenStrongholdLeftTurn(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LEFT_TURN, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
        }

        public WorldGenStrongholdLeftTurn(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LEFT_TURN, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            EnumDirection var3 = this.getOrientation();
            if (var3 == EnumDirection.NORTH || var3 == EnumDirection.EAST) {
                this.generateSmallDoorChildLeft((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
            } else {
                this.generateSmallDoorChildRight((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
            }
        }

        public static WorldGenStrongholdLeftTurn createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 5, 5, 5, var5);
            if (!WorldGenStrongholdLeftTurn.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdLeftTurn(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 4, 4, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 1, 1, 0);
            EnumDirection var7 = this.getOrientation();
            if (var7 == EnumDirection.NORTH || var7 == EnumDirection.EAST) {
                this.generateBox(var0, var4, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(var0, var4, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class WorldGenStrongholdRightTurn
    extends q {
        public WorldGenStrongholdRightTurn(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_RIGHT_TURN, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
        }

        public WorldGenStrongholdRightTurn(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_RIGHT_TURN, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            EnumDirection var3 = this.getOrientation();
            if (var3 == EnumDirection.NORTH || var3 == EnumDirection.EAST) {
                this.generateSmallDoorChildRight((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
            } else {
                this.generateSmallDoorChildLeft((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
            }
        }

        public static WorldGenStrongholdRightTurn createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 5, 5, 5, var5);
            if (!WorldGenStrongholdRightTurn.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdRightTurn(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 4, 4, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 1, 1, 0);
            EnumDirection var7 = this.getOrientation();
            if (var7 == EnumDirection.NORTH || var7 == EnumDirection.EAST) {
                this.generateBox(var0, var4, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(var0, var4, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class WorldGenStrongholdRoomCrossing
    extends WorldGenStrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 7;
        protected static final int DEPTH = 11;
        protected final int type;

        public WorldGenStrongholdRoomCrossing(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_ROOM_CROSSING, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
            this.type = var1.nextInt(5);
        }

        public WorldGenStrongholdRoomCrossing(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_ROOM_CROSSING, var0);
            this.type = var0.getInt("Type");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putInt("Type", this.type);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            this.generateSmallDoorChildForward((WorldGenStrongholdStart)var0, var1, var2, 4, 1);
            this.generateSmallDoorChildLeft((WorldGenStrongholdStart)var0, var1, var2, 1, 4);
            this.generateSmallDoorChildRight((WorldGenStrongholdStart)var0, var1, var2, 1, 4);
        }

        public static WorldGenStrongholdRoomCrossing createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -4, -1, 0, 11, 7, 11, var5);
            if (!WorldGenStrongholdRoomCrossing.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdRoomCrossing(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 10, 6, 10, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 4, 1, 0);
            this.generateBox(var0, var4, 4, 1, 10, 6, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(var0, var4, 0, 1, 4, 0, 3, 6, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(var0, var4, 10, 1, 4, 10, 3, 6, CAVE_AIR, CAVE_AIR, false);
            switch (this.type) {
                default: {
                    break;
                }
                case 0: {
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, var4);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, var4);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, var4);
                    this.placeBlock(var0, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.WEST), 4, 3, 5, var4);
                    this.placeBlock(var0, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.EAST), 6, 3, 5, var4);
                    this.placeBlock(var0, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.SOUTH), 5, 3, 4, var4);
                    this.placeBlock(var0, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.NORTH), 5, 3, 6, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 4, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 5, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 6, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 4, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 5, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 6, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 4, var4);
                    this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 6, var4);
                    break;
                }
                case 1: {
                    for (int var7 = 0; var7 < 5; ++var7) {
                        this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3, 1, 3 + var7, var4);
                        this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 7, 1, 3 + var7, var4);
                        this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3 + var7, 1, 3, var4);
                        this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3 + var7, 1, 7, var4);
                    }
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, var4);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, var4);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, var4);
                    this.placeBlock(var0, Blocks.WATER.defaultBlockState(), 5, 4, 5, var4);
                    break;
                }
                case 2: {
                    int var7;
                    for (var7 = 1; var7 <= 9; ++var7) {
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 1, 3, var7, var4);
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 9, 3, var7, var4);
                    }
                    for (var7 = 1; var7 <= 9; ++var7) {
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), var7, 3, 1, var4);
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), var7, 3, 9, var4);
                    }
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 4, var4);
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 6, var4);
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 4, var4);
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 6, var4);
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 4, 1, 5, var4);
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 6, 1, 5, var4);
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 4, 3, 5, var4);
                    this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 6, 3, 5, var4);
                    for (var7 = 1; var7 <= 3; ++var7) {
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 4, var7, 4, var4);
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 6, var7, 4, var4);
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 4, var7, 6, var4);
                        this.placeBlock(var0, Blocks.COBBLESTONE.defaultBlockState(), 6, var7, 6, var4);
                    }
                    this.placeBlock(var0, Blocks.TORCH.defaultBlockState(), 5, 3, 5, var4);
                    for (var7 = 2; var7 <= 8; ++var7) {
                        this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 2, 3, var7, var4);
                        this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 3, 3, var7, var4);
                        if (var7 <= 3 || var7 >= 7) {
                            this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 4, 3, var7, var4);
                            this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 5, 3, var7, var4);
                            this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 6, 3, var7, var4);
                        }
                        this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 7, 3, var7, var4);
                        this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 8, 3, var7, var4);
                    }
                    IBlockData var72 = (IBlockData)Blocks.LADDER.defaultBlockState().setValue(BlockLadder.FACING, EnumDirection.WEST);
                    this.placeBlock(var0, var72, 9, 1, 3, var4);
                    this.placeBlock(var0, var72, 9, 2, 3, var4);
                    this.placeBlock(var0, var72, 9, 3, 3, var4);
                    this.createChest(var0, var4, var3, 3, 4, 8, LootTables.STRONGHOLD_CROSSING);
                }
            }
        }
    }

    public static class WorldGenStrongholdStairsStraight
    extends WorldGenStrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 8;

        public WorldGenStrongholdStairsStraight(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
        }

        public WorldGenStrongholdStairsStraight(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            this.generateSmallDoorChildForward((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
        }

        public static WorldGenStrongholdStairsStraight createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -7, 0, 5, 11, 8, var5);
            if (!WorldGenStrongholdStairsStraight.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdStairsStraight(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 10, 7, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(var0, var3, var4, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.OPENING, 1, 1, 7);
            IBlockData var7 = (IBlockData)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.SOUTH);
            for (int var8 = 0; var8 < 6; ++var8) {
                this.placeBlock(var0, var7, 1, 6 - var8, 1 + var8, var4);
                this.placeBlock(var0, var7, 2, 6 - var8, 1 + var8, var4);
                this.placeBlock(var0, var7, 3, 6 - var8, 1 + var8, var4);
                if (var8 >= 5) continue;
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5 - var8, 1 + var8, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 2, 5 - var8, 1 + var8, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3, 5 - var8, 1 + var8, var4);
            }
        }
    }

    public static class WorldGenStrongholdStairs2
    extends WorldGenStrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 5;
        private final boolean isSource;

        public WorldGenStrongholdStairs2(WorldGenFeatureStructurePieceType var0, int var1, int var2, int var3, EnumDirection var4) {
            super(var0, var1, WorldGenStrongholdStairs2.makeBoundingBox(var2, 64, var3, var4, 5, 11, 5));
            this.isSource = true;
            this.setOrientation(var4);
            this.entryDoor = WorldGenStrongholdPiece.WorldGenStrongholdDoorType.OPENING;
        }

        public WorldGenStrongholdStairs2(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STAIRS_DOWN, var0, var2);
            this.isSource = false;
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
        }

        public WorldGenStrongholdStairs2(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
            super(var0, var1);
            this.isSource = var1.getBoolean("Source");
        }

        public WorldGenStrongholdStairs2(NBTTagCompound var0) {
            this(WorldGenFeatureStructurePieceType.STRONGHOLD_STAIRS_DOWN, var0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Source", this.isSource);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            if (this.isSource) {
                imposedPiece = WorldGenStrongholdCrossing.class;
            }
            this.generateSmallDoorChildForward((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
        }

        public static WorldGenStrongholdStairs2 createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -7, 0, 5, 11, 5, var5);
            if (!WorldGenStrongholdStairs2.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdStairs2(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 10, 4, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(var0, var3, var4, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.OPENING, 1, 1, 4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 2, 6, 1, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 1, var4);
            this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 6, 1, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 2, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, 3, var4);
            this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 5, 3, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, 3, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 3, var4);
            this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 4, 3, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 2, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3, 2, 1, var4);
            this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 3, 1, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 2, 2, 1, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 1, var4);
            this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 2, 1, var4);
            this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 2, var4);
            this.placeBlock(var0, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 1, 3, var4);
        }
    }

    public static class WorldGenStrongholdCrossing
    extends WorldGenStrongholdPiece {
        protected static final int WIDTH = 10;
        protected static final int HEIGHT = 9;
        protected static final int DEPTH = 11;
        private final boolean leftLow;
        private final boolean leftHigh;
        private final boolean rightLow;
        private final boolean rightHigh;

        public WorldGenStrongholdCrossing(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FIVE_CROSSING, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
            this.leftLow = var1.nextBoolean();
            this.leftHigh = var1.nextBoolean();
            this.rightLow = var1.nextBoolean();
            this.rightHigh = var1.nextInt(3) > 0;
        }

        public WorldGenStrongholdCrossing(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FIVE_CROSSING, var0);
            this.leftLow = var0.getBoolean("leftLow");
            this.leftHigh = var0.getBoolean("leftHigh");
            this.rightLow = var0.getBoolean("rightLow");
            this.rightHigh = var0.getBoolean("rightHigh");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("leftLow", this.leftLow);
            var1.putBoolean("leftHigh", this.leftHigh);
            var1.putBoolean("rightLow", this.rightLow);
            var1.putBoolean("rightHigh", this.rightHigh);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            int var3 = 3;
            int var4 = 5;
            EnumDirection var5 = this.getOrientation();
            if (var5 == EnumDirection.WEST || var5 == EnumDirection.NORTH) {
                var3 = 8 - var3;
                var4 = 8 - var4;
            }
            this.generateSmallDoorChildForward((WorldGenStrongholdStart)var0, var1, var2, 5, 1);
            if (this.leftLow) {
                this.generateSmallDoorChildLeft((WorldGenStrongholdStart)var0, var1, var2, var3, 1);
            }
            if (this.leftHigh) {
                this.generateSmallDoorChildLeft((WorldGenStrongholdStart)var0, var1, var2, var4, 7);
            }
            if (this.rightLow) {
                this.generateSmallDoorChildRight((WorldGenStrongholdStart)var0, var1, var2, var3, 1);
            }
            if (this.rightHigh) {
                this.generateSmallDoorChildRight((WorldGenStrongholdStart)var0, var1, var2, var4, 7);
            }
        }

        public static WorldGenStrongholdCrossing createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -4, -3, 0, 10, 9, 11, var5);
            if (!WorldGenStrongholdCrossing.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdCrossing(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 9, 8, 10, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.generateBox(var0, var4, 0, 3, 1, 0, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightLow) {
                this.generateBox(var0, var4, 9, 3, 1, 9, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.leftHigh) {
                this.generateBox(var0, var4, 0, 5, 7, 0, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightHigh) {
                this.generateBox(var0, var4, 9, 5, 7, 9, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            this.generateBox(var0, var4, 5, 1, 10, 7, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(var0, var4, 1, 2, 1, 8, 2, 6, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 1, 5, 4, 4, 9, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 8, 1, 5, 8, 4, 9, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 1, 4, 7, 3, 4, 9, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 1, 3, 5, 3, 3, 6, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 1, 3, 4, 3, 3, 4, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 4, 6, 3, 4, 6, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 1, 7, 7, 1, 8, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 5, 1, 9, 7, 1, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 2, 7, 7, 2, 7, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 5, 7, 4, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 5, 7, 8, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 5, 7, 7, 5, 9, (IBlockData)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(BlockStepAbstract.TYPE, BlockPropertySlabType.DOUBLE), (IBlockData)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(BlockStepAbstract.TYPE, BlockPropertySlabType.DOUBLE), false);
            this.placeBlock(var0, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.SOUTH), 6, 5, 6, var4);
        }
    }

    public static class WorldGenStrongholdChestCorridor
    extends WorldGenStrongholdPiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private boolean hasPlacedChest;

        public WorldGenStrongholdChestCorridor(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_CHEST_CORRIDOR, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
        }

        public WorldGenStrongholdChestCorridor(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_CHEST_CORRIDOR, var0);
            this.hasPlacedChest = var0.getBoolean("Chest");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Chest", this.hasPlacedChest);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            this.generateSmallDoorChildForward((WorldGenStrongholdStart)var0, var1, var2, 1, 1);
        }

        public static WorldGenStrongholdChestCorridor createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 5, 5, 7, var5);
            if (!WorldGenStrongholdChestCorridor.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new WorldGenStrongholdChestCorridor(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 4, 6, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(var0, var3, var4, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.OPENING, 1, 1, 6);
            this.generateBox(var0, var4, 3, 1, 2, 3, 1, 4, Blocks.STONE_BRICKS.defaultBlockState(), Blocks.STONE_BRICKS.defaultBlockState(), false);
            this.placeBlock(var0, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 1, var4);
            this.placeBlock(var0, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 5, var4);
            this.placeBlock(var0, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 2, var4);
            this.placeBlock(var0, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 4, var4);
            for (int var7 = 2; var7 <= 4; ++var7) {
                this.placeBlock(var0, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 2, 1, var7, var4);
            }
            if (!this.hasPlacedChest && var4.isInside(this.getWorldPos(3, 2, 3))) {
                this.hasPlacedChest = true;
                this.createChest(var0, var4, var3, 3, 2, 3, LootTables.STRONGHOLD_CORRIDOR);
            }
        }
    }

    public static class WorldGenStrongholdLibrary
    extends WorldGenStrongholdPiece {
        protected static final int WIDTH = 14;
        protected static final int HEIGHT = 6;
        protected static final int TALL_HEIGHT = 11;
        protected static final int DEPTH = 15;
        private final boolean isTall;

        public WorldGenStrongholdLibrary(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LIBRARY, var0, var2);
            this.setOrientation(var3);
            this.entryDoor = this.randomSmallDoor(var1);
            this.isTall = var2.getYSpan() > 6;
        }

        public WorldGenStrongholdLibrary(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LIBRARY, var0);
            this.isTall = var0.getBoolean("Tall");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Tall", this.isTall);
        }

        public static WorldGenStrongholdLibrary createPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -4, -1, 0, 14, 11, 15, var5);
            if (!(WorldGenStrongholdLibrary.isOkBox(var7) && var0.findCollisionPiece(var7) == null || WorldGenStrongholdLibrary.isOkBox(var7 = StructureBoundingBox.orientBox(var2, var3, var4, -4, -1, 0, 14, 6, 15, var5)) && var0.findCollisionPiece(var7) == null)) {
                return null;
            }
            return new WorldGenStrongholdLibrary(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var10;
            int var7 = 11;
            if (!this.isTall) {
                var7 = 6;
            }
            this.generateBox(var0, var4, 0, 0, 0, 13, var7 - 1, 14, true, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, this.entryDoor, 4, 1, 0);
            this.generateMaybeBox(var0, var4, var3, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.COBWEB.defaultBlockState(), Blocks.COBWEB.defaultBlockState(), false, false);
            boolean var8 = true;
            int var9 = 12;
            for (var10 = 1; var10 <= 13; ++var10) {
                if ((var10 - 1) % 4 == 0) {
                    this.generateBox(var0, var4, 1, 1, var10, 1, 4, var10, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(var0, var4, 12, 1, var10, 12, 4, var10, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.placeBlock(var0, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.EAST), 2, 3, var10, var4);
                    this.placeBlock(var0, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.WEST), 11, 3, var10, var4);
                    if (!this.isTall) continue;
                    this.generateBox(var0, var4, 1, 6, var10, 1, 9, var10, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(var0, var4, 12, 6, var10, 12, 9, var10, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    continue;
                }
                this.generateBox(var0, var4, 1, 1, var10, 1, 4, var10, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(var0, var4, 12, 1, var10, 12, 4, var10, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                if (!this.isTall) continue;
                this.generateBox(var0, var4, 1, 6, var10, 1, 9, var10, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(var0, var4, 12, 6, var10, 12, 9, var10, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            for (var10 = 3; var10 < 12; var10 += 2) {
                this.generateBox(var0, var4, 3, 1, var10, 4, 3, var10, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(var0, var4, 6, 1, var10, 7, 3, var10, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(var0, var4, 9, 1, var10, 10, 3, var10, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            if (this.isTall) {
                this.generateBox(var0, var4, 1, 5, 1, 3, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(var0, var4, 10, 5, 1, 12, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(var0, var4, 4, 5, 1, 9, 5, 2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(var0, var4, 4, 5, 12, 9, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 11, var4);
                this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 8, 5, 11, var4);
                this.placeBlock(var0, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 10, var4);
                IBlockData var102 = (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
                IBlockData var11 = (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
                this.generateBox(var0, var4, 3, 6, 3, 3, 6, 11, var11, var11, false);
                this.generateBox(var0, var4, 10, 6, 3, 10, 6, 9, var11, var11, false);
                this.generateBox(var0, var4, 4, 6, 2, 9, 6, 2, var102, var102, false);
                this.generateBox(var0, var4, 4, 6, 12, 7, 6, 12, var102, var102, false);
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 3, 6, 2, var4);
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.EAST, true), 3, 6, 12, var4);
                this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.WEST, true), 10, 6, 2, var4);
                for (int var12 = 0; var12 <= 2; ++var12) {
                    this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.WEST, true), 8 + var12, 6, 12 - var12, var4);
                    if (var12 == 2) continue;
                    this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 8 + var12, 6, 11 - var12, var4);
                }
                IBlockData var12 = (IBlockData)Blocks.LADDER.defaultBlockState().setValue(BlockLadder.FACING, EnumDirection.SOUTH);
                this.placeBlock(var0, var12, 10, 1, 13, var4);
                this.placeBlock(var0, var12, 10, 2, 13, var4);
                this.placeBlock(var0, var12, 10, 3, 13, var4);
                this.placeBlock(var0, var12, 10, 4, 13, var4);
                this.placeBlock(var0, var12, 10, 5, 13, var4);
                this.placeBlock(var0, var12, 10, 6, 13, var4);
                this.placeBlock(var0, var12, 10, 7, 13, var4);
                int var13 = 7;
                int var14 = 7;
                IBlockData var15 = (IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true);
                this.placeBlock(var0, var15, 6, 9, 7, var4);
                IBlockData var16 = (IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true);
                this.placeBlock(var0, var16, 7, 9, 7, var4);
                this.placeBlock(var0, var15, 6, 8, 7, var4);
                this.placeBlock(var0, var16, 7, 8, 7, var4);
                IBlockData var17 = (IBlockData)((IBlockData)var11.setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
                this.placeBlock(var0, var17, 6, 7, 7, var4);
                this.placeBlock(var0, var17, 7, 7, 7, var4);
                this.placeBlock(var0, var15, 5, 7, 7, var4);
                this.placeBlock(var0, var16, 8, 7, 7, var4);
                this.placeBlock(var0, (IBlockData)var15.setValue(BlockFence.NORTH, true), 6, 7, 6, var4);
                this.placeBlock(var0, (IBlockData)var15.setValue(BlockFence.SOUTH, true), 6, 7, 8, var4);
                this.placeBlock(var0, (IBlockData)var16.setValue(BlockFence.NORTH, true), 7, 7, 6, var4);
                this.placeBlock(var0, (IBlockData)var16.setValue(BlockFence.SOUTH, true), 7, 7, 8, var4);
                IBlockData var18 = Blocks.TORCH.defaultBlockState();
                this.placeBlock(var0, var18, 5, 8, 7, var4);
                this.placeBlock(var0, var18, 8, 8, 7, var4);
                this.placeBlock(var0, var18, 6, 8, 6, var4);
                this.placeBlock(var0, var18, 6, 8, 8, var4);
                this.placeBlock(var0, var18, 7, 8, 6, var4);
                this.placeBlock(var0, var18, 7, 8, 8, var4);
            }
            this.createChest(var0, var4, var3, 3, 3, 5, LootTables.STRONGHOLD_LIBRARY);
            if (this.isTall) {
                this.placeBlock(var0, CAVE_AIR, 12, 9, 1, var4);
                this.createChest(var0, var4, var3, 12, 8, 1, LootTables.STRONGHOLD_LIBRARY);
            }
        }
    }

    public static class WorldGenStrongholdPortalRoom
    extends WorldGenStrongholdPiece {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 8;
        protected static final int DEPTH = 16;
        private boolean hasPlacedSpawner;

        public WorldGenStrongholdPortalRoom(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PORTAL_ROOM, var0, var1);
            this.setOrientation(var2);
        }

        public WorldGenStrongholdPortalRoom(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PORTAL_ROOM, var0);
            this.hasPlacedSpawner = var0.getBoolean("Mob");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Mob", this.hasPlacedSpawner);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            if (var0 != null) {
                ((WorldGenStrongholdStart)var0).portalRoomPiece = this;
            }
        }

        public static WorldGenStrongholdPortalRoom createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -4, -1, 0, 11, 8, 16, var4);
            if (!WorldGenStrongholdPortalRoom.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new WorldGenStrongholdPortalRoom(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            BlockPosition.MutableBlockPosition var17;
            int var10;
            this.generateBox(var0, var4, 0, 0, 0, 10, 7, 15, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(var0, var3, var4, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.GRATES, 4, 1, 0);
            int var7 = 6;
            this.generateBox(var0, var4, 1, var7, 1, 1, var7, 14, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 9, var7, 1, 9, var7, 14, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 2, var7, 1, 8, var7, 2, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 2, var7, 14, 8, var7, 14, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 1, 1, 1, 2, 1, 4, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 8, 1, 1, 9, 1, 4, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 1, 1, 1, 1, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(var0, var4, 9, 1, 1, 9, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(var0, var4, 3, 1, 8, 7, 1, 12, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 1, 9, 6, 1, 11, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true);
            IBlockData var9 = (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true);
            for (var10 = 3; var10 < 14; var10 += 2) {
                this.generateBox(var0, var4, 0, 3, var10, 0, 4, var10, var8, var8, false);
                this.generateBox(var0, var4, 10, 3, var10, 10, 4, var10, var8, var8, false);
            }
            for (var10 = 2; var10 < 9; var10 += 2) {
                this.generateBox(var0, var4, var10, 3, 15, var10, 4, 15, var9, var9, false);
            }
            IBlockData var102 = (IBlockData)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.NORTH);
            this.generateBox(var0, var4, 4, 1, 5, 6, 1, 7, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 2, 6, 6, 2, 7, false, var3, SMOOTH_STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 3, 7, 6, 3, 7, false, var3, SMOOTH_STONE_SELECTOR);
            for (int var11 = 4; var11 <= 6; ++var11) {
                this.placeBlock(var0, var102, var11, 1, 4, var4);
                this.placeBlock(var0, var102, var11, 2, 5, var4);
                this.placeBlock(var0, var102, var11, 3, 6, var4);
            }
            IBlockData var11 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.NORTH);
            IBlockData var12 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.SOUTH);
            IBlockData var13 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.EAST);
            IBlockData var14 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.WEST);
            boolean var15 = true;
            boolean[] var16 = new boolean[12];
            for (int var172 = 0; var172 < var16.length; ++var172) {
                var16[var172] = var3.nextFloat() > 0.9f;
                var15 &= var16[var172];
            }
            this.placeBlock(var0, (IBlockData)var11.setValue(BlockEnderPortalFrame.HAS_EYE, var16[0]), 4, 3, 8, var4);
            this.placeBlock(var0, (IBlockData)var11.setValue(BlockEnderPortalFrame.HAS_EYE, var16[1]), 5, 3, 8, var4);
            this.placeBlock(var0, (IBlockData)var11.setValue(BlockEnderPortalFrame.HAS_EYE, var16[2]), 6, 3, 8, var4);
            this.placeBlock(var0, (IBlockData)var12.setValue(BlockEnderPortalFrame.HAS_EYE, var16[3]), 4, 3, 12, var4);
            this.placeBlock(var0, (IBlockData)var12.setValue(BlockEnderPortalFrame.HAS_EYE, var16[4]), 5, 3, 12, var4);
            this.placeBlock(var0, (IBlockData)var12.setValue(BlockEnderPortalFrame.HAS_EYE, var16[5]), 6, 3, 12, var4);
            this.placeBlock(var0, (IBlockData)var13.setValue(BlockEnderPortalFrame.HAS_EYE, var16[6]), 3, 3, 9, var4);
            this.placeBlock(var0, (IBlockData)var13.setValue(BlockEnderPortalFrame.HAS_EYE, var16[7]), 3, 3, 10, var4);
            this.placeBlock(var0, (IBlockData)var13.setValue(BlockEnderPortalFrame.HAS_EYE, var16[8]), 3, 3, 11, var4);
            this.placeBlock(var0, (IBlockData)var14.setValue(BlockEnderPortalFrame.HAS_EYE, var16[9]), 7, 3, 9, var4);
            this.placeBlock(var0, (IBlockData)var14.setValue(BlockEnderPortalFrame.HAS_EYE, var16[10]), 7, 3, 10, var4);
            this.placeBlock(var0, (IBlockData)var14.setValue(BlockEnderPortalFrame.HAS_EYE, var16[11]), 7, 3, 11, var4);
            if (var15) {
                IBlockData var173 = Blocks.END_PORTAL.defaultBlockState();
                this.placeBlock(var0, var173, 4, 3, 9, var4);
                this.placeBlock(var0, var173, 5, 3, 9, var4);
                this.placeBlock(var0, var173, 6, 3, 9, var4);
                this.placeBlock(var0, var173, 4, 3, 10, var4);
                this.placeBlock(var0, var173, 5, 3, 10, var4);
                this.placeBlock(var0, var173, 6, 3, 10, var4);
                this.placeBlock(var0, var173, 4, 3, 11, var4);
                this.placeBlock(var0, var173, 5, 3, 11, var4);
                this.placeBlock(var0, var173, 6, 3, 11, var4);
            }
            if (!this.hasPlacedSpawner && var4.isInside(var17 = this.getWorldPos(5, 3, 6))) {
                this.hasPlacedSpawner = true;
                var0.setBlock(var17, Blocks.SPAWNER.defaultBlockState(), 2);
                TileEntity var18 = var0.getBlockEntity(var17);
                if (var18 instanceof TileEntityMobSpawner) {
                    ((TileEntityMobSpawner)var18).getSpawner().setEntityId(EntityTypes.SILVERFISH);
                }
            }
        }
    }

    static abstract class WorldGenStrongholdPiece
    extends StructurePiece {
        protected WorldGenStrongholdDoorType entryDoor = WorldGenStrongholdDoorType.OPENING;

        protected WorldGenStrongholdPiece(WorldGenFeatureStructurePieceType var0, int var1, StructureBoundingBox var2) {
            super(var0, var1, var2);
        }

        public WorldGenStrongholdPiece(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
            super(var0, var1);
            this.entryDoor = WorldGenStrongholdDoorType.valueOf(var1.getString("EntryDoor"));
        }

        @Override
        public NoiseEffect getNoiseEffect() {
            return NoiseEffect.BURY;
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            var1.putString("EntryDoor", this.entryDoor.name());
        }

        protected void generateSmallDoor(GeneratorAccessSeed var0, Random var1, StructureBoundingBox var2, WorldGenStrongholdDoorType var3, int var4, int var5, int var6) {
            switch (var3) {
                case OPENING: {
                    this.generateBox(var0, var2, var4, var5, var6, var4 + 3 - 1, var5 + 3 - 1, var6, CAVE_AIR, CAVE_AIR, false);
                    break;
                }
                case WOOD_DOOR: {
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4, var5, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4, var5 + 1, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4, var5 + 2, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 1, var5 + 2, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 2, var5 + 2, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 2, var5 + 1, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 2, var5, var6, var2);
                    this.placeBlock(var0, Blocks.OAK_DOOR.defaultBlockState(), var4 + 1, var5, var6, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.OAK_DOOR.defaultBlockState().setValue(BlockDoor.HALF, BlockPropertyDoubleBlockHalf.UPPER), var4 + 1, var5 + 1, var6, var2);
                    break;
                }
                case GRATES: {
                    this.placeBlock(var0, Blocks.CAVE_AIR.defaultBlockState(), var4 + 1, var5, var6, var2);
                    this.placeBlock(var0, Blocks.CAVE_AIR.defaultBlockState(), var4 + 1, var5 + 1, var6, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true), var4, var5, var6, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true), var4, var5 + 1, var6, var2);
                    this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true), var4, var5 + 2, var6, var2);
                    this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true), var4 + 1, var5 + 2, var6, var2);
                    this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true), var4 + 2, var5 + 2, var6, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true), var4 + 2, var5 + 1, var6, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true), var4 + 2, var5, var6, var2);
                    break;
                }
                case IRON_DOOR: {
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4, var5, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4, var5 + 1, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4, var5 + 2, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 1, var5 + 2, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 2, var5 + 2, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 2, var5 + 1, var6, var2);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), var4 + 2, var5, var6, var2);
                    this.placeBlock(var0, Blocks.IRON_DOOR.defaultBlockState(), var4 + 1, var5, var6, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.IRON_DOOR.defaultBlockState().setValue(BlockDoor.HALF, BlockPropertyDoubleBlockHalf.UPPER), var4 + 1, var5 + 1, var6, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.STONE_BUTTON.defaultBlockState().setValue(BlockButtonAbstract.FACING, EnumDirection.NORTH), var4 + 2, var5 + 1, var6 + 1, var2);
                    this.placeBlock(var0, (IBlockData)Blocks.STONE_BUTTON.defaultBlockState().setValue(BlockButtonAbstract.FACING, EnumDirection.SOUTH), var4 + 2, var5 + 1, var6 - 1, var2);
                }
            }
        }

        protected WorldGenStrongholdDoorType randomSmallDoor(Random var0) {
            int var1 = var0.nextInt(5);
            switch (var1) {
                default: {
                    return WorldGenStrongholdDoorType.OPENING;
                }
                case 2: {
                    return WorldGenStrongholdDoorType.WOOD_DOOR;
                }
                case 3: {
                    return WorldGenStrongholdDoorType.GRATES;
                }
                case 4: 
            }
            return WorldGenStrongholdDoorType.IRON_DOOR;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildForward(WorldGenStrongholdStart var0, StructurePieceAccessor var1, Random var2, int var3, int var4) {
            EnumDirection var5 = this.getOrientation();
            if (var5 != null) {
                switch (var5) {
                    case NORTH: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var3, this.boundingBox.minY() + var4, this.boundingBox.minZ() - 1, var5, this.getGenDepth());
                    }
                    case SOUTH: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var3, this.boundingBox.minY() + var4, this.boundingBox.maxZ() + 1, var5, this.getGenDepth());
                    }
                    case WEST: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + var4, this.boundingBox.minZ() + var3, var5, this.getGenDepth());
                    }
                    case EAST: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + var4, this.boundingBox.minZ() + var3, var5, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildLeft(WorldGenStrongholdStart var0, StructurePieceAccessor var1, Random var2, int var3, int var4) {
            EnumDirection var5 = this.getOrientation();
            if (var5 != null) {
                switch (var5) {
                    case NORTH: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.WEST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.WEST, this.getGenDepth());
                    }
                    case WEST: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth());
                    }
                    case EAST: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildRight(WorldGenStrongholdStart var0, StructurePieceAccessor var1, Random var2, int var3, int var4) {
            EnumDirection var5 = this.getOrientation();
            if (var5 != null) {
                switch (var5) {
                    case NORTH: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.EAST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.EAST, this.getGenDepth());
                    }
                    case WEST: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth());
                    }
                    case EAST: {
                        return WorldGenStrongholdPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(StructureBoundingBox var0) {
            return var0 != null && var0.minY() > 10;
        }

        protected static final class WorldGenStrongholdDoorType
        extends Enum<WorldGenStrongholdDoorType> {
            public static final /* enum */ WorldGenStrongholdDoorType OPENING = new WorldGenStrongholdDoorType();
            public static final /* enum */ WorldGenStrongholdDoorType WOOD_DOOR = new WorldGenStrongholdDoorType();
            public static final /* enum */ WorldGenStrongholdDoorType GRATES = new WorldGenStrongholdDoorType();
            public static final /* enum */ WorldGenStrongholdDoorType IRON_DOOR = new WorldGenStrongholdDoorType();
            private static final /* synthetic */ WorldGenStrongholdDoorType[] e;

            public static WorldGenStrongholdDoorType[] values() {
                return (WorldGenStrongholdDoorType[])e.clone();
            }

            public static WorldGenStrongholdDoorType valueOf(String var0) {
                return Enum.valueOf(WorldGenStrongholdDoorType.class, var0);
            }

            private static /* synthetic */ WorldGenStrongholdDoorType[] a() {
                return new WorldGenStrongholdDoorType[]{OPENING, WOOD_DOOR, GRATES, IRON_DOOR};
            }

            static {
                e = WorldGenStrongholdDoorType.a();
            }
        }
    }

    public static class WorldGenStrongholdStart
    extends WorldGenStrongholdStairs2 {
        public WorldGenStrongholdPieceWeight previousPiece;
        @Nullable
        public WorldGenStrongholdPortalRoom portalRoomPiece;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public WorldGenStrongholdStart(Random var0, int var1, int var2) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_START, 0, var1, var2, WorldGenStrongholdStart.getRandomHorizontalDirection(var0));
        }

        public WorldGenStrongholdStart(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_START, var0);
        }

        @Override
        public BlockPosition getLocatorPosition() {
            if (this.portalRoomPiece != null) {
                return this.portalRoomPiece.getLocatorPosition();
            }
            return super.getLocatorPosition();
        }
    }

    public static class WorldGenStrongholdCorridor
    extends WorldGenStrongholdPiece {
        private final int steps;

        public WorldGenStrongholdCorridor(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FILLER_CORRIDOR, var0, var1);
            this.setOrientation(var2);
            this.steps = var2 == EnumDirection.NORTH || var2 == EnumDirection.SOUTH ? var1.getZSpan() : var1.getXSpan();
        }

        public WorldGenStrongholdCorridor(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FILLER_CORRIDOR, var0);
            this.steps = var0.getInt("Steps");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putInt("Steps", this.steps);
        }

        public static StructureBoundingBox findPieceBox(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5) {
            int var6 = 3;
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 5, 5, 4, var5);
            StructurePiece var8 = var0.findCollisionPiece(var7);
            if (var8 == null) {
                return null;
            }
            if (var8.getBoundingBox().minY() == var7.minY()) {
                for (int var9 = 2; var9 >= 1; --var9) {
                    var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 5, 5, var9, var5);
                    if (var8.getBoundingBox().intersects(var7)) continue;
                    return StructureBoundingBox.orientBox(var2, var3, var4, -1, -1, 0, 5, 5, var9 + 1, var5);
                }
            }
            return null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            for (int var7 = 0; var7 < this.steps; ++var7) {
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 0, 0, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 0, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 2, 0, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3, 0, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 4, 0, var7, var4);
                for (int var8 = 1; var8 <= 3; ++var8) {
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 0, var8, var7, var4);
                    this.placeBlock(var0, Blocks.CAVE_AIR.defaultBlockState(), 1, var8, var7, var4);
                    this.placeBlock(var0, Blocks.CAVE_AIR.defaultBlockState(), 2, var8, var7, var4);
                    this.placeBlock(var0, Blocks.CAVE_AIR.defaultBlockState(), 3, var8, var7, var4);
                    this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 4, var8, var7, var4);
                }
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 0, 4, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 3, 4, var7, var4);
                this.placeBlock(var0, Blocks.STONE_BRICKS.defaultBlockState(), 4, 4, var7, var4);
            }
        }
    }

    static class WorldGenStrongholdStones
    extends StructurePiece.StructurePieceBlockSelector {
        WorldGenStrongholdStones() {
        }

        @Override
        public void next(Random var0, int var1, int var2, int var3, boolean var4) {
            float var5;
            this.next = var4 ? ((var5 = var0.nextFloat()) < 0.2f ? Blocks.CRACKED_STONE_BRICKS.defaultBlockState() : (var5 < 0.5f ? Blocks.MOSSY_STONE_BRICKS.defaultBlockState() : (var5 < 0.55f ? Blocks.INFESTED_STONE_BRICKS.defaultBlockState() : Blocks.STONE_BRICKS.defaultBlockState()))) : Blocks.CAVE_AIR.defaultBlockState();
        }
    }

    public static abstract class q
    extends WorldGenStrongholdPiece {
        protected static final int WIDTH = 5;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 5;

        protected q(WorldGenFeatureStructurePieceType var0, int var1, StructureBoundingBox var2) {
            super(var0, var1, var2);
        }

        public q(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
            super(var0, var1);
        }
    }
}

