/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenScatteredPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.storage.loot.LootTables;

public class WorldGenJunglePyramidPiece
extends WorldGenScatteredPiece {
    public static final int WIDTH = 12;
    public static final int DEPTH = 15;
    private boolean placedMainChest;
    private boolean placedHiddenChest;
    private boolean placedTrap1;
    private boolean placedTrap2;
    private static final a STONE_SELECTOR = new a();

    public WorldGenJunglePyramidPiece(Random var0, int var1, int var2) {
        super(WorldGenFeatureStructurePieceType.JUNGLE_PYRAMID_PIECE, var1, 64, var2, 12, 10, 15, WorldGenJunglePyramidPiece.getRandomHorizontalDirection(var0));
    }

    public WorldGenJunglePyramidPiece(NBTTagCompound var0) {
        super(WorldGenFeatureStructurePieceType.JUNGLE_PYRAMID_PIECE, var0);
        this.placedMainChest = var0.getBoolean("placedMainChest");
        this.placedHiddenChest = var0.getBoolean("placedHiddenChest");
        this.placedTrap1 = var0.getBoolean("placedTrap1");
        this.placedTrap2 = var0.getBoolean("placedTrap2");
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        super.addAdditionalSaveData(var0, var1);
        var1.putBoolean("placedMainChest", this.placedMainChest);
        var1.putBoolean("placedHiddenChest", this.placedHiddenChest);
        var1.putBoolean("placedTrap1", this.placedTrap1);
        var1.putBoolean("placedTrap2", this.placedTrap2);
    }

    @Override
    public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
        int var11;
        int var7;
        if (!this.updateAverageGroundHeight(var0, var4, 0)) {
            return;
        }
        this.generateBox(var0, var4, 0, -4, 0, this.width - 1, 0, this.depth - 1, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 2, 1, 2, 9, 2, 2, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 2, 1, 12, 9, 2, 12, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 2, 1, 3, 2, 2, 11, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 9, 1, 3, 9, 2, 11, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 1, 3, 1, 10, 6, 1, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 1, 3, 13, 10, 6, 13, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 1, 3, 2, 1, 6, 12, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 10, 3, 2, 10, 6, 12, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 2, 3, 2, 9, 3, 12, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 2, 6, 2, 9, 6, 12, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 3, 7, 3, 8, 7, 11, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 4, 8, 4, 7, 8, 10, false, var3, STONE_SELECTOR);
        this.generateAirBox(var0, var4, 3, 1, 3, 8, 2, 11);
        this.generateAirBox(var0, var4, 4, 3, 6, 7, 3, 9);
        this.generateAirBox(var0, var4, 2, 4, 2, 9, 5, 12);
        this.generateAirBox(var0, var4, 4, 6, 5, 7, 6, 9);
        this.generateAirBox(var0, var4, 5, 7, 6, 6, 7, 8);
        this.generateAirBox(var0, var4, 5, 1, 2, 6, 2, 2);
        this.generateAirBox(var0, var4, 5, 2, 12, 6, 2, 12);
        this.generateAirBox(var0, var4, 5, 5, 1, 6, 5, 1);
        this.generateAirBox(var0, var4, 5, 5, 13, 6, 5, 13);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 1, 5, 5, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 10, 5, 5, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 1, 5, 9, var4);
        this.placeBlock(var0, Blocks.AIR.defaultBlockState(), 10, 5, 9, var4);
        for (var7 = 0; var7 <= 14; var7 += 14) {
            this.generateBox(var0, var4, 2, 4, var7, 2, 5, var7, false, var3, STONE_SELECTOR);
            this.generateBox(var0, var4, 4, 4, var7, 4, 5, var7, false, var3, STONE_SELECTOR);
            this.generateBox(var0, var4, 7, 4, var7, 7, 5, var7, false, var3, STONE_SELECTOR);
            this.generateBox(var0, var4, 9, 4, var7, 9, 5, var7, false, var3, STONE_SELECTOR);
        }
        this.generateBox(var0, var4, 5, 6, 0, 6, 6, 0, false, var3, STONE_SELECTOR);
        for (var7 = 0; var7 <= 11; var7 += 11) {
            for (int var8 = 2; var8 <= 12; var8 += 2) {
                this.generateBox(var0, var4, var7, 4, var8, var7, 5, var8, false, var3, STONE_SELECTOR);
            }
            this.generateBox(var0, var4, var7, 6, 5, var7, 6, 5, false, var3, STONE_SELECTOR);
            this.generateBox(var0, var4, var7, 6, 9, var7, 6, 9, false, var3, STONE_SELECTOR);
        }
        this.generateBox(var0, var4, 2, 7, 2, 2, 9, 2, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 9, 7, 2, 9, 9, 2, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 2, 7, 12, 2, 9, 12, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 9, 7, 12, 9, 9, 12, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 4, 9, 4, 4, 9, 4, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 7, 9, 4, 7, 9, 4, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 4, 9, 10, 4, 9, 10, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 7, 9, 10, 7, 9, 10, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 5, 9, 7, 6, 9, 7, false, var3, STONE_SELECTOR);
        IBlockData var72 = (IBlockData)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.EAST);
        IBlockData var8 = (IBlockData)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.WEST);
        IBlockData var9 = (IBlockData)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.SOUTH);
        IBlockData var10 = (IBlockData)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.NORTH);
        this.placeBlock(var0, var10, 5, 9, 6, var4);
        this.placeBlock(var0, var10, 6, 9, 6, var4);
        this.placeBlock(var0, var9, 5, 9, 8, var4);
        this.placeBlock(var0, var9, 6, 9, 8, var4);
        this.placeBlock(var0, var10, 4, 0, 0, var4);
        this.placeBlock(var0, var10, 5, 0, 0, var4);
        this.placeBlock(var0, var10, 6, 0, 0, var4);
        this.placeBlock(var0, var10, 7, 0, 0, var4);
        this.placeBlock(var0, var10, 4, 1, 8, var4);
        this.placeBlock(var0, var10, 4, 2, 9, var4);
        this.placeBlock(var0, var10, 4, 3, 10, var4);
        this.placeBlock(var0, var10, 7, 1, 8, var4);
        this.placeBlock(var0, var10, 7, 2, 9, var4);
        this.placeBlock(var0, var10, 7, 3, 10, var4);
        this.generateBox(var0, var4, 4, 1, 9, 4, 1, 9, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 7, 1, 9, 7, 1, 9, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 4, 1, 10, 7, 2, 10, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 5, 4, 5, 6, 4, 5, false, var3, STONE_SELECTOR);
        this.placeBlock(var0, var72, 4, 4, 5, var4);
        this.placeBlock(var0, var8, 7, 4, 5, var4);
        for (var11 = 0; var11 < 4; ++var11) {
            this.placeBlock(var0, var9, 5, 0 - var11, 6 + var11, var4);
            this.placeBlock(var0, var9, 6, 0 - var11, 6 + var11, var4);
            this.generateAirBox(var0, var4, 5, 0 - var11, 7 + var11, 6, 0 - var11, 9 + var11);
        }
        this.generateAirBox(var0, var4, 1, -3, 12, 10, -1, 13);
        this.generateAirBox(var0, var4, 1, -3, 1, 3, -1, 13);
        this.generateAirBox(var0, var4, 1, -3, 1, 9, -1, 5);
        for (var11 = 1; var11 <= 13; var11 += 2) {
            this.generateBox(var0, var4, 1, -3, var11, 1, -2, var11, false, var3, STONE_SELECTOR);
        }
        for (var11 = 2; var11 <= 12; var11 += 2) {
            this.generateBox(var0, var4, 1, -1, var11, 3, -1, var11, false, var3, STONE_SELECTOR);
        }
        this.generateBox(var0, var4, 2, -2, 1, 5, -2, 1, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 7, -2, 1, 9, -2, 1, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 6, -3, 1, 6, -3, 1, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 6, -1, 1, 6, -1, 1, false, var3, STONE_SELECTOR);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.TRIPWIRE_HOOK.defaultBlockState().setValue(BlockTripwireHook.FACING, EnumDirection.EAST)).setValue(BlockTripwireHook.ATTACHED, true), 1, -3, 8, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.TRIPWIRE_HOOK.defaultBlockState().setValue(BlockTripwireHook.FACING, EnumDirection.WEST)).setValue(BlockTripwireHook.ATTACHED, true), 4, -3, 8, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)((IBlockData)Blocks.TRIPWIRE.defaultBlockState().setValue(BlockTripwire.EAST, true)).setValue(BlockTripwire.WEST, true)).setValue(BlockTripwire.ATTACHED, true), 2, -3, 8, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)((IBlockData)Blocks.TRIPWIRE.defaultBlockState().setValue(BlockTripwire.EAST, true)).setValue(BlockTripwire.WEST, true)).setValue(BlockTripwire.ATTACHED, true), 3, -3, 8, var4);
        IBlockData var112 = (IBlockData)((IBlockData)Blocks.REDSTONE_WIRE.defaultBlockState().setValue(BlockRedstoneWire.NORTH, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.SOUTH, BlockPropertyRedstoneSide.SIDE);
        this.placeBlock(var0, var112, 5, -3, 7, var4);
        this.placeBlock(var0, var112, 5, -3, 6, var4);
        this.placeBlock(var0, var112, 5, -3, 5, var4);
        this.placeBlock(var0, var112, 5, -3, 4, var4);
        this.placeBlock(var0, var112, 5, -3, 3, var4);
        this.placeBlock(var0, var112, 5, -3, 2, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.REDSTONE_WIRE.defaultBlockState().setValue(BlockRedstoneWire.NORTH, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.WEST, BlockPropertyRedstoneSide.SIDE), 5, -3, 1, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.REDSTONE_WIRE.defaultBlockState().setValue(BlockRedstoneWire.EAST, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.WEST, BlockPropertyRedstoneSide.SIDE), 4, -3, 1, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 3, -3, 1, var4);
        if (!this.placedTrap1) {
            this.placedTrap1 = this.createDispenser(var0, var4, var3, 3, -2, 1, EnumDirection.NORTH, LootTables.JUNGLE_TEMPLE_DISPENSER);
        }
        this.placeBlock(var0, (IBlockData)Blocks.VINE.defaultBlockState().setValue(BlockVine.SOUTH, true), 3, -2, 2, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.TRIPWIRE_HOOK.defaultBlockState().setValue(BlockTripwireHook.FACING, EnumDirection.NORTH)).setValue(BlockTripwireHook.ATTACHED, true), 7, -3, 1, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.TRIPWIRE_HOOK.defaultBlockState().setValue(BlockTripwireHook.FACING, EnumDirection.SOUTH)).setValue(BlockTripwireHook.ATTACHED, true), 7, -3, 5, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)((IBlockData)Blocks.TRIPWIRE.defaultBlockState().setValue(BlockTripwire.NORTH, true)).setValue(BlockTripwire.SOUTH, true)).setValue(BlockTripwire.ATTACHED, true), 7, -3, 2, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)((IBlockData)Blocks.TRIPWIRE.defaultBlockState().setValue(BlockTripwire.NORTH, true)).setValue(BlockTripwire.SOUTH, true)).setValue(BlockTripwire.ATTACHED, true), 7, -3, 3, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)((IBlockData)Blocks.TRIPWIRE.defaultBlockState().setValue(BlockTripwire.NORTH, true)).setValue(BlockTripwire.SOUTH, true)).setValue(BlockTripwire.ATTACHED, true), 7, -3, 4, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.REDSTONE_WIRE.defaultBlockState().setValue(BlockRedstoneWire.EAST, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.WEST, BlockPropertyRedstoneSide.SIDE), 8, -3, 6, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.REDSTONE_WIRE.defaultBlockState().setValue(BlockRedstoneWire.WEST, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.SOUTH, BlockPropertyRedstoneSide.SIDE), 9, -3, 6, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.REDSTONE_WIRE.defaultBlockState().setValue(BlockRedstoneWire.NORTH, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.SOUTH, BlockPropertyRedstoneSide.UP), 9, -3, 5, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 9, -3, 4, var4);
        this.placeBlock(var0, var112, 9, -2, 4, var4);
        if (!this.placedTrap2) {
            this.placedTrap2 = this.createDispenser(var0, var4, var3, 9, -2, 3, EnumDirection.WEST, LootTables.JUNGLE_TEMPLE_DISPENSER);
        }
        this.placeBlock(var0, (IBlockData)Blocks.VINE.defaultBlockState().setValue(BlockVine.EAST, true), 8, -1, 3, var4);
        this.placeBlock(var0, (IBlockData)Blocks.VINE.defaultBlockState().setValue(BlockVine.EAST, true), 8, -2, 3, var4);
        if (!this.placedMainChest) {
            this.placedMainChest = this.createChest(var0, var4, var3, 8, -3, 3, LootTables.JUNGLE_TEMPLE);
        }
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 9, -3, 2, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 8, -3, 1, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 4, -3, 5, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 5, -2, 5, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 5, -1, 5, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 6, -3, 5, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 7, -2, 5, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 7, -1, 5, var4);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 8, -3, 5, var4);
        this.generateBox(var0, var4, 9, -1, 1, 9, -1, 5, false, var3, STONE_SELECTOR);
        this.generateAirBox(var0, var4, 8, -3, 8, 10, -1, 10);
        this.placeBlock(var0, Blocks.CHISELED_STONE_BRICKS.defaultBlockState(), 8, -2, 11, var4);
        this.placeBlock(var0, Blocks.CHISELED_STONE_BRICKS.defaultBlockState(), 9, -2, 11, var4);
        this.placeBlock(var0, Blocks.CHISELED_STONE_BRICKS.defaultBlockState(), 10, -2, 11, var4);
        IBlockData var12 = (IBlockData)((IBlockData)Blocks.LEVER.defaultBlockState().setValue(BlockLever.FACING, EnumDirection.NORTH)).setValue(BlockLever.FACE, BlockPropertyAttachPosition.WALL);
        this.placeBlock(var0, var12, 8, -2, 12, var4);
        this.placeBlock(var0, var12, 9, -2, 12, var4);
        this.placeBlock(var0, var12, 10, -2, 12, var4);
        this.generateBox(var0, var4, 8, -3, 8, 8, -3, 10, false, var3, STONE_SELECTOR);
        this.generateBox(var0, var4, 10, -3, 8, 10, -3, 10, false, var3, STONE_SELECTOR);
        this.placeBlock(var0, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 10, -2, 9, var4);
        this.placeBlock(var0, var112, 8, -2, 9, var4);
        this.placeBlock(var0, var112, 8, -2, 10, var4);
        this.placeBlock(var0, (IBlockData)((IBlockData)((IBlockData)((IBlockData)Blocks.REDSTONE_WIRE.defaultBlockState().setValue(BlockRedstoneWire.NORTH, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.SOUTH, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.EAST, BlockPropertyRedstoneSide.SIDE)).setValue(BlockRedstoneWire.WEST, BlockPropertyRedstoneSide.SIDE), 10, -1, 9, var4);
        this.placeBlock(var0, (IBlockData)Blocks.STICKY_PISTON.defaultBlockState().setValue(BlockPiston.FACING, EnumDirection.UP), 9, -2, 8, var4);
        this.placeBlock(var0, (IBlockData)Blocks.STICKY_PISTON.defaultBlockState().setValue(BlockPiston.FACING, EnumDirection.WEST), 10, -2, 8, var4);
        this.placeBlock(var0, (IBlockData)Blocks.STICKY_PISTON.defaultBlockState().setValue(BlockPiston.FACING, EnumDirection.WEST), 10, -1, 8, var4);
        this.placeBlock(var0, (IBlockData)Blocks.REPEATER.defaultBlockState().setValue(BlockRepeater.FACING, EnumDirection.NORTH), 10, -2, 10, var4);
        if (!this.placedHiddenChest) {
            this.placedHiddenChest = this.createChest(var0, var4, var3, 9, -3, 10, LootTables.JUNGLE_TEMPLE);
        }
    }

    static class a
    extends StructurePiece.StructurePieceBlockSelector {
        a() {
        }

        @Override
        public void next(Random var0, int var1, int var2, int var3, boolean var4) {
            this.next = var0.nextFloat() < 0.4f ? Blocks.COBBLESTONE.defaultBlockState() : Blocks.MOSSY_COBBLESTONE.defaultBlockState();
        }
    }
}

