/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public record StructureSet(List<a> structures, StructurePlacement placement) {
    public static final Codec<StructureSet> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)a.CODEC.listOf().fieldOf("structures").forGetter(StructureSet::structures), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(StructureSet::placement)).apply((Applicative)var0, StructureSet::new));
    public static final Codec<Holder<StructureSet>> CODEC = RegistryFileCodec.create(IRegistry.STRUCTURE_SET_REGISTRY, DIRECT_CODEC);

    public StructureSet(Holder<StructureFeature<?, ?>> var0, StructurePlacement var1) {
        this(List.of(new a(var0, 1)), var1);
    }

    public static a entry(Holder<StructureFeature<?, ?>> var0, int var1) {
        return new a(var0, var1);
    }

    public static a entry(Holder<StructureFeature<?, ?>> var0) {
        return new a(var0, 1);
    }

    public record a(Holder<StructureFeature<?, ?>> structure, int weight) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)StructureFeature.CODEC.fieldOf("structure").forGetter(a::structure), (App)ExtraCodecs.POSITIVE_INT.fieldOf("weight").forGetter(a::weight)).apply((Applicative)var0, a::new));

        public boolean generatesInMatchingBiome(Predicate<Holder<BiomeBase>> var0) {
            HolderSet<BiomeBase> var1 = this.structure().value().biomes();
            return var1.stream().anyMatch(var0);
        }
    }
}

