/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.slf4j.Logger;

public abstract class DefinedStructurePiece
extends StructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final String templateName;
    protected DefinedStructure template;
    protected DefinedStructureInfo placeSettings;
    protected BlockPosition templatePosition;

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType var0, int var1, DefinedStructureManager var2, MinecraftKey var3, String var4, DefinedStructureInfo var5, BlockPosition var6) {
        super(var0, var1, var2.getOrCreate(var3).getBoundingBox(var5, var6));
        this.setOrientation(EnumDirection.NORTH);
        this.templateName = var4;
        this.templatePosition = var6;
        this.template = var2.getOrCreate(var3);
        this.placeSettings = var5;
    }

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1, DefinedStructureManager var2, Function<MinecraftKey, DefinedStructureInfo> var3) {
        super(var0, var1);
        this.setOrientation(EnumDirection.NORTH);
        this.templateName = var1.getString("Template");
        this.templatePosition = new BlockPosition(var1.getInt("TPX"), var1.getInt("TPY"), var1.getInt("TPZ"));
        MinecraftKey var4 = this.makeTemplateLocation();
        this.template = var2.getOrCreate(var4);
        this.placeSettings = var3.apply(var4);
        this.boundingBox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
    }

    protected MinecraftKey makeTemplateLocation() {
        return new MinecraftKey(this.templateName);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        var1.putInt("TPX", this.templatePosition.getX());
        var1.putInt("TPY", this.templatePosition.getY());
        var1.putInt("TPZ", this.templatePosition.getZ());
        var1.putString("Template", this.templateName);
    }

    @Override
    public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
        this.placeSettings.setBoundingBox(var4);
        this.boundingBox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (this.template.placeInWorld(var0, this.templatePosition, var6, this.placeSettings, var3, 2)) {
            List<DefinedStructure.BlockInfo> var7 = this.template.filterBlocks(this.templatePosition, this.placeSettings, Blocks.STRUCTURE_BLOCK);
            for (DefinedStructure.BlockInfo var9 : var7) {
                BlockPropertyStructureMode blockPropertyStructureMode;
                if (var9.nbt == null || (blockPropertyStructureMode = BlockPropertyStructureMode.valueOf(var9.nbt.getString("mode"))) != BlockPropertyStructureMode.DATA) continue;
                this.handleDataMarker(var9.nbt.getString("metadata"), var9.pos, var0, var3, var4);
            }
            List<DefinedStructure.BlockInfo> var8 = this.template.filterBlocks(this.templatePosition, this.placeSettings, Blocks.JIGSAW);
            for (DefinedStructure.BlockInfo blockInfo : var8) {
                if (blockInfo.nbt == null) continue;
                String var11 = blockInfo.nbt.getString("final_state");
                ArgumentBlock var12 = new ArgumentBlock(new StringReader(var11), false);
                IBlockData var13 = Blocks.AIR.defaultBlockState();
                try {
                    var12.parse(true);
                    IBlockData var14 = var12.getState();
                    if (var14 != null) {
                        var13 = var14;
                    } else {
                        LOGGER.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)var11, (Object)blockInfo.pos);
                    }
                }
                catch (CommandSyntaxException var14) {
                    LOGGER.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)var11, (Object)blockInfo.pos);
                }
                var0.setBlock(blockInfo.pos, var13, 3);
            }
        }
    }

    protected abstract void handleDataMarker(String var1, BlockPosition var2, WorldAccess var3, Random var4, StructureBoundingBox var5);

    @Override
    @Deprecated
    public void move(int var0, int var1, int var2) {
        super.move(var0, var1, var2);
        this.templatePosition = this.templatePosition.offset(var0, var1, var2);
    }

    @Override
    public EnumBlockRotation getRotation() {
        return this.placeSettings.getRotation();
    }
}

