/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class TrapezoidHeight
extends HeightProvider {
    public static final Codec<TrapezoidHeight> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(var0 -> var0.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(var0 -> var0.maxInclusive), (App)Codec.INT.optionalFieldOf("plateau", (Object)0).forGetter(var0 -> var0.plateau)).apply((Applicative)var02, TrapezoidHeight::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;
    private final int plateau;

    private TrapezoidHeight(VerticalAnchor var0, VerticalAnchor var1, int var2) {
        this.minInclusive = var0;
        this.maxInclusive = var1;
        this.plateau = var2;
    }

    public static TrapezoidHeight of(VerticalAnchor var0, VerticalAnchor var1, int var2) {
        return new TrapezoidHeight(var0, var1, var2);
    }

    public static TrapezoidHeight of(VerticalAnchor var0, VerticalAnchor var1) {
        return TrapezoidHeight.of(var0, var1, 0);
    }

    @Override
    public int sample(Random var0, WorldGenerationContext var1) {
        int var3;
        int var2 = this.minInclusive.resolveY(var1);
        if (var2 > (var3 = this.maxInclusive.resolveY(var1))) {
            LOGGER.warn("Empty height range: {}", (Object)this);
            return var2;
        }
        int var4 = var3 - var2;
        if (this.plateau >= var4) {
            return MathHelper.randomBetweenInclusive(var0, var2, var3);
        }
        int var5 = (var4 - this.plateau) / 2;
        int var6 = var4 - var5;
        return var2 + MathHelper.randomBetweenInclusive(var0, 0, var6) + MathHelper.randomBetweenInclusive(var0, 0, var5);
    }

    @Override
    public HeightProviderType<?> getType() {
        return HeightProviderType.TRAPEZOID;
    }

    public String toString() {
        if (this.plateau == 0) {
            return "triangle (" + this.minInclusive + "-" + this.maxInclusive + ")";
        }
        return "trapezoid(" + this.plateau + ") in [" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

