/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.flat.WorldGenFlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class GeneratorSettingsFlat {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<GeneratorSettingsFlat> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RegistryOps.retrieveRegistry(IRegistry.BIOME_REGISTRY).forGetter(var0 -> var0.biomes), (App)RegistryCodecs.homogeneousList(IRegistry.STRUCTURE_SET_REGISTRY).optionalFieldOf("structure_overrides").forGetter(var0 -> var0.structureOverrides), (App)WorldGenFlatLayerInfo.CODEC.listOf().fieldOf("layers").forGetter(GeneratorSettingsFlat::getLayersInfo), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(var0 -> var0.addLakes), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(var0 -> var0.decoration), (App)BiomeBase.CODEC.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(var0 -> Optional.of(var0.biome))).apply((Applicative)var02, GeneratorSettingsFlat::new)).comapFlatMap(GeneratorSettingsFlat::validateHeight, Function.identity()).stable();
    private final IRegistry<BiomeBase> biomes;
    private final Optional<HolderSet<StructureSet>> structureOverrides;
    private final List<WorldGenFlatLayerInfo> layersInfo = Lists.newArrayList();
    private Holder<BiomeBase> biome;
    private final List<IBlockData> layers;
    private boolean voidGen;
    private boolean decoration;
    private boolean addLakes;

    private static DataResult<GeneratorSettingsFlat> validateHeight(GeneratorSettingsFlat var0) {
        int var1 = var0.layersInfo.stream().mapToInt(WorldGenFlatLayerInfo::getHeight).sum();
        if (var1 > DimensionManager.Y_SIZE) {
            return DataResult.error((String)("Sum of layer heights is > " + DimensionManager.Y_SIZE), (Object)var0);
        }
        return DataResult.success((Object)var0);
    }

    private GeneratorSettingsFlat(IRegistry<BiomeBase> var0, Optional<HolderSet<StructureSet>> var1, List<WorldGenFlatLayerInfo> var2, boolean var3, boolean var4, Optional<Holder<BiomeBase>> var5) {
        this(var1, var0);
        if (var3) {
            this.setAddLakes();
        }
        if (var4) {
            this.setDecoration();
        }
        this.layersInfo.addAll(var2);
        this.updateLayers();
        if (var5.isEmpty()) {
            LOGGER.error("Unknown biome, defaulting to plains");
            this.biome = var0.getOrCreateHolder(Biomes.PLAINS);
        } else {
            this.biome = var5.get();
        }
    }

    public GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> var0, IRegistry<BiomeBase> var1) {
        this.biomes = var1;
        this.structureOverrides = var0;
        this.biome = var1.getOrCreateHolder(Biomes.PLAINS);
        this.layers = Lists.newArrayList();
    }

    public GeneratorSettingsFlat withLayers(List<WorldGenFlatLayerInfo> var0, Optional<HolderSet<StructureSet>> var1) {
        GeneratorSettingsFlat var2 = new GeneratorSettingsFlat(var1, this.biomes);
        for (WorldGenFlatLayerInfo var4 : var0) {
            var2.layersInfo.add(new WorldGenFlatLayerInfo(var4.getHeight(), var4.getBlockState().getBlock()));
            var2.updateLayers();
        }
        var2.setBiome(this.biome);
        if (this.decoration) {
            var2.setDecoration();
        }
        if (this.addLakes) {
            var2.setAddLakes();
        }
        return var2;
    }

    public void setDecoration() {
        this.decoration = true;
    }

    public void setAddLakes() {
        this.addLakes = true;
    }

    public Holder<BiomeBase> getBiomeFromSettings() {
        Object var6;
        int var5;
        List<Object> var4;
        boolean var3;
        BiomeBase var0 = this.getBiome().value();
        BiomeSettingsGeneration var1 = var0.getGenerationSettings();
        BiomeSettingsGeneration.a var2 = new BiomeSettingsGeneration.a();
        if (this.addLakes) {
            var2.addFeature(WorldGenStage.Decoration.LAKES, MiscOverworldPlacements.LAKE_LAVA_UNDERGROUND);
            var2.addFeature(WorldGenStage.Decoration.LAKES, MiscOverworldPlacements.LAKE_LAVA_SURFACE);
        }
        boolean bl = var3 = (!this.voidGen || this.biome.is(Biomes.THE_VOID)) && this.decoration;
        if (var3) {
            var4 = var1.features();
            for (var5 = 0; var5 < var4.size(); ++var5) {
                if (var5 == WorldGenStage.Decoration.UNDERGROUND_STRUCTURES.ordinal() || var5 == WorldGenStage.Decoration.SURFACE_STRUCTURES.ordinal()) continue;
                var6 = (HolderSet)var4.get(var5);
                Iterator iterator = var6.iterator();
                while (iterator.hasNext()) {
                    Holder var8 = (Holder)iterator.next();
                    var2.addFeature(var5, (Holder<PlacedFeature>)var8);
                }
            }
        }
        var4 = this.getLayers();
        for (var5 = 0; var5 < var4.size(); ++var5) {
            var6 = (IBlockData)var4.get(var5);
            if (HeightMap.Type.MOTION_BLOCKING.isOpaque().test((IBlockData)var6)) continue;
            var4.set(var5, null);
            var2.addFeature(WorldGenStage.Decoration.TOP_LAYER_MODIFICATION, PlacementUtils.inlinePlaced(WorldGenerator.FILL_LAYER, new WorldGenFeatureFillConfiguration(var5, (IBlockData)var6), new PlacementModifier[0]));
        }
        return Holder.direct(BiomeBase.a.from(var0).generationSettings(var2.build()).build());
    }

    public Optional<HolderSet<StructureSet>> structureOverrides() {
        return this.structureOverrides;
    }

    public Holder<BiomeBase> getBiome() {
        return this.biome;
    }

    public void setBiome(Holder<BiomeBase> var0) {
        this.biome = var0;
    }

    public List<WorldGenFlatLayerInfo> getLayersInfo() {
        return this.layersInfo;
    }

    public List<IBlockData> getLayers() {
        return this.layers;
    }

    public void updateLayers() {
        this.layers.clear();
        for (WorldGenFlatLayerInfo var1 : this.layersInfo) {
            for (int var2 = 0; var2 < var1.getHeight(); ++var2) {
                this.layers.add(var1.getBlockState());
            }
        }
        this.voidGen = this.layers.stream().allMatch(var0 -> var0.is(Blocks.AIR));
    }

    public static GeneratorSettingsFlat getDefault(IRegistry<BiomeBase> var0, IRegistry<StructureSet> var1) {
        HolderSet.a var2 = HolderSet.direct(var1.getHolderOrThrow(BuiltinStructureSets.STRONGHOLDS), var1.getHolderOrThrow(BuiltinStructureSets.VILLAGES));
        GeneratorSettingsFlat var3 = new GeneratorSettingsFlat(Optional.of(var2), var0);
        var3.biome = var0.getOrCreateHolder(Biomes.PLAINS);
        var3.getLayersInfo().add(new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
        var3.getLayersInfo().add(new WorldGenFlatLayerInfo(2, Blocks.DIRT));
        var3.getLayersInfo().add(new WorldGenFlatLayerInfo(1, Blocks.GRASS_BLOCK));
        var3.updateLayers();
        return var3;
    }
}

