/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class WorldGenFeatureTreeVineLeaves
extends WorldGenFeatureTree {
    public static final Codec<WorldGenFeatureTreeVineLeaves> CODEC = Codec.unit(() -> INSTANCE);
    public static final WorldGenFeatureTreeVineLeaves INSTANCE = new WorldGenFeatureTreeVineLeaves();

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.LEAVE_VINE;
    }

    @Override
    public void place(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, Random var2, List<BlockPosition> var32, List<BlockPosition> var4) {
        var4.forEach(var3 -> {
            BlockPosition var4;
            if (var2.nextInt(4) == 0 && WorldGenerator.isAir(var0, var4 = var3.west())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var0, var4, BlockVine.EAST, var1);
            }
            if (var2.nextInt(4) == 0 && WorldGenerator.isAir(var0, var4 = var3.east())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var0, var4, BlockVine.WEST, var1);
            }
            if (var2.nextInt(4) == 0 && WorldGenerator.isAir(var0, var4 = var3.north())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var0, var4, BlockVine.SOUTH, var1);
            }
            if (var2.nextInt(4) == 0 && WorldGenerator.isAir(var0, var4 = var3.south())) {
                WorldGenFeatureTreeVineLeaves.addHangingVine(var0, var4, BlockVine.NORTH, var1);
            }
        });
    }

    private static void addHangingVine(VirtualLevelReadable var0, BlockPosition var1, BlockStateBoolean var2, BiConsumer<BlockPosition, IBlockData> var3) {
        WorldGenFeatureTreeVineLeaves.placeVine(var3, var1, var2);
        var1 = var1.below();
        for (int var4 = 4; WorldGenerator.isAir(var0, var1) && var4 > 0; --var4) {
            WorldGenFeatureTreeVineLeaves.placeVine(var3, var1, var2);
            var1 = var1.below();
        }
    }
}

