/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class WorldGenFeatureTreeBeehive
extends WorldGenFeatureTree {
    public static final Codec<WorldGenFeatureTreeBeehive> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(WorldGenFeatureTreeBeehive::new, var0 -> Float.valueOf(var0.probability)).codec();
    private static final EnumDirection WORLDGEN_FACING = EnumDirection.SOUTH;
    private static final EnumDirection[] SPAWN_DIRECTIONS = (EnumDirection[])EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().filter(var0 -> var0 != WORLDGEN_FACING.getOpposite()).toArray(EnumDirection[]::new);
    private final float probability;

    public WorldGenFeatureTreeBeehive(float var0) {
        this.probability = var0;
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.BEEHIVE;
    }

    @Override
    public void place(VirtualLevelReadable var02, BiConsumer<BlockPosition, IBlockData> var12, Random var2, List<BlockPosition> var3, List<BlockPosition> var4) {
        if (var2.nextFloat() >= this.probability) {
            return;
        }
        int var5 = !var4.isEmpty() ? Math.max(var4.get(0).getY() - 1, var3.get(0).getY() + 1) : Math.min(var3.get(0).getY() + 1 + var2.nextInt(3), var3.get(var3.size() - 1).getY());
        List var6 = var3.stream().filter(var1 -> var1.getY() == var5).flatMap(var0 -> Stream.of(SPAWN_DIRECTIONS).map(var0::relative)).collect(Collectors.toList());
        if (var6.isEmpty()) {
            return;
        }
        Collections.shuffle(var6);
        Optional<BlockPosition> var7 = var6.stream().filter(var1 -> WorldGenerator.isAir(var02, var1) && WorldGenerator.isAir(var02, var1.relative(WORLDGEN_FACING))).findFirst();
        if (var7.isEmpty()) {
            return;
        }
        var12.accept(var7.get(), (IBlockData)Blocks.BEE_NEST.defaultBlockState().setValue(BlockBeehive.FACING, WORLDGEN_FACING));
        var02.getBlockEntity(var7.get(), TileEntityTypes.BEEHIVE).ifPresent(var1 -> {
            int var2 = 2 + var2.nextInt(2);
            for (int var3 = 0; var3 < var2; ++var3) {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.putString("id", IRegistry.ENTITY_TYPE.getKey(EntityTypes.BEE).toString());
                var1.storeBee(var4, var2.nextInt(599), false);
            }
        });
    }
}

