/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenWoodlandMansionPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class WorldGenWoodlandMansion
extends StructureGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenWoodlandMansion(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0, WorldGenWoodlandMansion::pieceGeneratorSupplier, WorldGenWoodlandMansion::afterPlace);
    }

    private static Optional<PieceGenerator<WorldGenFeatureEmptyConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.a<WorldGenFeatureEmptyConfiguration> var0) {
        SeededRandom var1 = new SeededRandom(new LegacyRandomSource(0L));
        var1.setLargeFeatureSeed(var0.seed(), var0.chunkPos().x, var0.chunkPos().z);
        EnumBlockRotation var2 = EnumBlockRotation.getRandom(var1);
        int var32 = 5;
        int var42 = 5;
        if (var2 == EnumBlockRotation.CLOCKWISE_90) {
            var32 = -5;
        } else if (var2 == EnumBlockRotation.CLOCKWISE_180) {
            var32 = -5;
            var42 = -5;
        } else if (var2 == EnumBlockRotation.COUNTERCLOCKWISE_90) {
            var42 = -5;
        }
        int var5 = var0.chunkPos().getBlockX(7);
        int var6 = var0.chunkPos().getBlockZ(7);
        int[] var7 = var0.getCornerHeights(var5, var32, var6, var42);
        int var8 = Math.min(Math.min(var7[0], var7[1]), Math.min(var7[2], var7[3]));
        if (var8 < 60) {
            return Optional.empty();
        }
        if (!var0.validBiome().test(var0.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(var5), QuartPos.fromBlock(var7[0]), QuartPos.fromBlock(var6)))) {
            return Optional.empty();
        }
        BlockPosition var9 = new BlockPosition(var0.chunkPos().getMiddleBlockX(), var8 + 1, var0.chunkPos().getMiddleBlockZ());
        return Optional.of((var3, var4) -> {
            LinkedList var5 = Lists.newLinkedList();
            WorldGenWoodlandMansionPieces.generateMansion(var4.structureManager(), var9, var2, var5, var1);
            var5.forEach(var3::addPiece);
        });
    }

    private static void afterPlace(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, PiecesContainer var6) {
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        int var8 = var0.getMinBuildHeight();
        StructureBoundingBox var9 = var6.calculateBoundingBox();
        int var10 = var9.minY();
        for (int var11 = var4.minX(); var11 <= var4.maxX(); ++var11) {
            block1: for (int var12 = var4.minZ(); var12 <= var4.maxZ(); ++var12) {
                var7.set(var11, var10, var12);
                if (var0.isEmptyBlock(var7) || !var9.isInside(var7) || !var6.isInsidePiece(var7)) continue;
                for (int var13 = var10 - 1; var13 > var8; --var13) {
                    var7.setY(var13);
                    if (!var0.isEmptyBlock(var7) && !var0.getBlockState(var7).getMaterial().isLiquid()) continue block1;
                    var0.setBlock(var7, Blocks.COBBLESTONE.defaultBlockState(), 2);
                }
            }
        }
    }
}

