/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenFossils
extends WorldGenerator<FossilFeatureConfiguration> {
    public WorldGenFossils(Codec<FossilFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<FossilFeatureConfiguration> var0) {
        int var16;
        Random var1 = var0.random();
        GeneratorAccessSeed var2 = var0.level();
        BlockPosition var3 = var0.origin();
        EnumBlockRotation var4 = EnumBlockRotation.getRandom(var1);
        FossilFeatureConfiguration var5 = var0.config();
        int var6 = var1.nextInt(var5.fossilStructures.size());
        DefinedStructureManager var7 = var2.getLevel().getServer().getStructureManager();
        DefinedStructure var8 = var7.getOrCreate(var5.fossilStructures.get(var6));
        DefinedStructure var9 = var7.getOrCreate(var5.overlayStructures.get(var6));
        ChunkCoordIntPair var10 = new ChunkCoordIntPair(var3);
        StructureBoundingBox var11 = new StructureBoundingBox(var10.getMinBlockX() - 16, var2.getMinBuildHeight(), var10.getMinBlockZ() - 16, var10.getMaxBlockX() + 16, var2.getMaxBuildHeight(), var10.getMaxBlockZ() + 16);
        DefinedStructureInfo var12 = new DefinedStructureInfo().setRotation(var4).setBoundingBox(var11).setRandom(var1);
        BaseBlockPosition var13 = var8.getSize(var4);
        BlockPosition var14 = var3.offset(-var13.getX() / 2, 0, -var13.getZ() / 2);
        int var15 = var3.getY();
        for (var16 = 0; var16 < var13.getX(); ++var16) {
            for (int var17 = 0; var17 < var13.getZ(); ++var17) {
                var15 = Math.min(var15, var2.getHeight(HeightMap.Type.OCEAN_FLOOR_WG, var14.getX() + var16, var14.getZ() + var17));
            }
        }
        var16 = Math.max(var15 - 15 - var1.nextInt(10), var2.getMinBuildHeight() + 10);
        BlockPosition var17 = var8.getZeroPositionWithTransform(var14.atY(var16), EnumBlockMirror.NONE, var4);
        if (WorldGenFossils.countEmptyCorners(var2, var8.getBoundingBox(var12, var17)) > var5.maxEmptyCornersAllowed) {
            return false;
        }
        var12.clearProcessors();
        var5.fossilProcessors.value().list().forEach(var12::addProcessor);
        var8.placeInWorld(var2, var17, var17, var12, var1, 4);
        var12.clearProcessors();
        var5.overlayProcessors.value().list().forEach(var12::addProcessor);
        var9.placeInWorld(var2, var17, var17, var12, var1, 4);
        return true;
    }

    private static int countEmptyCorners(GeneratorAccessSeed var0, StructureBoundingBox var1) {
        MutableInt var22 = new MutableInt(0);
        var1.forAllCorners(var2 -> {
            IBlockData var3 = var0.getBlockState((BlockPosition)var2);
            if (var3.isAir() || var3.is(Blocks.LAVA) || var3.is(Blocks.WATER)) {
                var22.add(1);
            }
        });
        return var22.getValue();
    }
}

