/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureRuinedPortalPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;

public class WorldGenFeatureRuinedPortal
extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration> {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float PROBABILITY_OF_GIANT_PORTAL = 0.05f;
    private static final float PROBABILITY_OF_AIR_POCKET = 0.5f;
    private static final float PROBABILITY_OF_UNDERGROUND = 0.5f;
    private static final float UNDERWATER_MOSSINESS = 0.8f;
    private static final float JUNGLE_MOSSINESS = 0.8f;
    private static final float SWAMP_MOSSINESS = 0.5f;
    private static final int MIN_Y_INDEX = 15;

    public WorldGenFeatureRuinedPortal(Codec<WorldGenFeatureRuinedPortalConfiguration> var0) {
        super(var0, WorldGenFeatureRuinedPortal::pieceGeneratorSupplier);
    }

    private static Optional<PieceGenerator<WorldGenFeatureRuinedPortalConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.a<WorldGenFeatureRuinedPortalConfiguration> var0) {
        WorldGenFeatureRuinedPortalPieces.Position var1;
        WorldGenFeatureRuinedPortalPieces.a var2 = new WorldGenFeatureRuinedPortalPieces.a();
        WorldGenFeatureRuinedPortalConfiguration var3 = var0.config();
        SeededRandom var4 = new SeededRandom(new LegacyRandomSource(0L));
        var4.setLargeFeatureSeed(var0.seed(), var0.chunkPos().x, var0.chunkPos().z);
        if (var3.portalType == Type.DESERT) {
            var1 = WorldGenFeatureRuinedPortalPieces.Position.PARTLY_BURIED;
            var2.airPocket = false;
            var2.mossiness = 0.0f;
        } else if (var3.portalType == Type.JUNGLE) {
            var1 = WorldGenFeatureRuinedPortalPieces.Position.ON_LAND_SURFACE;
            var2.airPocket = var4.nextFloat() < 0.5f;
            var2.mossiness = 0.8f;
            var2.overgrown = true;
            var2.vines = true;
        } else if (var3.portalType == Type.SWAMP) {
            var1 = WorldGenFeatureRuinedPortalPieces.Position.ON_OCEAN_FLOOR;
            var2.airPocket = false;
            var2.mossiness = 0.5f;
            var2.vines = true;
        } else if (var3.portalType == Type.MOUNTAIN) {
            var5 = var4.nextFloat() < 0.5f;
            var1 = var5 ? WorldGenFeatureRuinedPortalPieces.Position.IN_MOUNTAIN : WorldGenFeatureRuinedPortalPieces.Position.ON_LAND_SURFACE;
            var2.airPocket = var5 || var4.nextFloat() < 0.5f;
        } else if (var3.portalType == Type.OCEAN) {
            var1 = WorldGenFeatureRuinedPortalPieces.Position.ON_OCEAN_FLOOR;
            var2.airPocket = false;
            var2.mossiness = 0.8f;
        } else if (var3.portalType == Type.NETHER) {
            var1 = WorldGenFeatureRuinedPortalPieces.Position.IN_NETHER;
            var2.airPocket = var4.nextFloat() < 0.5f;
            var2.mossiness = 0.0f;
            var2.replaceWithBlackstone = true;
        } else {
            var5 = var4.nextFloat() < 0.5f;
            var1 = var5 ? WorldGenFeatureRuinedPortalPieces.Position.UNDERGROUND : WorldGenFeatureRuinedPortalPieces.Position.ON_LAND_SURFACE;
            var2.airPocket = var5 || var4.nextFloat() < 0.5f;
        }
        MinecraftKey var5 = var4.nextFloat() < 0.05f ? new MinecraftKey(STRUCTURE_LOCATION_GIANT_PORTALS[var4.nextInt(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : new MinecraftKey(STRUCTURE_LOCATION_PORTALS[var4.nextInt(STRUCTURE_LOCATION_PORTALS.length)]);
        DefinedStructure var6 = var0.structureManager().getOrCreate(var5);
        EnumBlockRotation var7 = SystemUtils.getRandom(EnumBlockRotation.values(), (Random)var4);
        EnumBlockMirror var8 = var4.nextFloat() < 0.5f ? EnumBlockMirror.NONE : EnumBlockMirror.FRONT_BACK;
        BlockPosition var9 = new BlockPosition(var6.getSize().getX() / 2, 0, var6.getSize().getZ() / 2);
        BlockPosition var102 = var0.chunkPos().getWorldPosition();
        StructureBoundingBox var112 = var6.getBoundingBox(var102, var7, var9, var8);
        BlockPosition var12 = var112.getCenter();
        int var13 = var0.chunkGenerator().getBaseHeight(var12.getX(), var12.getZ(), WorldGenFeatureRuinedPortalPieces.getHeightMapType(var1), var0.heightAccessor()) - 1;
        int var14 = WorldGenFeatureRuinedPortal.findSuitableY(var4, var0.chunkGenerator(), var1, var2.airPocket, var13, var112.getYSpan(), var112, var0.heightAccessor());
        BlockPosition var15 = new BlockPosition(var102.getX(), var14, var102.getZ());
        if (!var0.validBiome().test(var0.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(var15.getX()), QuartPos.fromBlock(var15.getY()), QuartPos.fromBlock(var15.getZ())))) {
            return Optional.empty();
        }
        return Optional.of((var10, var11) -> {
            if (var0.portalType == Type.MOUNTAIN || var0.portalType == Type.OCEAN || var0.portalType == Type.STANDARD) {
                var1.cold = WorldGenFeatureRuinedPortal.isCold(var15, var0.chunkGenerator().getNoiseBiome(QuartPos.fromBlock(var15.getX()), QuartPos.fromBlock(var15.getY()), QuartPos.fromBlock(var15.getZ())));
            }
            var10.addPiece(new WorldGenFeatureRuinedPortalPieces(var11.structureManager(), var15, var1, var2, var5, var6, var7, var8, var9));
        });
    }

    private static boolean isCold(BlockPosition var0, Holder<BiomeBase> var1) {
        return var1.value().coldEnoughToSnow(var0);
    }

    private static int findSuitableY(Random var0, ChunkGenerator var1, WorldGenFeatureRuinedPortalPieces.Position var22, boolean var3, int var4, int var5, StructureBoundingBox var6, LevelHeightAccessor var7) {
        int var13;
        int var9 = var7.getMinBuildHeight() + 15;
        if (var22 == WorldGenFeatureRuinedPortalPieces.Position.IN_NETHER) {
            var8 = var3 ? MathHelper.randomBetweenInclusive(var0, 32, 100) : (var0.nextFloat() < 0.5f ? MathHelper.randomBetweenInclusive(var0, 27, 29) : MathHelper.randomBetweenInclusive(var0, 29, 100));
        } else if (var22 == WorldGenFeatureRuinedPortalPieces.Position.IN_MOUNTAIN) {
            var10 = var4 - var5;
            var8 = WorldGenFeatureRuinedPortal.getRandomWithinInterval(var0, 70, var10);
        } else if (var22 == WorldGenFeatureRuinedPortalPieces.Position.UNDERGROUND) {
            var10 = var4 - var5;
            var8 = WorldGenFeatureRuinedPortal.getRandomWithinInterval(var0, var9, var10);
        } else {
            var8 = var22 == WorldGenFeatureRuinedPortalPieces.Position.PARTLY_BURIED ? var4 - var5 + MathHelper.randomBetweenInclusive(var0, 2, 8) : var4;
        }
        ImmutableList var10 = ImmutableList.of((Object)new BlockPosition(var6.minX(), 0, var6.minZ()), (Object)new BlockPosition(var6.maxX(), 0, var6.minZ()), (Object)new BlockPosition(var6.minX(), 0, var6.maxZ()), (Object)new BlockPosition(var6.maxX(), 0, var6.maxZ()));
        List var11 = var10.stream().map(var2 -> var1.getBaseColumn(var2.getX(), var2.getZ(), var7)).collect(Collectors.toList());
        HeightMap.Type var12 = var22 == WorldGenFeatureRuinedPortalPieces.Position.ON_OCEAN_FLOOR ? HeightMap.Type.OCEAN_FLOOR_WG : HeightMap.Type.WORLD_SURFACE_WG;
        block0: for (var13 = var8; var13 > var9; --var13) {
            int var14 = 0;
            for (BlockColumn var16 : var11) {
                IBlockData var17 = var16.getBlock(var13);
                if (!var12.isOpaque().test(var17) || ++var14 != 3) continue;
                break block0;
            }
        }
        return var13;
    }

    private static int getRandomWithinInterval(Random var0, int var1, int var2) {
        if (var1 < var2) {
            return MathHelper.randomBetweenInclusive(var0, var1, var2);
        }
        return var2;
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type STANDARD = new Type("standard");
        public static final /* enum */ Type DESERT = new Type("desert");
        public static final /* enum */ Type JUNGLE = new Type("jungle");
        public static final /* enum */ Type SWAMP = new Type("swamp");
        public static final /* enum */ Type MOUNTAIN = new Type("mountain");
        public static final /* enum */ Type OCEAN = new Type("ocean");
        public static final /* enum */ Type NETHER = new Type("nether");
        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;
        private final String name;
        private static final /* synthetic */ Type[] k;

        public static Type[] values() {
            return (Type[])k.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        public static Type byName(String var0) {
            return BY_NAME.get(var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{STANDARD, DESERT, JUNGLE, SWAMP, MOUNTAIN, OCEAN, NETHER};
        }

        static {
            k = Type.b();
            CODEC = INamable.fromEnum(Type::values, Type::byName);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, var0 -> var0));
        }
    }
}

