/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockPileConfiguration;

public class WorldGenFeatureBlockPile
extends WorldGenerator<WorldGenFeatureBlockPileConfiguration> {
    public WorldGenFeatureBlockPile(Codec<WorldGenFeatureBlockPileConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureBlockPileConfiguration> var0) {
        BlockPosition var1 = var0.origin();
        GeneratorAccessSeed var2 = var0.level();
        Random var3 = var0.random();
        WorldGenFeatureBlockPileConfiguration var4 = var0.config();
        if (var1.getY() < var2.getMinBuildHeight() + 5) {
            return false;
        }
        int var5 = 2 + var3.nextInt(2);
        int var6 = 2 + var3.nextInt(2);
        for (BlockPosition var8 : BlockPosition.betweenClosed(var1.offset(-var5, 0, -var6), var1.offset(var5, 1, var6))) {
            int var10;
            int var9 = var1.getX() - var8.getX();
            if ((float)(var9 * var9 + (var10 = var1.getZ() - var8.getZ()) * var10) <= var3.nextFloat() * 10.0f - var3.nextFloat() * 6.0f) {
                this.tryPlaceBlock(var2, var8, var3, var4);
                continue;
            }
            if (!((double)var3.nextFloat() < 0.031)) continue;
            this.tryPlaceBlock(var2, var8, var3, var4);
        }
        return true;
    }

    private boolean mayPlaceOn(GeneratorAccess var0, BlockPosition var1, Random var2) {
        BlockPosition var3 = var1.below();
        IBlockData var4 = var0.getBlockState(var3);
        if (var4.is(Blocks.DIRT_PATH)) {
            return var2.nextBoolean();
        }
        return var4.isFaceSturdy(var0, var3, EnumDirection.UP);
    }

    private void tryPlaceBlock(GeneratorAccess var0, BlockPosition var1, Random var2, WorldGenFeatureBlockPileConfiguration var3) {
        if (var0.isEmptyBlock(var1) && this.mayPlaceOn(var0, var1, var2)) {
            var0.setBlock(var1, var3.stateProvider.getState(var2, var1), 4);
        }
    }
}

