/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenBuriedTreasure;
import net.minecraft.world.level.levelgen.feature.WorldGenEndCity;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBastionRemnant;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureDesertPyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIgloo;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureJunglePyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeaturePillagerOutpost;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRuinedPortal;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureShipwreck;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSwampHut;
import net.minecraft.world.level.levelgen.feature.WorldGenMineshaft;
import net.minecraft.world.level.levelgen.feature.WorldGenMonument;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.levelgen.feature.WorldGenStronghold;
import net.minecraft.world.level.levelgen.feature.WorldGenVillage;
import net.minecraft.world.level.levelgen.feature.WorldGenWoodlandMansion;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureShipwreckConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenMineshaftConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureNetherFossil;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureOceanRuin;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.slf4j.Logger;

public class StructureGenerator<C extends WorldGenFeatureConfiguration> {
    private static final Map<StructureGenerator<?>, WorldGenStage.Decoration> STEP = Maps.newHashMap();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> PILLAGER_OUTPOST = StructureGenerator.register("pillager_outpost", new WorldGenFeaturePillagerOutpost(WorldGenFeatureVillageConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenMineshaftConfiguration> MINESHAFT = StructureGenerator.register("mineshaft", new WorldGenMineshaft(WorldGenMineshaftConfiguration.CODEC), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> WOODLAND_MANSION = StructureGenerator.register("mansion", new WorldGenWoodlandMansion(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> JUNGLE_TEMPLE = StructureGenerator.register("jungle_pyramid", new WorldGenFeatureJunglePyramid(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> DESERT_PYRAMID = StructureGenerator.register("desert_pyramid", new WorldGenFeatureDesertPyramid(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> IGLOO = StructureGenerator.register("igloo", new WorldGenFeatureIgloo(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureRuinedPortalConfiguration> RUINED_PORTAL = StructureGenerator.register("ruined_portal", new WorldGenFeatureRuinedPortal(WorldGenFeatureRuinedPortalConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureShipwreckConfiguration> SHIPWRECK = StructureGenerator.register("shipwreck", new WorldGenFeatureShipwreck(WorldGenFeatureShipwreckConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> SWAMP_HUT = StructureGenerator.register("swamp_hut", new WorldGenFeatureSwampHut(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> STRONGHOLD = StructureGenerator.register("stronghold", new WorldGenStronghold(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.STRONGHOLDS);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> OCEAN_MONUMENT = StructureGenerator.register("monument", new WorldGenMonument(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureOceanRuinConfiguration> OCEAN_RUIN = StructureGenerator.register("ocean_ruin", new WorldGenFeatureOceanRuin(WorldGenFeatureOceanRuinConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> FORTRESS = StructureGenerator.register("fortress", new WorldGenNether(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.UNDERGROUND_DECORATION);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> END_CITY = StructureGenerator.register("endcity", new WorldGenEndCity(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureConfigurationChance> BURIED_TREASURE = StructureGenerator.register("buried_treasure", new WorldGenBuriedTreasure(WorldGenFeatureConfigurationChance.CODEC), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> VILLAGE = StructureGenerator.register("village", new WorldGenVillage(WorldGenFeatureVillageConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<RangeConfiguration> NETHER_FOSSIL = StructureGenerator.register("nether_fossil", new WorldGenFeatureNetherFossil(RangeConfiguration.CODEC), WorldGenStage.Decoration.UNDERGROUND_DECORATION);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> BASTION_REMNANT = StructureGenerator.register("bastion_remnant", new WorldGenFeatureBastionRemnant(WorldGenFeatureVillageConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final int MAX_STRUCTURE_RANGE = 8;
    private final Codec<StructureFeature<C, StructureGenerator<C>>> configuredStructureCodec = RecordCodecBuilder.create(var12 -> var12.group((App)var0.fieldOf("config").forGetter(var0 -> var0.config), (App)RegistryCodecs.homogeneousList(IRegistry.BIOME_REGISTRY).fieldOf("biomes").forGetter(StructureFeature::biomes), (App)Codec.BOOL.optionalFieldOf("adapt_noise", (Object)false).forGetter(var0 -> var0.adaptNoise), (App)Codec.simpleMap(EnumCreatureType.CODEC, StructureSpawnOverride.CODEC, (Keyable)INamable.keys(EnumCreatureType.values())).fieldOf("spawn_overrides").forGetter(var0 -> var0.spawnOverrides)).apply((Applicative)var12, (var0, var1, var2, var3) -> new StructureFeature<WorldGenFeatureConfiguration, StructureGenerator>(this, (WorldGenFeatureConfiguration)var0, (HolderSet<BiomeBase>)var1, (boolean)var2, (Map<EnumCreatureType, StructureSpawnOverride>)var3)));
    private final PieceGeneratorSupplier<C> pieceGenerator;
    private final PostPlacementProcessor postPlacementProcessor;

    private static <F extends StructureGenerator<?>> F register(String var0, F var1, WorldGenStage.Decoration var2) {
        STEP.put(var1, var2);
        return (F)IRegistry.register(IRegistry.STRUCTURE_FEATURE, var0, var1);
    }

    public StructureGenerator(Codec<C> var0, PieceGeneratorSupplier<C> var1) {
        this(var0, var1, PostPlacementProcessor.NONE);
    }

    public StructureGenerator(Codec<C> var0, PieceGeneratorSupplier<C> var1, PostPlacementProcessor var2) {
        this.pieceGenerator = var1;
        this.postPlacementProcessor = var2;
    }

    public WorldGenStage.Decoration step() {
        return STEP.get(this);
    }

    public static void bootstrap() {
    }

    @Nullable
    public static StructureStart loadStaticStart(StructurePieceSerializationContext var0, NBTTagCompound var1, long var2) {
        String var4 = var1.getString("id");
        if ("INVALID".equals(var4)) {
            return StructureStart.INVALID_START;
        }
        IRegistry<StructureFeature<?, ?>> var5 = var0.registryAccess().registryOrThrow(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        StructureFeature<?, ?> var6 = var5.get(new MinecraftKey(var4));
        if (var6 == null) {
            LOGGER.error("Unknown feature id: {}", (Object)var4);
            return null;
        }
        ChunkCoordIntPair var7 = new ChunkCoordIntPair(var1.getInt("ChunkX"), var1.getInt("ChunkZ"));
        int var8 = var1.getInt("references");
        NBTTagList var9 = var1.getList("Children", 10);
        try {
            PiecesContainer var10 = PiecesContainer.load(var9, var0);
            if (var6.feature == OCEAN_MONUMENT) {
                var10 = WorldGenMonument.regeneratePiecesAfterLoad(var7, var2, var10);
            }
            return new StructureStart(var6, var7, var8, var10);
        }
        catch (Exception var10) {
            LOGGER.error("Failed Start with id {}", (Object)var4, (Object)var10);
            return null;
        }
    }

    public Codec<StructureFeature<C, StructureGenerator<C>>> configuredStructureCodec() {
        return this.configuredStructureCodec;
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> configured(C var0, TagKey<BiomeBase> var1) {
        return this.configured(var0, var1, false);
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> configured(C var0, TagKey<BiomeBase> var1, boolean var2) {
        return new StructureFeature<C, StructureGenerator>(this, var0, RegistryGeneration.BIOME.getOrCreateTag(var1), var2, Map.of());
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> configured(C var0, TagKey<BiomeBase> var1, Map<EnumCreatureType, StructureSpawnOverride> var2) {
        return new StructureFeature<C, StructureGenerator>(this, var0, RegistryGeneration.BIOME.getOrCreateTag(var1), false, var2);
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> configured(C var0, TagKey<BiomeBase> var1, boolean var2, Map<EnumCreatureType, StructureSpawnOverride> var3) {
        return new StructureFeature<C, StructureGenerator>(this, var0, RegistryGeneration.BIOME.getOrCreateTag(var1), var2, var3);
    }

    public static BlockPosition getLocatePos(RandomSpreadStructurePlacement var0, ChunkCoordIntPair var1) {
        return new BlockPosition(var1.getMinBlockX(), 0, var1.getMinBlockZ()).offset(var0.locateOffset());
    }

    public boolean canGenerate(IRegistryCustom var0, ChunkGenerator var1, WorldChunkManager var2, DefinedStructureManager var3, long var4, ChunkCoordIntPair var6, C var7, LevelHeightAccessor var8, Predicate<Holder<BiomeBase>> var9) {
        return this.pieceGenerator.createGenerator(new PieceGeneratorSupplier.a<C>(var1, var2, var4, var6, var7, var8, var9, var3, var0)).isPresent();
    }

    public PieceGeneratorSupplier<C> pieceGeneratorSupplier() {
        return this.pieceGenerator;
    }

    public PostPlacementProcessor getPostPlacementProcessor() {
        return this.postPlacementProcessor;
    }
}

