/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

public class StructureFeature<FC extends WorldGenFeatureConfiguration, F extends StructureGenerator<FC>> {
    public static final Codec<StructureFeature<?, ?>> DIRECT_CODEC = IRegistry.STRUCTURE_FEATURE.byNameCodec().dispatch(var0 -> var0.feature, StructureGenerator::configuredStructureCodec);
    public static final Codec<Holder<StructureFeature<?, ?>>> CODEC = RegistryFileCodec.create(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY, DIRECT_CODEC);
    public static final Codec<HolderSet<StructureFeature<?, ?>>> LIST_CODEC = RegistryCodecs.homogeneousList(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY, DIRECT_CODEC);
    public final F feature;
    public final FC config;
    public final HolderSet<BiomeBase> biomes;
    public final Map<EnumCreatureType, StructureSpawnOverride> spawnOverrides;
    public final boolean adaptNoise;

    public StructureFeature(F var0, FC var1, HolderSet<BiomeBase> var2, boolean var3, Map<EnumCreatureType, StructureSpawnOverride> var4) {
        this.feature = var0;
        this.config = var1;
        this.biomes = var2;
        this.adaptNoise = var3;
        this.spawnOverrides = var4;
    }

    public StructureStart generate(IRegistryCustom var0, ChunkGenerator var1, WorldChunkManager var2, DefinedStructureManager var3, long var4, ChunkCoordIntPair var6, int var7, LevelHeightAccessor var8, Predicate<Holder<BiomeBase>> var9) {
        Optional var10 = ((StructureGenerator)this.feature).pieceGeneratorSupplier().createGenerator(new PieceGeneratorSupplier.a<FC>(var1, var2, var4, var6, this.config, var8, var9, var3, var0));
        if (var10.isPresent()) {
            StructurePiecesBuilder var11 = new StructurePiecesBuilder();
            SeededRandom var12 = new SeededRandom(new LegacyRandomSource(0L));
            var12.setLargeFeatureSeed(var4, var6.x, var6.z);
            var10.get().generatePieces(var11, new PieceGenerator.a<FC>(this.config, var1, var3, var6, var8, var12, var4));
            StructureStart var13 = new StructureStart(this, var6, var7, var11.build());
            if (var13.isValid()) {
                return var13;
            }
        }
        return StructureStart.INVALID_START;
    }

    public HolderSet<BiomeBase> biomes() {
        return this.biomes;
    }

    public StructureBoundingBox adjustBoundingBox(StructureBoundingBox var0) {
        if (this.adaptNoise) {
            return var0.inflatedBy(12);
        }
        return var0;
    }
}

