/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;

public class PointedDripstoneFeature
extends WorldGenerator<PointedDripstoneConfiguration> {
    public PointedDripstoneFeature(Codec<PointedDripstoneConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<PointedDripstoneConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        Random var3 = var0.random();
        PointedDripstoneConfiguration var4 = var0.config();
        Optional<EnumDirection> var5 = PointedDripstoneFeature.getTipDirection(var1, var2, var3);
        if (var5.isEmpty()) {
            return false;
        }
        BlockPosition var6 = var2.relative(var5.get().getOpposite());
        PointedDripstoneFeature.createPatchOfDripstoneBlocks(var1, var3, var6, var4);
        int var7 = var3.nextFloat() < var4.chanceOfTallerDripstone && DripstoneUtils.isEmptyOrWater(var1.getBlockState(var2.relative(var5.get()))) ? 2 : 1;
        DripstoneUtils.growPointedDripstone(var1, var2, var5.get(), var7, false);
        return true;
    }

    private static Optional<EnumDirection> getTipDirection(GeneratorAccess var0, BlockPosition var1, Random var2) {
        boolean var3 = DripstoneUtils.isDripstoneBase(var0.getBlockState(var1.above()));
        boolean var4 = DripstoneUtils.isDripstoneBase(var0.getBlockState(var1.below()));
        if (var3 && var4) {
            return Optional.of(var2.nextBoolean() ? EnumDirection.DOWN : EnumDirection.UP);
        }
        if (var3) {
            return Optional.of(EnumDirection.DOWN);
        }
        if (var4) {
            return Optional.of(EnumDirection.UP);
        }
        return Optional.empty();
    }

    private static void createPatchOfDripstoneBlocks(GeneratorAccess var0, Random var1, BlockPosition var2, PointedDripstoneConfiguration var3) {
        DripstoneUtils.placeDripstoneBlockIfPossible(var0, var2);
        for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (var1.nextFloat() > var3.chanceOfDirectionalSpread) continue;
            BlockPosition var6 = var2.relative(var5);
            DripstoneUtils.placeDripstoneBlockIfPossible(var0, var6);
            if (var1.nextFloat() > var3.chanceOfSpreadRadius2) continue;
            BlockPosition var7 = var6.relative(EnumDirection.getRandom(var1));
            DripstoneUtils.placeDripstoneBlockIfPossible(var0, var7);
            if (var1.nextFloat() > var3.chanceOfSpreadRadius3) continue;
            BlockPosition var8 = var7.relative(EnumDirection.getRandom(var1));
            DripstoneUtils.placeDripstoneBlockIfPossible(var0, var8);
        }
    }
}

