/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.phys.Vec3D;

public class LargeDripstoneFeature
extends WorldGenerator<LargeDripstoneConfiguration> {
    public LargeDripstoneFeature(Codec<LargeDripstoneConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<LargeDripstoneConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        LargeDripstoneConfiguration var3 = var0.config();
        Random var4 = var0.random();
        if (!DripstoneUtils.isEmptyOrWater(var1, var2)) {
            return false;
        }
        Optional<Column> var5 = Column.scan(var1, var2, var3.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (!var5.isPresent() || !(var5.get() instanceof Column.b)) {
            return false;
        }
        Column.b var6 = (Column.b)var5.get();
        if (var6.height() < 4) {
            return false;
        }
        int var7 = (int)((float)var6.height() * var3.maxColumnRadiusToCaveHeightRatio);
        int var8 = MathHelper.clamp(var7, var3.columnRadius.getMinValue(), var3.columnRadius.getMaxValue());
        int var9 = MathHelper.randomBetweenInclusive(var4, var3.columnRadius.getMinValue(), var8);
        a var10 = LargeDripstoneFeature.makeDripstone(var2.atY(var6.ceiling() - 1), false, var4, var9, var3.stalactiteBluntness, var3.heightScale);
        a var11 = LargeDripstoneFeature.makeDripstone(var2.atY(var6.floor() + 1), true, var4, var9, var3.stalagmiteBluntness, var3.heightScale);
        b var12 = var10.isSuitableForWind(var3) && var11.isSuitableForWind(var3) ? new b(var2.getY(), var4, var3.windSpeed) : b.noWind();
        boolean var13 = var10.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(var1, var12);
        boolean var14 = var11.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(var1, var12);
        if (var13) {
            var10.placeBlocks(var1, var4, var12);
        }
        if (var14) {
            var11.placeBlocks(var1, var4, var12);
        }
        return true;
    }

    private static a makeDripstone(BlockPosition var0, boolean var1, Random var2, int var3, FloatProvider var4, FloatProvider var5) {
        return new a(var0, var1, var3, var4.sample(var2), var5.sample(var2));
    }

    private void placeDebugMarkers(GeneratorAccessSeed var0, BlockPosition var1, Column.b var2, b var3) {
        var0.setBlock(var3.offset(var1.atY(var2.ceiling() - 1)), Blocks.DIAMOND_BLOCK.defaultBlockState(), 2);
        var0.setBlock(var3.offset(var1.atY(var2.floor() + 1)), Blocks.GOLD_BLOCK.defaultBlockState(), 2);
        BlockPosition.MutableBlockPosition var4 = var1.atY(var2.floor() + 2).mutable();
        while (var4.getY() < var2.ceiling() - 1) {
            BlockPosition var5 = var3.offset(var4);
            if (DripstoneUtils.isEmptyOrWater(var0, var5) || var0.getBlockState(var5).is(Blocks.DRIPSTONE_BLOCK)) {
                var0.setBlock(var5, Blocks.CREEPER_HEAD.defaultBlockState(), 2);
            }
            var4.move(EnumDirection.UP);
        }
    }

    static final class a {
        private BlockPosition root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        a(BlockPosition var0, boolean var1, int var2, double var3, double var5) {
            this.root = var0;
            this.pointingUp = var1;
            this.radius = var2;
            this.bluntness = var3;
            this.scale = var5;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            if (this.pointingUp) {
                return this.root.getY();
            }
            return this.root.getY() - this.getHeight();
        }

        private int getMaxY() {
            if (!this.pointingUp) {
                return this.root.getY();
            }
            return this.root.getY() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(GeneratorAccessSeed var0, b var1) {
            while (this.radius > 1) {
                BlockPosition.MutableBlockPosition var2 = this.root.mutable();
                int var3 = Math.min(10, this.getHeight());
                for (int var4 = 0; var4 < var3; ++var4) {
                    if (var0.getBlockState(var2).is(Blocks.LAVA)) {
                        return false;
                    }
                    if (DripstoneUtils.isCircleMostlyEmbeddedInStone(var0, var1.offset(var2), this.radius)) {
                        this.root = var2;
                        return true;
                    }
                    var2.move(this.pointingUp ? EnumDirection.DOWN : EnumDirection.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float var0) {
            return (int)DripstoneUtils.getDripstoneHeight(var0, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(GeneratorAccessSeed var0, Random var1, b var2) {
            for (int var3 = -this.radius; var3 <= this.radius; ++var3) {
                block1: for (int var4 = -this.radius; var4 <= this.radius; ++var4) {
                    int var6;
                    float var5 = MathHelper.sqrt(var3 * var3 + var4 * var4);
                    if (var5 > (float)this.radius || (var6 = this.getHeightAtRadius(var5)) <= 0) continue;
                    if ((double)var1.nextFloat() < 0.2) {
                        var6 = (int)((float)var6 * MathHelper.randomBetween(var1, 0.8f, 1.0f));
                    }
                    BlockPosition.MutableBlockPosition var7 = this.root.offset(var3, 0, var4).mutable();
                    boolean var8 = false;
                    int var9 = this.pointingUp ? var0.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var7.getX(), var7.getZ()) : Integer.MAX_VALUE;
                    for (int var10 = 0; var10 < var6 && var7.getY() < var9; ++var10) {
                        BlockPosition var11 = var2.offset(var7);
                        if (DripstoneUtils.isEmptyOrWaterOrLava(var0, var11)) {
                            var8 = true;
                            Block var12 = Blocks.DRIPSTONE_BLOCK;
                            var0.setBlock(var11, var12.defaultBlockState(), 2);
                        } else if (var8 && var0.getBlockState(var11).is(TagsBlock.BASE_STONE_OVERWORLD)) continue block1;
                        var7.move(this.pointingUp ? EnumDirection.UP : EnumDirection.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargeDripstoneConfiguration var0) {
            return this.radius >= var0.minRadiusForWind && this.bluntness >= (double)var0.minBluntnessForWind;
        }
    }

    static final class b {
        private final int originY;
        @Nullable
        private final Vec3D windSpeed;

        b(int var0, Random var1, FloatProvider var2) {
            this.originY = var0;
            float var3 = var2.sample(var1);
            float var4 = MathHelper.randomBetween(var1, 0.0f, (float)Math.PI);
            this.windSpeed = new Vec3D(MathHelper.cos(var4) * var3, 0.0, MathHelper.sin(var4) * var3);
        }

        private b() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static b noWind() {
            return new b();
        }

        BlockPosition offset(BlockPosition var0) {
            if (this.windSpeed == null) {
                return var0;
            }
            int var1 = this.originY - var0.getY();
            Vec3D var2 = this.windSpeed.scale(var1);
            return var0.offset(var2.x, 0.0, var2.z);
        }
    }
}

