/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.GlowLichenConfiguration;

public class GlowLichenFeature
extends WorldGenerator<GlowLichenConfiguration> {
    public GlowLichenFeature(Codec<GlowLichenConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<GlowLichenConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        Random var3 = var0.random();
        GlowLichenConfiguration var4 = var0.config();
        if (!GlowLichenFeature.isAirOrWater(var1.getBlockState(var2))) {
            return false;
        }
        List<EnumDirection> var5 = GlowLichenFeature.getShuffledDirections(var4, var3);
        if (GlowLichenFeature.placeGlowLichenIfPossible(var1, var2, var1.getBlockState(var2), var4, var3, var5)) {
            return true;
        }
        BlockPosition.MutableBlockPosition var6 = var2.mutable();
        block0: for (EnumDirection var8 : var5) {
            var6.set(var2);
            List<EnumDirection> var9 = GlowLichenFeature.getShuffledDirectionsExcept(var4, var3, var8.getOpposite());
            for (int var10 = 0; var10 < var4.searchRange; ++var10) {
                var6.setWithOffset((BaseBlockPosition)var2, var8);
                IBlockData var11 = var1.getBlockState(var6);
                if (!GlowLichenFeature.isAirOrWater(var11) && !var11.is(Blocks.GLOW_LICHEN)) continue block0;
                if (!GlowLichenFeature.placeGlowLichenIfPossible(var1, var6, var11, var4, var3, var9)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean placeGlowLichenIfPossible(GeneratorAccessSeed var0, BlockPosition var1, IBlockData var2, GlowLichenConfiguration var3, Random var4, List<EnumDirection> var5) {
        BlockPosition.MutableBlockPosition var6 = var1.mutable();
        for (EnumDirection var8 : var5) {
            IBlockData var9 = var0.getBlockState(var6.setWithOffset((BaseBlockPosition)var1, var8));
            if (!var9.is(var3.canBePlacedOn)) continue;
            GlowLichenBlock var10 = (GlowLichenBlock)Blocks.GLOW_LICHEN;
            IBlockData var11 = var10.getStateForPlacement(var2, var0, var1, var8);
            if (var11 == null) {
                return false;
            }
            var0.setBlock(var1, var11, 3);
            var0.getChunk(var1).markPosForPostprocessing(var1);
            if (var4.nextFloat() < var3.chanceOfSpreading) {
                var10.spreadFromFaceTowardRandomDirection(var11, var0, var1, var8, var4, true);
            }
            return true;
        }
        return false;
    }

    public static List<EnumDirection> getShuffledDirections(GlowLichenConfiguration var0, Random var1) {
        ArrayList var2 = Lists.newArrayList(var0.validDirections);
        Collections.shuffle(var2, var1);
        return var2;
    }

    public static List<EnumDirection> getShuffledDirectionsExcept(GlowLichenConfiguration var0, Random var12, EnumDirection var2) {
        List<EnumDirection> var3 = var0.validDirections.stream().filter(var1 -> var1 != var2).collect(Collectors.toList());
        Collections.shuffle(var3, var12);
        return var3;
    }

    private static boolean isAirOrWater(IBlockData var0) {
        return var0.isAir() || var0.is(Blocks.WATER);
    }
}

