/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;

public class WorldGenCaves
extends WorldGenCarverAbstract<CaveCarverConfiguration> {
    public WorldGenCaves(Codec<CaveCarverConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean isStartChunk(CaveCarverConfiguration var0, Random var1) {
        return var1.nextFloat() <= var0.probability;
    }

    @Override
    public boolean carve(CarvingContext var0, CaveCarverConfiguration var1, IChunkAccess var22, Function<BlockPosition, Holder<BiomeBase>> var32, Random var4, Aquifer var52, ChunkCoordIntPair var6, CarvingMask var72) {
        int var8 = SectionPosition.sectionToBlockCoord(this.getRange() * 2 - 1);
        int var92 = var4.nextInt(var4.nextInt(var4.nextInt(this.getCaveBound()) + 1) + 1);
        for (int var10 = 0; var10 < var92; ++var10) {
            float var27;
            double var11 = var6.getBlockX(var4.nextInt(16));
            double var13 = var1.y.sample(var4, var0);
            double var15 = var6.getBlockZ(var4.nextInt(16));
            double var17 = var1.horizontalRadiusMultiplier.sample(var4);
            double var19 = var1.verticalRadiusMultiplier.sample(var4);
            double var21 = var1.floorLevel.sample(var4);
            WorldGenCarverAbstract.a var23 = (var2, var3, var5, var7, var9) -> WorldGenCaves.shouldSkip(var3, var5, var7, var21);
            int var24 = 1;
            if (var4.nextInt(4) == 0) {
                double var25 = var1.yScale.sample(var4);
                var27 = 1.0f + var4.nextFloat() * 6.0f;
                this.createRoom(var0, var1, var22, var32, var52, var11, var13, var15, var27, var25, var72, var23);
                var24 += var4.nextInt(4);
            }
            for (int var25 = 0; var25 < var24; ++var25) {
                float var26 = var4.nextFloat() * ((float)Math.PI * 2);
                var27 = (var4.nextFloat() - 0.5f) / 4.0f;
                float var28 = this.getThickness(var4);
                int var29 = var8 - var4.nextInt(var8 / 4);
                boolean var30 = false;
                this.createTunnel(var0, var1, var22, var32, var4.nextLong(), var52, var11, var13, var15, var17, var19, var28, var26, var27, 0, var29, this.getYScale(), var72, var23);
            }
        }
        return true;
    }

    protected int getCaveBound() {
        return 15;
    }

    protected float getThickness(Random var0) {
        float var1 = var0.nextFloat() * 2.0f + var0.nextFloat();
        if (var0.nextInt(10) == 0) {
            var1 *= var0.nextFloat() * var0.nextFloat() * 3.0f + 1.0f;
        }
        return var1;
    }

    protected double getYScale() {
        return 1.0;
    }

    protected void createRoom(CarvingContext var0, CaveCarverConfiguration var1, IChunkAccess var2, Function<BlockPosition, Holder<BiomeBase>> var3, Aquifer var4, double var5, double var7, double var9, float var11, double var12, CarvingMask var14, WorldGenCarverAbstract.a var15) {
        double var16 = 1.5 + (double)(MathHelper.sin(1.5707964f) * var11);
        double var18 = var16 * var12;
        this.carveEllipsoid(var0, var1, var2, var3, var4, var5 + 1.0, var7, var9, var16, var18, var14, var15);
    }

    protected void createTunnel(CarvingContext var0, CaveCarverConfiguration var1, IChunkAccess var2, Function<BlockPosition, Holder<BiomeBase>> var3, long var4, Aquifer var6, double var7, double var9, double var11, double var13, double var15, float var17, float var18, float var19, int var20, int var21, double var22, CarvingMask var24, WorldGenCarverAbstract.a var25) {
        Random var26 = new Random(var4);
        int var27 = var26.nextInt(var21 / 2) + var21 / 4;
        boolean var28 = var26.nextInt(6) == 0;
        float var29 = 0.0f;
        float var30 = 0.0f;
        for (int var31 = var20; var31 < var21; ++var31) {
            double var32 = 1.5 + (double)(MathHelper.sin((float)Math.PI * (float)var31 / (float)var21) * var17);
            double var34 = var32 * var22;
            float var36 = MathHelper.cos(var19);
            var7 += (double)(MathHelper.cos(var18) * var36);
            var9 += (double)MathHelper.sin(var19);
            var11 += (double)(MathHelper.sin(var18) * var36);
            var19 *= var28 ? 0.92f : 0.7f;
            var19 += var30 * 0.1f;
            var18 += var29 * 0.1f;
            var30 *= 0.9f;
            var29 *= 0.75f;
            var30 += (var26.nextFloat() - var26.nextFloat()) * var26.nextFloat() * 2.0f;
            var29 += (var26.nextFloat() - var26.nextFloat()) * var26.nextFloat() * 4.0f;
            if (var31 == var27 && var17 > 1.0f) {
                this.createTunnel(var0, var1, var2, var3, var26.nextLong(), var6, var7, var9, var11, var13, var15, var26.nextFloat() * 0.5f + 0.5f, var18 - 1.5707964f, var19 / 3.0f, var31, var21, 1.0, var24, var25);
                this.createTunnel(var0, var1, var2, var3, var26.nextLong(), var6, var7, var9, var11, var13, var15, var26.nextFloat() * 0.5f + 0.5f, var18 + 1.5707964f, var19 / 3.0f, var31, var21, 1.0, var24, var25);
                return;
            }
            if (var26.nextInt(4) == 0) continue;
            if (!WorldGenCaves.canReach(var2.getPos(), var7, var11, var31, var21, var17)) {
                return;
            }
            this.carveEllipsoid(var0, var1, var2, var3, var6, var7, var9, var11, var32 * var13, var34 * var15, var24, var25);
        }
    }

    private static boolean shouldSkip(double var0, double var2, double var4, double var6) {
        if (var2 <= var6) {
            return true;
        }
        return var0 * var0 + var2 * var2 + var4 * var4 >= 1.0;
    }
}

