/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;

public record WorldGenCarverWrapper<WC extends WorldGenCarverConfiguration>(WorldGenCarverAbstract<WC> worldCarver, WC config) {
    public static final Codec<WorldGenCarverWrapper<?>> DIRECT_CODEC = IRegistry.CARVER.byNameCodec().dispatch(var0 -> var0.worldCarver, WorldGenCarverAbstract::configuredCodec);
    public static final Codec<Holder<WorldGenCarverWrapper<?>>> CODEC = RegistryFileCodec.create(IRegistry.CONFIGURED_CARVER_REGISTRY, DIRECT_CODEC);
    public static final Codec<HolderSet<WorldGenCarverWrapper<?>>> LIST_CODEC = RegistryCodecs.homogeneousList(IRegistry.CONFIGURED_CARVER_REGISTRY, DIRECT_CODEC);

    public boolean isStartChunk(Random var0) {
        return this.worldCarver.isStartChunk(this.config, var0);
    }

    public boolean carve(CarvingContext var0, IChunkAccess var1, Function<BlockPosition, Holder<BiomeBase>> var2, Random var3, Aquifer var4, ChunkCoordIntPair var5, CarvingMask var6) {
        if (SharedConstants.debugVoidTerrain(var1.getPos())) {
            return false;
        }
        return this.worldCarver.carve(var0, this.config, var1, var2, var3, var4, var5, var6);
    }
}

