/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Blender {
    private static final Blender EMPTY = new Blender(new Long2ObjectOpenHashMap(), new Long2ObjectOpenHashMap()){

        @Override
        public a blendOffsetAndFactor(int var0, int var1) {
            return new a(1.0, 0.0);
        }

        @Override
        public double blendDensity(DensityFunction.b var0, double var1) {
            return var1;
        }

        @Override
        public BiomeResolver getBiomeResolver(BiomeResolver var0) {
            return var0;
        }
    };
    private static final NoiseGeneratorNormal SHIFT_NOISE = NoiseGeneratorNormal.create(new XoroshiroRandomSource(42L), RegistryGeneration.NOISE.getOrThrow(Noises.SHIFT));
    private static final int HEIGHT_BLENDING_RANGE_CELLS = QuartPos.fromSection(7) - 1;
    private static final int HEIGHT_BLENDING_RANGE_CHUNKS = QuartPos.toSection(HEIGHT_BLENDING_RANGE_CELLS + 3);
    private static final int DENSITY_BLENDING_RANGE_CELLS = 2;
    private static final int DENSITY_BLENDING_RANGE_CHUNKS = QuartPos.toSection(5);
    private static final double OLD_CHUNK_Y_RADIUS = (double)BlendingData.AREA_WITH_OLD_GENERATION.getHeight() / 2.0;
    private static final double OLD_CHUNK_CENTER_Y = (double)BlendingData.AREA_WITH_OLD_GENERATION.getMinBuildHeight() + OLD_CHUNK_Y_RADIUS;
    private static final double OLD_CHUNK_XZ_RADIUS = 8.0;
    private final Long2ObjectOpenHashMap<BlendingData> blendingData;
    private final Long2ObjectOpenHashMap<BlendingData> blendingDataForDensityBlending;

    public static Blender empty() {
        return EMPTY;
    }

    public static Blender of(@Nullable RegionLimitedWorldAccess var0) {
        if (var0 == null) {
            return EMPTY;
        }
        Long2ObjectOpenHashMap var1 = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap var2 = new Long2ObjectOpenHashMap();
        ChunkCoordIntPair var3 = var0.getCenter();
        for (int var4 = -HEIGHT_BLENDING_RANGE_CHUNKS; var4 <= HEIGHT_BLENDING_RANGE_CHUNKS; ++var4) {
            for (int var5 = -HEIGHT_BLENDING_RANGE_CHUNKS; var5 <= HEIGHT_BLENDING_RANGE_CHUNKS; ++var5) {
                int var6 = var3.x + var4;
                int var7 = var3.z + var5;
                BlendingData var8 = BlendingData.getOrUpdateBlendingData(var0, var6, var7);
                if (var8 == null) continue;
                var1.put(ChunkCoordIntPair.asLong(var6, var7), (Object)var8);
                if (var4 < -DENSITY_BLENDING_RANGE_CHUNKS || var4 > DENSITY_BLENDING_RANGE_CHUNKS || var5 < -DENSITY_BLENDING_RANGE_CHUNKS || var5 > DENSITY_BLENDING_RANGE_CHUNKS) continue;
                var2.put(ChunkCoordIntPair.asLong(var6, var7), (Object)var8);
            }
        }
        if (var1.isEmpty() && var2.isEmpty()) {
            return EMPTY;
        }
        return new Blender((Long2ObjectOpenHashMap<BlendingData>)var1, (Long2ObjectOpenHashMap<BlendingData>)var2);
    }

    Blender(Long2ObjectOpenHashMap<BlendingData> var0, Long2ObjectOpenHashMap<BlendingData> var1) {
        this.blendingData = var0;
        this.blendingDataForDensityBlending = var1;
    }

    public a blendOffsetAndFactor(int var0, int var1) {
        int var3;
        int var2 = QuartPos.fromBlock(var0);
        double var4 = this.getBlendingDataValue(var2, 0, var3 = QuartPos.fromBlock(var1), BlendingData::getHeight);
        if (var4 != Double.MAX_VALUE) {
            return new a(0.0, Blender.heightToOffset(var4));
        }
        MutableDouble var6 = new MutableDouble(0.0);
        MutableDouble var7 = new MutableDouble(0.0);
        MutableDouble var8 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.blendingData.forEach((var52, var62) -> var62.iterateHeights(QuartPos.fromSection(ChunkCoordIntPair.getX(var52)), QuartPos.fromSection(ChunkCoordIntPair.getZ(var52)), (var5, var6, var7) -> {
            double var9 = MathHelper.length(var2 - var5, var3 - var6);
            if (var9 > (double)HEIGHT_BLENDING_RANGE_CELLS) {
                return;
            }
            if (var9 < var8.doubleValue()) {
                var8.setValue(var9);
            }
            double var11 = 1.0 / (var9 * var9 * var9 * var9);
            var7.add(var7 * var11);
            var6.add(var11);
        }));
        if (var8.doubleValue() == Double.POSITIVE_INFINITY) {
            return new a(1.0, 0.0);
        }
        double var9 = var7.doubleValue() / var6.doubleValue();
        double var11 = MathHelper.clamp(var8.doubleValue() / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        var11 = 3.0 * var11 * var11 - 2.0 * var11 * var11 * var11;
        return new a(var11, Blender.heightToOffset(var9));
    }

    private static double heightToOffset(double var0) {
        double var2 = 1.0;
        double var4 = var0 + 0.5;
        double var6 = MathHelper.positiveModulo(var4, 8.0);
        return 1.0 * (32.0 * (var4 - 128.0) - 3.0 * (var4 - 120.0) * var6 + 3.0 * var6 * var6) / (128.0 * (32.0 - 3.0 * var6));
    }

    public double blendDensity(DensityFunction.b var0, double var1) {
        int var5;
        int var4;
        int var3 = QuartPos.fromBlock(var0.blockX());
        double var6 = this.getBlendingDataValue(var3, var4 = var0.blockY() / 8, var5 = QuartPos.fromBlock(var0.blockZ()), BlendingData::getDensity);
        if (var6 != Double.MAX_VALUE) {
            return var6;
        }
        MutableDouble var8 = new MutableDouble(0.0);
        MutableDouble var9 = new MutableDouble(0.0);
        MutableDouble var10 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.blendingDataForDensityBlending.forEach((var62, var72) -> var72.iterateDensities(QuartPos.fromSection(ChunkCoordIntPair.getX(var62)), QuartPos.fromSection(ChunkCoordIntPair.getZ(var62)), var4 - 1, var4 + 1, (var6, var7, var8, var9) -> {
            double var11 = MathHelper.length(var3 - var6, (var4 - var7) * 2, var5 - var8);
            if (var11 > 2.0) {
                return;
            }
            if (var11 < var10.doubleValue()) {
                var10.setValue(var11);
            }
            double var13 = 1.0 / (var11 * var11 * var11 * var11);
            var9.add(var9 * var13);
            var8.add(var13);
        }));
        if (var10.doubleValue() == Double.POSITIVE_INFINITY) {
            return var1;
        }
        double var11 = var9.doubleValue() / var8.doubleValue();
        double var13 = MathHelper.clamp(var10.doubleValue() / 3.0, 0.0, 1.0);
        return MathHelper.lerp(var13, var11, var1);
    }

    private double getBlendingDataValue(int var0, int var1, int var2, b var3) {
        int var4 = QuartPos.toSection(var0);
        int var5 = QuartPos.toSection(var2);
        boolean var6 = (var0 & 3) == 0;
        boolean var7 = (var2 & 3) == 0;
        double var8 = this.getBlendingDataValue(var3, var4, var5, var0, var1, var2);
        if (var8 == Double.MAX_VALUE) {
            if (var6 && var7) {
                var8 = this.getBlendingDataValue(var3, var4 - 1, var5 - 1, var0, var1, var2);
            }
            if (var8 == Double.MAX_VALUE) {
                if (var6) {
                    var8 = this.getBlendingDataValue(var3, var4 - 1, var5, var0, var1, var2);
                }
                if (var8 == Double.MAX_VALUE && var7) {
                    var8 = this.getBlendingDataValue(var3, var4, var5 - 1, var0, var1, var2);
                }
            }
        }
        return var8;
    }

    private double getBlendingDataValue(b var0, int var1, int var2, int var3, int var4, int var5) {
        BlendingData var6 = (BlendingData)this.blendingData.get(ChunkCoordIntPair.asLong(var1, var2));
        if (var6 != null) {
            return var0.get(var6, var3 - QuartPos.fromSection(var1), var4, var5 - QuartPos.fromSection(var2));
        }
        return Double.MAX_VALUE;
    }

    public BiomeResolver getBiomeResolver(BiomeResolver var0) {
        return (var1, var2, var3, var4) -> {
            Holder<BiomeBase> var5 = this.blendBiome(var1, var3);
            if (var5 == null) {
                return var0.getNoiseBiome(var1, var2, var3, var4);
            }
            return var5;
        };
    }

    @Nullable
    private Holder<BiomeBase> blendBiome(int var0, int var1) {
        double var2 = (double)var0 + SHIFT_NOISE.getValue(var0, 0.0, var1) * 12.0;
        double var4 = (double)var1 + SHIFT_NOISE.getValue(var1, var0, 0.0) * 12.0;
        MutableDouble var6 = new MutableDouble(Double.POSITIVE_INFINITY);
        MutableObject var7 = new MutableObject();
        this.blendingData.forEach((var62, var72) -> var72.iterateBiomes(QuartPos.fromSection(ChunkCoordIntPair.getX(var62)), QuartPos.fromSection(ChunkCoordIntPair.getZ(var62)), (var6, var7, var8) -> {
            double var9 = MathHelper.length(var2 - (double)var6, var4 - (double)var7);
            if (var9 > (double)HEIGHT_BLENDING_RANGE_CELLS) {
                return;
            }
            if (var9 < var6.doubleValue()) {
                var7.setValue((Object)var8);
                var6.setValue(var9);
            }
        }));
        if (var6.doubleValue() == Double.POSITIVE_INFINITY) {
            return null;
        }
        double var8 = MathHelper.clamp(var6.doubleValue() / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        if (var8 > 0.5) {
            return null;
        }
        return (Holder)var7.getValue();
    }

    public static void generateBorderTicks(RegionLimitedWorldAccess var0, IChunkAccess var1) {
        ChunkCoordIntPair var2 = var1.getPos();
        boolean var3 = var1.isOldNoiseGeneration();
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        BlockPosition var5 = new BlockPosition(var2.getMinBlockX(), 0, var2.getMinBlockZ());
        int var6 = BlendingData.AREA_WITH_OLD_GENERATION.getMinBuildHeight();
        int var7 = BlendingData.AREA_WITH_OLD_GENERATION.getMaxBuildHeight() - 1;
        if (var3) {
            for (int var8 = 0; var8 < 16; ++var8) {
                for (int var9 = 0; var9 < 16; ++var9) {
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var6 - 1, var9));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var6, var9));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var7, var9));
                    Blender.generateBorderTick(var1, var4.setWithOffset(var5, var8, var7 + 1, var9));
                }
            }
        }
        for (EnumDirection var9 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (var0.getChunk(var2.x + var9.getStepX(), var2.z + var9.getStepZ()).isOldNoiseGeneration() == var3) continue;
            int var10 = var9 == EnumDirection.EAST ? 15 : 0;
            int var11 = var9 == EnumDirection.WEST ? 0 : 15;
            int var12 = var9 == EnumDirection.SOUTH ? 15 : 0;
            int var13 = var9 == EnumDirection.NORTH ? 0 : 15;
            for (int var14 = var10; var14 <= var11; ++var14) {
                for (int var15 = var12; var15 <= var13; ++var15) {
                    int var16 = Math.min(var7, var1.getHeight(HeightMap.Type.MOTION_BLOCKING, var14, var15)) + 1;
                    for (int var17 = var6; var17 < var16; ++var17) {
                        Blender.generateBorderTick(var1, var4.setWithOffset(var5, var14, var17, var15));
                    }
                }
            }
        }
    }

    private static void generateBorderTick(IChunkAccess var0, BlockPosition var1) {
        Fluid var3;
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.is(TagsBlock.LEAVES)) {
            var0.markPosForPostprocessing(var1);
        }
        if (!(var3 = var0.getFluidState(var1)).isEmpty()) {
            var0.markPosForPostprocessing(var1);
        }
    }

    public static void addAroundOldChunksCarvingMaskFilter(GeneratorAccessSeed var0, ProtoChunk var12) {
        ChunkCoordIntPair var22 = var12.getPos();
        c var32 = Blender.makeOldChunkDistanceGetter(var12.isOldNoiseGeneration(), BlendingData.sideByGenerationAge(var0, var22.x, var22.z, true));
        if (var32 == null) {
            return;
        }
        CarvingMask.a var4 = (var1, var2, var3) -> {
            double var8;
            double var6;
            double var4 = (double)var1 + 0.5 + SHIFT_NOISE.getValue(var1, var2, var3) * 4.0;
            return var32.getDistance(var4, var6 = (double)var2 + 0.5 + SHIFT_NOISE.getValue(var2, var3, var1) * 4.0, var8 = (double)var3 + 0.5 + SHIFT_NOISE.getValue(var3, var1, var2) * 4.0) < 4.0;
        };
        Stream.of(WorldGenStage.Features.values()).map(var12::getOrCreateCarvingMask).forEach(var1 -> var1.setAdditionalMask(var4));
    }

    @Nullable
    public static c makeOldChunkDistanceGetter(boolean var0, Set<EnumDirection8> var12) {
        if (!var0 && var12.isEmpty()) {
            return null;
        }
        ArrayList var2 = Lists.newArrayList();
        if (var0) {
            var2.add(Blender.makeOffsetOldChunkDistanceGetter(null));
        }
        var12.forEach(var1 -> var2.add(Blender.makeOffsetOldChunkDistanceGetter(var1)));
        return (var1, var3, var5) -> {
            double var7 = Double.POSITIVE_INFINITY;
            for (c var10 : var2) {
                double var11 = var10.getDistance(var1, var3, var5);
                if (!(var11 < var7)) continue;
                var7 = var11;
            }
            return var7;
        };
    }

    private static c makeOffsetOldChunkDistanceGetter(@Nullable EnumDirection8 var0) {
        double var1 = 0.0;
        double var3 = 0.0;
        if (var0 != null) {
            for (EnumDirection var62 : var0.getDirections()) {
                var1 += (double)(var62.getStepX() * 16);
                var3 += (double)(var62.getStepZ() * 16);
            }
        }
        double var5 = var1;
        double var7 = var3;
        return (var4, var6, var8) -> Blender.distanceToCube(var4 - 8.0 - var5, var6 - OLD_CHUNK_CENTER_Y, var8 - 8.0 - var7, 8.0, OLD_CHUNK_Y_RADIUS, 8.0);
    }

    private static double distanceToCube(double var0, double var2, double var4, double var6, double var8, double var10) {
        double var12 = Math.abs(var0) - var6;
        double var14 = Math.abs(var2) - var8;
        double var16 = Math.abs(var4) - var10;
        return MathHelper.length(Math.max(0.0, var12), Math.max(0.0, var14), Math.max(0.0, var16));
    }

    static interface b {
        public double get(BlendingData var1, int var2, int var3, int var4);
    }

    public record a(double alpha, double blendingOffset) {
    }

    public static interface c {
        public double getDistance(double var1, double var3, double var5);
    }
}

